/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.composer.importer;

import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jiemamy.JiemamyContext;
import org.jiemamy.composer.AbstractImporter;
import org.jiemamy.composer.ImportException;
import org.jiemamy.composer.importer.DbImportConfig;
import org.jiemamy.composer.importer.SimpleDbImportConfig;
import org.jiemamy.dialect.DatabaseMetadataParser;
import org.jiemamy.dialect.Dialect;
import org.jiemamy.utils.sql.DriverNotFoundException;
import org.jiemamy.utils.sql.DriverUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbImporter
extends AbstractImporter<DbImportConfig> {
    public static final String DIALECT = "dialect";
    public static final String DATABASE_NAME = "databaseName";
    public static final String DRIVER_JAR_PATHS = "driverJarPaths";
    public static final String DRIVER_CLASS_NAME = "driverClassName";
    public static final String URI = "uri";
    public static final String SCHEMA = "schema";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String SELECTED_ENTITIES = "selectedEntities";
    public static final String ENTITY_TYPES = "entityTypes";

    @Override
    public String getName() {
        return "Database Importer (core)";
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean importModel(JiemamyContext context, DbImportConfig config) throws ImportException {
        Validate.notNull((Object)context);
        Validate.notNull((Object)config);
        Validate.notNull((Object)config.getUri());
        Properties props = new Properties();
        props.setProperty("user", config.getUsername());
        props.setProperty(PASSWORD, config.getPassword());
        Connection connection = null;
        try {
            URL[] paths = config.getDriverJarPaths();
            String className = config.getDriverClassName();
            Driver driver = DriverUtil.getDriverInstance((URL[])paths, (String)className);
            connection = driver.connect(config.getUri(), props);
            DatabaseMetaData meta = connection.getMetaData();
            Dialect dialect = config.getDialect();
            DatabaseMetadataParser parser = dialect.getDatabaseMetadataParser();
            parser.parseMetadata(context, meta, config);
        }
        catch (DriverNotFoundException e) {
            try {
                throw new ImportException(e);
                catch (InstantiationException e2) {
                    throw new ImportException(e2);
                }
                catch (IllegalAccessException e3) {
                    throw new ImportException(e3);
                }
                catch (IOException e4) {
                    throw new ImportException(e4);
                }
                catch (SQLException e5) {
                    throw new ImportException(e5);
                }
                catch (Exception e6) {
                    throw new ImportException(e6);
                }
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(connection);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Connection)connection);
        return true;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    protected DbImportConfig newSimpleConfigInstance() {
        return new SimpleDbImportConfig();
    }
}

