/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import javax.xml.namespace.NamespaceContext;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.Validate;
import org.jiemamy.FacetProvider;
import org.jiemamy.JiemamyFacet;
import org.jiemamy.JmMetadata;
import org.jiemamy.ServiceLocator;
import org.jiemamy.ServiceNotFoundException;
import org.jiemamy.SimpleJmMetadata;
import org.jiemamy.SimpleServiceLocator;
import org.jiemamy.Version;
import org.jiemamy.dddbase.Entity;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.dddbase.EntityResolver;
import org.jiemamy.dddbase.OnMemoryCompositeEntityResolver;
import org.jiemamy.dddbase.OnMemoryEntityResolver;
import org.jiemamy.dddbase.OnMemoryRepository;
import org.jiemamy.dddbase.OrderedEntity;
import org.jiemamy.dddbase.OrderedOnMemoryRepository;
import org.jiemamy.dddbase.Repository;
import org.jiemamy.dddbase.utils.MutationMonitor;
import org.jiemamy.dialect.Dialect;
import org.jiemamy.model.DbObject;
import org.jiemamy.model.dataset.JmDataSet;
import org.jiemamy.model.domain.JmDomain;
import org.jiemamy.model.index.JmIndex;
import org.jiemamy.model.table.JmTable;
import org.jiemamy.model.table.TableNotFoundException;
import org.jiemamy.model.table.TooManyTablesFoundException;
import org.jiemamy.model.view.JmView;
import org.jiemamy.serializer.JiemamySerializer;
import org.jiemamy.serializer.stax.JiemamyStaxSerializer;
import org.jiemamy.transaction.EventBroker;
import org.jiemamy.transaction.EventBrokerImpl;
import org.jiemamy.transaction.StoredEvent;
import org.jiemamy.utils.LogMarker;
import org.jiemamy.utils.UUIDProvider;
import org.jiemamy.utils.reflect.ClassUtil;
import org.jiemamy.xml.CoreNamespace;
import org.jiemamy.xml.JiemamyNamespace;
import org.jiemamy.xml.JiemamyNamespaceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiemamyContext
implements EntityResolver {
    private static Logger logger = LoggerFactory.getLogger(JiemamyContext.class);
    private static boolean debug = JiemamyContext.getVersion().isSnapshot();
    private static ServiceLocator serviceLocator = new SimpleServiceLocator();
    private static String serializerName = JiemamyStaxSerializer.class.getName();
    private Map<Class<? extends JiemamyFacet>, JiemamyFacet> facets = Maps.newHashMap();
    private OnMemoryRepository<DbObject> dbObjects = new OnMemoryRepository();
    private OrderedOnMemoryRepository<JmDataSet> dataSets = new OrderedOnMemoryRepository();
    private JmMetadata metadata = new SimpleJmMetadata();
    private final UUIDProvider uuidProvider = new UUIDProvider();
    private final EventBroker eventBroker = new EventBrokerImpl();

    public static JiemamySerializer findSerializer() {
        try {
            ServiceLocator sl = JiemamyContext.getServiceLocator();
            return sl.getService(JiemamySerializer.class, serializerName);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceNotFoundException("", e);
        }
    }

    public static ServiceLocator getServiceLocator() {
        return serviceLocator;
    }

    public static Version getVersion() {
        return Version.INSTANCE;
    }

    public static boolean isDebug() {
        return debug;
    }

    public static void setDebug(boolean debug) {
        JiemamyContext.debug = debug;
    }

    public static void setSerializerName(String serializerName) {
        Validate.notNull((Object)serializerName);
        JiemamyContext.serializerName = serializerName;
    }

    public static void setServiceLocator(ServiceLocator serviceLocator) {
        Validate.notNull((Object)serviceLocator);
        JiemamyContext.serviceLocator = serviceLocator;
    }

    public JiemamyContext() {
        this(new FacetProvider[0]);
    }

    public JiemamyContext(FacetProvider ... facetProviders) {
        Validate.noNullElements((Object[])facetProviders);
        for (FacetProvider facetProvider : facetProviders) {
            this.facets.put(facetProvider.getFacetType(), facetProvider.getFacet(this));
        }
        logger.trace((Marker)LogMarker.LIFECYCLE, "new context created (debug={})", (Object)JiemamyContext.isDebug());
    }

    public boolean contains(EntityRef<?> reference) {
        Validate.notNull(reference);
        return this.contains(reference.getReferentId());
    }

    public boolean contains(UUID id) {
        Validate.notNull((Object)id);
        return this.getCompositeResolver().contains(id);
    }

    public JmDataSet deleteDataSet(EntityRef<? extends JmDataSet> reference) {
        Validate.notNull(reference);
        JmDataSet deleted = (JmDataSet)this.dataSets.delete(reference);
        logger.debug((Marker)LogMarker.LIFECYCLE, "dataset deleted: " + deleted);
        this.eventBroker.fireEvent(new StoredEvent<Object>((Repository<Object>)this.dataSets, deleted, null));
        return deleted;
    }

    public DbObject deleteDbObject(EntityRef<? extends DbObject> reference) {
        Validate.notNull(reference);
        DbObject deleted = (DbObject)this.dbObjects.delete(reference);
        logger.debug((Marker)LogMarker.LIFECYCLE, "dbObject deleted: " + deleted);
        this.eventBroker.fireEvent(new StoredEvent<Object>((Repository<Object>)this.dbObjects, deleted, null));
        return deleted;
    }

    public Dialect findDialect() throws ClassNotFoundException {
        if (this.metadata == null) {
            throw new IllegalStateException("metadata is null");
        }
        if (this.metadata.getDialectClassName() == null) {
            throw new IllegalStateException("metadata.dialectClassName is null");
        }
        return JiemamyContext.getServiceLocator().getService(Dialect.class, this.metadata.getDialectClassName());
    }

    public Set<DbObject> findSubDbObjectsNonRecursive(DbObject dbObject) {
        Validate.notNull((Object)dbObject);
        return dbObject.findSubDbObjectsNonRecursive(this);
    }

    public Set<DbObject> findSubDbObjectsRecursive(DbObject dbObject) {
        Validate.notNull((Object)dbObject);
        Set<DbObject> subDbObjects = this.findSubDbObjectsNonRecursive(dbObject);
        HashSet result = Sets.newHashSet(subDbObjects);
        for (DbObject subDbObject : subDbObjects) {
            if (dbObject.equals(subDbObject)) continue;
            result.addAll(this.findSubDbObjectsRecursive(subDbObject));
        }
        return result;
    }

    public Set<DbObject> findSuperDbObjectsNonRecursive(DbObject dbOjbect) {
        Validate.notNull((Object)dbOjbect);
        return dbOjbect.findSuperDbObjectsNonRecursive(this.getDbObjects());
    }

    public Set<DbObject> findSuperDbObjectsRecursive(DbObject dbOjbect) {
        Validate.notNull((Object)dbOjbect);
        return this.findSuperDbObjectsRecursive(dbOjbect, dbOjbect, new HashSet<DbObject>());
    }

    public List<JmDataSet> getDataSets() {
        return this.dataSets.getEntitiesAsList();
    }

    public Set<DbObject> getDbObjects() {
        return this.dbObjects.getEntitiesAsSet();
    }

    public <T extends DbObject> Set<T> getDbObjects(Class<T> clazz) {
        Validate.notNull(clazz);
        HashSet result = Sets.newHashSet((Iterable)Iterables.filter((Iterable)this.dbObjects.getEntitiesAsSet(), clazz));
        return MutationMonitor.monitor((Set)result);
    }

    public Set<JmDomain> getDomains() {
        return this.getDbObjects(JmDomain.class);
    }

    public EventBroker getEventBroker() {
        return this.eventBroker;
    }

    public <T extends JiemamyFacet> T getFacet(Class<T> clazz) {
        Validate.notNull(clazz);
        if (!this.hasFacet(clazz)) {
            throw new IllegalStateException();
        }
        return (T)((JiemamyFacet)clazz.cast(this.facets.get(clazz)));
    }

    public Set<JiemamyFacet> getFacets() {
        return MutationMonitor.monitor((Set)Sets.newHashSet(this.facets.values()));
    }

    public Set<JmIndex> getIndexes() {
        return this.getDbObjects(JmIndex.class);
    }

    public JmMetadata getMetadata() {
        return this.metadata.clone();
    }

    public NamespaceContext getNamespaceContext() {
        return new JiemamyNamespaceContext(this.getNamespaces());
    }

    public JiemamyNamespace[] getNamespaces() {
        ArrayList namespaces = Lists.newArrayList();
        namespaces.addAll(Arrays.asList(CoreNamespace.values()));
        for (JiemamyFacet facet : this.getFacets()) {
            namespaces.addAll(Arrays.asList(facet.getNamespaces()));
        }
        return namespaces.toArray(new JiemamyNamespace[namespaces.size()]);
    }

    public JmTable getTable(final String name) {
        Collection c = Collections2.filter(this.getTables(), (Predicate)new Predicate<JmTable>(){

            public boolean apply(JmTable input) {
                return ObjectUtils.equals((Object)input.getName(), (Object)name);
            }
        });
        try {
            return (JmTable)Iterables.getOnlyElement((Iterable)c);
        }
        catch (NoSuchElementException e) {
            throw new TableNotFoundException("name=" + name);
        }
        catch (IllegalArgumentException e) {
            throw new TooManyTablesFoundException(c);
        }
    }

    public Set<JmTable> getTables() {
        return this.getDbObjects(JmTable.class);
    }

    public Set<JmView> getViews() {
        return this.getDbObjects(JmView.class);
    }

    public <T extends JiemamyFacet> boolean hasFacet(Class<T> clazz) {
        return this.facets.containsKey(clazz);
    }

    public <T extends Entity> T resolve(EntityRef<T> reference) {
        Validate.notNull(reference);
        return (T)this.getCompositeResolver().resolve(reference);
    }

    public Entity resolve(UUID id) {
        Validate.notNull((Object)id);
        return this.getCompositeResolver().resolve(id);
    }

    public void setMetadata(JmMetadata metadata) {
        Validate.notNull((Object)metadata);
        this.metadata = metadata.clone();
    }

    public void store(DbObject dbObject) {
        Validate.notNull((Object)dbObject);
        DbObject old = (DbObject)this.dbObjects.store((Entity)dbObject);
        if (old == null) {
            logger.debug((Marker)LogMarker.LIFECYCLE, "dbObject stored: " + dbObject);
        } else {
            logger.debug((Marker)LogMarker.LIFECYCLE, "dbObject updated: (old) " + old);
            logger.debug((Marker)LogMarker.LIFECYCLE, "                  (new) " + dbObject);
        }
        this.eventBroker.fireEvent(new StoredEvent<DbObject>((Repository<DbObject>)this.dbObjects, old, dbObject));
    }

    public void store(JmDataSet dataSet) {
        Validate.notNull((Object)dataSet);
        JmDataSet old = (JmDataSet)this.dataSets.store((OrderedEntity)dataSet);
        if (old == null) {
            logger.debug((Marker)LogMarker.LIFECYCLE, "dataset stored: " + dataSet);
        } else {
            logger.debug((Marker)LogMarker.LIFECYCLE, "dataset updated: (old) " + old);
            logger.debug((Marker)LogMarker.LIFECYCLE, "                 (new) " + dataSet);
        }
        this.eventBroker.fireEvent(new StoredEvent<JmDataSet>((Repository<JmDataSet>)this.dataSets, old, dataSet));
    }

    public void swapDataSet(int index1, int index2) {
        this.dataSets.swap(index1, index2);
        this.eventBroker.fireEvent(new StoredEvent<Object>((Repository<Object>)this.dataSets, null, null));
    }

    public String toString() {
        return ClassUtil.getShortClassName(this.getClass()) + "@" + Integer.toHexString(this.hashCode());
    }

    public UUID toUUID(String name) {
        return this.uuidProvider.valueOfOrRandom(name);
    }

    private Set<DbObject> findSuperDbObjectsRecursive(DbObject start, DbObject target, Set<DbObject> collector) {
        Set<DbObject> superDbObjects = this.findSuperDbObjectsNonRecursive(target);
        collector.addAll(superDbObjects);
        for (DbObject superDbObject : superDbObjects) {
            if (superDbObject.equals(target) || superDbObject.equals(start)) continue;
            this.findSuperDbObjectsRecursive(start, superDbObject, collector);
        }
        return collector;
    }

    private OnMemoryCompositeEntityResolver getCompositeResolver() {
        ArrayList c = Lists.newArrayList();
        c.add(this.dbObjects);
        c.add(this.dataSets);
        for (JiemamyFacet facet : this.facets.values()) {
            c.add(facet.getResolver());
        }
        return new OnMemoryCompositeEntityResolver(c.toArray(new OnMemoryEntityResolver[c.size()]));
    }

    static {
        MutationMonitor.setDebug((boolean)debug);
    }
}

