/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils.swap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Comparator;
import java.util.TreeSet;
import org.jiemamy.utils.LogMarker;
import org.jiemamy.utils.swap.ReferenceEvent;
import org.jiemamy.utils.swap.ReferenceListener;
import org.jiemamy.utils.swap.ReferenceQueueMonitor;
import org.jiemamy.utils.swap.SwapException;
import org.jiemamy.utils.swap.SwapObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Swapper
implements ReferenceListener {
    static final String SWAP_FILE_PREFIX = "jiemamy";
    static final String SWAP_FILE_SUFFIX = null;
    static final Swapper INSTANCE = new Swapper();
    private static Logger logger = LoggerFactory.getLogger(Swapper.class);
    final FileChannel channel;
    final TreeSet<Reference<SwapObject<?>>> swapRefSet;
    final ReferenceQueue<SwapObject<?>> swapRefQueue;

    private Swapper() {
        try {
            File tmpFile = File.createTempFile(SWAP_FILE_PREFIX, SWAP_FILE_SUFFIX);
            tmpFile.deleteOnExit();
            this.channel = new RandomAccessFile(tmpFile, "rw").getChannel();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.swapRefSet = new TreeSet(new SetComparator());
        this.swapRefQueue = new ReferenceQueue();
        ReferenceQueueMonitor monitor = new ReferenceQueueMonitor(this.swapRefQueue);
        monitor.addReferenceListener(this);
        Thread t = new Thread(monitor, "SwapObjectReferenceQueueMonitor");
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void referenceModified(ReferenceEvent event) {
        TreeSet<Reference<SwapObject<?>>> treeSet = this.swapRefSet;
        synchronized (treeSet) {
            this.swapRefSet.remove(event.getSource());
            if (this.swapRefSet.size() > 0) {
                SwapObject<?> swapObj = this.swapRefSet.last().get();
                if (swapObj != null) {
                    FileChannel fileChannel = this.channel;
                    synchronized (fileChannel) {
                        try {
                            this.channel.truncate(swapObj.position + (long)swapObj.length);
                        }
                        catch (IOException e) {
                            logger.error((Marker)LogMarker.BOUNDARY, "Error truncating swap file channel.", (Throwable)e);
                        }
                    }
                }
            } else {
                FileChannel fileChannel = this.channel;
                synchronized (fileChannel) {
                    try {
                        this.channel.truncate(0L);
                    }
                    catch (IOException e) {
                        logger.error((Marker)LogMarker.BOUNDARY, "Error truncating swap file channel.", (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends Serializable> T deserialize(SwapObject<T> swapObj) throws SwapException {
        byte[] buf;
        if (!this.swapRefSet.contains(new WeakReference<SwapObject<T>>(swapObj))) {
            throw new SwapException("Unknown swap info.");
        }
        ByteBuffer buffer = ByteBuffer.allocate(swapObj.length);
        int length = -1;
        try {
            FileChannel fileChannel = this.channel;
            synchronized (fileChannel) {
                length = this.channel.read(buffer, swapObj.position);
            }
        }
        catch (IOException e) {
            throw new SwapException(e);
        }
        if (length != swapObj.length) {
            throw new SwapException("Loaded size is not matched.");
        }
        buffer.flip();
        Serializable obj = null;
        ObjectInputStream ois = null;
        if (buffer.hasArray()) {
            buf = buffer.array();
        } else {
            buf = new byte[buffer.limit()];
            buffer.get(buf);
        }
        try {
            ois = new ObjectInputStream(new ByteArrayInputStream(buf));
            obj = (Serializable)ois.readObject();
        }
        catch (IOException e) {
            throw new SwapException(e);
        }
        catch (ClassNotFoundException e) {
            throw new SwapException(e);
        }
        catch (ClassCastException e) {
            throw new SwapException(e);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e) {
                throw new SwapException(e);
            }
        }
        return (T)obj;
    }

    <T extends Serializable> void reserialize(SwapObject<T> swapObj, T obj) throws SwapException {
        this.swapRefSet.remove(new WeakReference<SwapObject<T>>(swapObj));
        this.serialize(swapObj, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends Serializable> void serialize(SwapObject<T> swapObj, T obj) throws SwapException {
        ByteBuffer buffer = this.serialize(obj);
        TreeSet<Reference<SwapObject<?>>> treeSet = this.swapRefSet;
        synchronized (treeSet) {
            long pos = 0L;
            for (Reference<SwapObject<?>> ref : this.swapRefSet) {
                SwapObject<?> tmp = ref.get();
                if (tmp == null) continue;
                if (tmp.position - pos >= (long)buffer.limit()) break;
                pos = tmp.position + (long)tmp.length;
            }
            swapObj.position = pos;
            swapObj.length = buffer.limit();
            WeakReference ref = new WeakReference(swapObj, this.swapRefQueue);
            this.swapRefSet.add(ref);
        }
        this.swap(buffer, swapObj.position);
    }

    private ByteBuffer serialize(Serializable obj) throws SwapException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
        }
        catch (IOException e) {
            throw new SwapException(e);
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException e) {
                throw new SwapException(e);
            }
        }
        return ByteBuffer.wrap(baos.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swap(ByteBuffer buffer, long position) throws SwapException {
        FileChannel fileChannel = this.channel;
        synchronized (fileChannel) {
            try {
                this.channel.write(buffer, position);
            }
            catch (IOException e) {
                throw new SwapException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetComparator
    implements Comparator<Reference<SwapObject<?>>> {
        private SetComparator() {
        }

        @Override
        public int compare(Reference<SwapObject<?>> o1, Reference<SwapObject<?>> o2) {
            SwapObject<?> s1 = o1.get();
            SwapObject<?> s2 = o2.get();
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null) {
                return 1;
            }
            if (s2 == null) {
                return -1;
            }
            return (int)(s1.position - s2.position);
        }
    }
}

