/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils.swap;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.jiemamy.utils.swap.SwapException;
import org.jiemamy.utils.swap.Swapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwapObject<T extends Serializable> {
    long position;
    int length;
    Reference<T> ref;

    public SwapObject(T obj) throws SwapException {
        this.ref = new WeakReference<T>(obj);
        Swapper.INSTANCE.serialize(this, obj);
    }

    public synchronized T get() throws SwapException {
        Serializable obj = (Serializable)this.ref.get();
        if (obj == null) {
            obj = Swapper.INSTANCE.deserialize(this);
            this.ref = new WeakReference<Serializable>(obj);
        }
        return (T)obj;
    }

    public synchronized void update(T obj) throws SwapException {
        this.ref = new WeakReference<T>(obj);
        Swapper.INSTANCE.reserialize(this, obj);
    }
}

