/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils.sql.metadata;

import java.sql.ResultSet;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jiemamy.utils.sql.ResultSetUtil;

public class TypeInfoMeta {
    public final String typeName;
    public final int dataType;
    public final int precision;
    public final String literalPrefix;
    public final String literalSuffix;
    public final String createParams;
    public final Nullable nullable;
    public final boolean caseSensitive;
    public final Searchable searchable;
    public final boolean unsignedAttribute;
    public final boolean fixedPrecScale;
    public final boolean autoIncrement;
    public final String localTypeName;
    public final short minimumScale;
    public final short maximumScale;
    public final int sqlDataType;
    public final int sqlDatetimeSub;
    public final int numPrecRadix;

    TypeInfoMeta(ResultSet typeInfo) {
        Validate.notNull((Object)typeInfo);
        this.typeName = ResultSetUtil.getValue(String.class, typeInfo, "TYPE_NAME", null);
        this.dataType = ResultSetUtil.getValue(Integer.TYPE, typeInfo, "DATA_TYPE", Integer.valueOf(0));
        this.precision = ResultSetUtil.getValue(Integer.TYPE, typeInfo, "PRECISION", Integer.valueOf(0));
        this.literalPrefix = ResultSetUtil.getValue(String.class, typeInfo, "LITERAL_PREFIX", null);
        this.literalSuffix = ResultSetUtil.getValue(String.class, typeInfo, "LITERAL_SUFFIX", null);
        this.createParams = ResultSetUtil.getValue(String.class, typeInfo, "CREATE_PARAMS", null);
        this.nullable = Nullable.getNullable(ResultSetUtil.getValue(Short.TYPE, typeInfo, "NULLABLE", Short.valueOf((short)0)));
        this.caseSensitive = ResultSetUtil.getValue(Boolean.TYPE, typeInfo, "CASE_SENSITIVE", Boolean.valueOf(false));
        this.searchable = Searchable.getSearchable(ResultSetUtil.getValue(Short.TYPE, typeInfo, "SEARCHABLE", Short.valueOf((short)0)));
        this.unsignedAttribute = ResultSetUtil.getValue(Boolean.TYPE, typeInfo, "UNSIGNED_ATTRIBUTE", Boolean.valueOf(false));
        this.fixedPrecScale = ResultSetUtil.getValue(Boolean.TYPE, typeInfo, "FIXED_PREC_SCALE", Boolean.valueOf(false));
        this.autoIncrement = ResultSetUtil.getValue(Boolean.TYPE, typeInfo, "AUTO_INCREMENT", Boolean.valueOf(false));
        this.localTypeName = ResultSetUtil.getValue(String.class, typeInfo, "LOCAL_TYPE_NAME", null);
        this.minimumScale = ResultSetUtil.getValue(Short.TYPE, typeInfo, "MINIMUM_SCALE", Short.valueOf((short)0));
        this.maximumScale = ResultSetUtil.getValue(Short.TYPE, typeInfo, "MAXIMUM_SCALE", Short.valueOf((short)0));
        this.sqlDataType = ResultSetUtil.getValue(Integer.TYPE, typeInfo, "SQL_DATA_TYPE", Integer.valueOf(0));
        this.sqlDatetimeSub = ResultSetUtil.getValue(Integer.TYPE, typeInfo, "SQL_DATETIME_SUB", Integer.valueOf(0));
        this.numPrecRadix = ResultSetUtil.getValue(Integer.TYPE, typeInfo, "NUM_PREC_RADIX", Integer.valueOf(0));
        assert (this.typeName != null);
        assert (this.nullable != null);
        assert (this.searchable != null);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Searchable {
        NONE(0),
        CHAR(1),
        BASIC(2),
        SEARCHABLE(3);

        private int value;

        private static Searchable getSearchable(short value) {
            for (Searchable searchable : Searchable.values()) {
                if (searchable.value != value) continue;
                return searchable;
            }
            return null;
        }

        private Searchable(int value) {
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Nullable {
        NO_NULLS(0),
        NULLABLE(1),
        UNKNOWN(2);

        private final int value;

        private static Nullable getNullable(short value) {
            for (Nullable nullable : Nullable.values()) {
                if (nullable.value != value) continue;
                return nullable;
            }
            return null;
        }

        private Nullable(int value) {
            this.value = value;
        }
    }
}

