/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils.collection;

import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.Validate;
import org.jiemamy.utils.collection.ArrayEssentialStack;
import org.jiemamy.utils.collection.EssentialStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EssentialStacks {
    public static <E> EssentialStack<E> intersection(EssentialStack<? extends E> left, EssentialStack<? extends E> right) {
        Validate.notNull(left);
        Validate.notNull(right);
        ArrayEssentialStack result = new ArrayEssentialStack();
        int i = 0;
        for (Object leftElement : left) {
            E rightElement;
            if (i >= right.size() || !ObjectUtils.equals(rightElement = right.get(i), leftElement)) break;
            result.push(leftElement);
            ++i;
        }
        return result;
    }

    public static <E> EssentialStack<E> minus(EssentialStack<? extends E> left, EssentialStack<? extends E> right) {
        Validate.notNull(left);
        Validate.notNull(right);
        ArrayEssentialStack result = new ArrayEssentialStack(left);
        for (Object er : right) {
            for (Object el : left) {
                if (el != er) continue;
                result.remove(el);
            }
        }
        return result;
    }

    public static <E> ArrayEssentialStack<E> newArrayEssentialStack() {
        return new ArrayEssentialStack();
    }

    private EssentialStacks() {
    }
}

