/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.script;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.jiemamy.JiemamyContext;
import org.jiemamy.ServiceLocator;
import org.jiemamy.dddbase.AbstractEntity;
import org.jiemamy.dddbase.DefaultEntityRef;
import org.jiemamy.dddbase.Entity;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.dddbase.utils.CloneUtil;
import org.jiemamy.dddbase.utils.MutationMonitor;
import org.jiemamy.model.DbObject;
import org.jiemamy.model.script.JmAroundScript;
import org.jiemamy.model.script.Position;
import org.jiemamy.script.ScriptEngine;
import org.jiemamy.script.ScriptException;
import org.jiemamy.script.ScriptString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleJmAroundScript
extends AbstractEntity
implements JmAroundScript {
    private Map<Position, ScriptString> scripts = Maps.newHashMap();
    private EntityRef<? extends DbObject> coreModelRef;

    public SimpleJmAroundScript() {
        this(UUID.randomUUID());
    }

    public SimpleJmAroundScript(UUID id) {
        super(id);
    }

    @Override
    public SimpleJmAroundScript clone() {
        SimpleJmAroundScript clone = (SimpleJmAroundScript)super.clone();
        clone.scripts = CloneUtil.cloneValueHashMap(this.scripts);
        return clone;
    }

    @Override
    public EntityRef<? extends DbObject> getCoreModelRef() {
        return this.coreModelRef;
    }

    @Override
    public String getScript(Position position) {
        Validate.notNull((Object)((Object)position));
        return this.scripts.get((Object)position).getScript();
    }

    @Override
    public ScriptEngine getScriptEngine(Position position) throws ClassNotFoundException {
        Validate.notNull((Object)((Object)position));
        ServiceLocator sl = JiemamyContext.getServiceLocator();
        return (ScriptEngine)sl.getService(ScriptEngine.class, this.getScriptEngineClassName(position));
    }

    @Override
    public String getScriptEngineClassName(Position position) {
        Validate.notNull((Object)((Object)position));
        return this.scripts.get((Object)position).getScriptEngineClassName();
    }

    public Map<Position, ScriptString> getScriptStrings() {
        return MutationMonitor.monitor((Map)Maps.newHashMap(this.scripts));
    }

    @Override
    public String process(JiemamyContext context, Position position, Object target) throws ClassNotFoundException, ScriptException {
        Validate.notNull((Object)context);
        Validate.notNull((Object)((Object)position));
        Validate.notNull((Object)target);
        HashMap env = Maps.newHashMap();
        env.put("target", target);
        return this.scripts.get((Object)position).process((Map)env);
    }

    public void setCoreModelRef(EntityRef<? extends DbObject> coreModelRef) {
        Validate.notNull(coreModelRef);
        this.coreModelRef = coreModelRef;
    }

    public void setScript(Position position, String script) {
        Validate.notNull((Object)((Object)position));
        Validate.notNull((Object)script);
        this.scripts.put(position, new ScriptString(script));
    }

    public void setScript(Position position, String script, Class<? extends ScriptEngine> scriptEngineClass) {
        Validate.notNull((Object)((Object)position));
        Validate.notNull((Object)script);
        this.scripts.put(position, new ScriptString(script, scriptEngineClass));
    }

    public void setScript(Position position, String script, String scriptEngineClassName) {
        Validate.notNull((Object)((Object)position));
        Validate.notNull((Object)script);
        this.scripts.put(position, new ScriptString(script, scriptEngineClassName));
    }

    public EntityRef<? extends SimpleJmAroundScript> toReference() {
        return new DefaultEntityRef((Entity)this);
    }

    public String toString() {
        return "Script[" + this.scripts + "]";
    }
}

