/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.util;

import java.lang.reflect.Method;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.util.MethodUtil;

public class PropertyDescUtil {
    private static Method isWritableMethod = PropertyDescUtil.getIsWritableMethod();
    private static Method isReadableMethod = PropertyDescUtil.getIsReadableMethod();

    private PropertyDescUtil() {
    }

    public static boolean isWritable(PropertyDesc propertyDesc) {
        if (isWritableMethod != null) {
            Boolean b = (Boolean)MethodUtil.invoke((Method)isWritableMethod, (Object)propertyDesc, null);
            return b;
        }
        return propertyDesc.hasWriteMethod();
    }

    public static boolean isReadable(PropertyDesc propertyDesc) {
        if (isReadableMethod != null) {
            Boolean b = (Boolean)MethodUtil.invoke((Method)isReadableMethod, (Object)propertyDesc, null);
            return b;
        }
        return propertyDesc.hasReadMethod();
    }

    private static Method getIsWritableMethod() {
        try {
            return PropertyDesc.class.getMethod("isWritable", null);
        }
        catch (NoSuchMethodException ignore) {
            return null;
        }
    }

    private static Method getIsReadableMethod() {
        try {
            return PropertyDesc.class.getMethod("isReadable", null);
        }
        catch (NoSuchMethodException ignore) {
            return null;
        }
    }
}

