/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.pager;

import org.aopalliance.intercept.MethodInvocation;
import org.seasar.dao.interceptors.S2DaoInterceptor;
import org.seasar.dao.pager.PagerContext;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;

public class PagerS2DaoInterceptorWrapper
extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;
    private S2DaoInterceptor interceptor;

    public PagerS2DaoInterceptorWrapper(S2DaoInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        boolean started = false;
        PagerContext pagerContext = PagerContext.getContext();
        if (pagerContext == null) {
            PagerContext.start();
            started = true;
            pagerContext = PagerContext.getContext();
        }
        pagerContext.pushArgs(invocation.getArguments());
        try {
            Object object = this.interceptor.invoke(invocation);
            return object;
        }
        finally {
            pagerContext.popArgs();
            if (started) {
                PagerContext.end();
            }
        }
    }
}

