/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.BeanMetaDataFactory;
import org.seasar.dao.DaoAnnotationReader;
import org.seasar.dao.DaoMetaData;
import org.seasar.dao.DaoNamingConvention;
import org.seasar.dao.DaoNotFoundRuntimeException;
import org.seasar.dao.Dbms;
import org.seasar.dao.DtoMetaData;
import org.seasar.dao.DtoMetaDataFactory;
import org.seasar.dao.IllegalAnnotationRuntimeException;
import org.seasar.dao.IllegalSignatureRuntimeException;
import org.seasar.dao.InjectDaoClassSupport;
import org.seasar.dao.MethodSetupFailureRuntimeException;
import org.seasar.dao.ProcedureMetaData;
import org.seasar.dao.ProcedureMetaDataFactory;
import org.seasar.dao.RelationRowCreator;
import org.seasar.dao.ResultSetHandlerFactory;
import org.seasar.dao.RowCreator;
import org.seasar.dao.SqlCommand;
import org.seasar.dao.SqlFileNotFoundRuntimeException;
import org.seasar.dao.ValueTypeFactory;
import org.seasar.dao.dbms.DbmsManager;
import org.seasar.dao.handler.ProcedureHandlerImpl;
import org.seasar.dao.impl.AbstractAutoStaticCommand;
import org.seasar.dao.impl.AbstractSqlCommand;
import org.seasar.dao.impl.ArgumentDtoProcedureCommand;
import org.seasar.dao.impl.BeanArrayMetaDataResultSetHandler;
import org.seasar.dao.impl.BeanListMetaDataResultSetHandler;
import org.seasar.dao.impl.BeanMetaDataResultSetHandler;
import org.seasar.dao.impl.DeleteAutoStaticCommand;
import org.seasar.dao.impl.DeleteBatchAutoStaticCommand;
import org.seasar.dao.impl.DtoArrayMetaDataResultSetHandler;
import org.seasar.dao.impl.DtoListMetaDataResultSetHandler;
import org.seasar.dao.impl.DtoMetaDataResultSetHandler;
import org.seasar.dao.impl.InsertAutoDynamicCommand;
import org.seasar.dao.impl.InsertBatchAutoStaticCommand;
import org.seasar.dao.impl.MapArrayResultSetHandler;
import org.seasar.dao.impl.MapListResultSetHandler;
import org.seasar.dao.impl.MapResultSetHandler;
import org.seasar.dao.impl.OverloadNotSupportedSqlCommand;
import org.seasar.dao.impl.RelationRowCreatorImpl;
import org.seasar.dao.impl.RowCreatorImpl;
import org.seasar.dao.impl.SelectDynamicCommand;
import org.seasar.dao.impl.StaticStoredProcedureCommand;
import org.seasar.dao.impl.UpdateAutoDynamicCommand;
import org.seasar.dao.impl.UpdateAutoStaticCommand;
import org.seasar.dao.impl.UpdateBatchAutoStaticCommand;
import org.seasar.dao.impl.UpdateDynamicCommand;
import org.seasar.dao.impl.UpdateModifiedOnlyCommand;
import org.seasar.dao.pager.NullPagingSqlRewriter;
import org.seasar.dao.pager.PagingSqlRewriter;
import org.seasar.dao.util.FetchHandlerUtil;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.ResultSetFactory;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.extension.jdbc.impl.ObjectResultSetHandler;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.extension.jdbc.util.DataSourceUtil;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.MethodNotFoundRuntimeException;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.exception.NoSuchMethodRuntimeException;
import org.seasar.framework.exception.SRuntimeException;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.InputStreamReaderUtil;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.util.ReaderUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;

public class DaoMetaDataImpl
implements DaoMetaData {
    private static final Pattern startWithOrderByPattern = Pattern.compile("(/\\*[^*]+\\*/)*order by", 2);
    private static final Pattern startWithSelectPattern = Pattern.compile("^\\s*select\\s", 2);
    private static final Pattern beginCommentPattern = Pattern.compile("/\\*BEGIN\\*/\\s*WHERE", 2);
    private static final Pattern startWithBeginCommentPattern = Pattern.compile("/\\*BEGIN\\*/\\s*WHERE .+", 2);
    private static final Pattern startWithIfCommentPattern = Pattern.compile("/\\*IF .+", 2);
    private static final String NOT_SINGLE_ROW_UPDATED = "NotSingleRowUpdated";
    protected Class daoClass;
    protected Class daoInterface;
    protected BeanDesc daoBeanDesc;
    protected DataSource dataSource;
    protected DaoAnnotationReader daoAnnotationReader;
    protected StatementFactory statementFactory;
    protected ResultSetFactory resultSetFactory;
    protected String sqlFileEncoding = "JISAutoDetect";
    protected Dbms dbms;
    protected Class beanClass;
    protected BeanMetaData beanMetaData;
    protected Map sqlCommands = new HashMap();
    protected ValueTypeFactory valueTypeFactory;
    protected BeanMetaDataFactory beanMetaDataFactory;
    protected DtoMetaDataFactory dtoMetaDataFactory;
    protected ResultSetHandlerFactory resultSetHandlerFactory;
    protected DaoNamingConvention daoNamingConvention;
    protected boolean useDaoClassForLog = false;
    protected PagingSqlRewriter pagingSqlRewriter = new NullPagingSqlRewriter();
    protected ProcedureMetaDataFactory procedureMetaDataFactory;
    protected boolean checkSingleRowUpdateForAll = true;
    static /* synthetic */ Class class$org$seasar$dao$impl$AbstractDao;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        this.beanClass = this.daoAnnotationReader.getBeanClass();
        this.daoInterface = this.getDaoInterface(this.daoClass);
        this.daoBeanDesc = BeanDescFactory.getBeanDesc((Class)this.daoClass);
        Connection con = DataSourceUtil.getConnection((DataSource)this.dataSource);
        try {
            DatabaseMetaData dbMetaData = ConnectionUtil.getMetaData((Connection)con);
            this.dbms = DbmsManager.getDbms(dbMetaData);
        }
        finally {
            ConnectionUtil.close((Connection)con);
        }
        this.beanMetaData = this.beanMetaDataFactory.createBeanMetaData(this.daoInterface, this.beanClass);
        this.checkSingleRowUpdateForAll = this.daoAnnotationReader.isCheckSingleRowUpdate();
        this.setupSqlCommand();
    }

    protected void setupSqlCommand() {
        BeanDesc idbd = BeanDescFactory.getBeanDesc((Class)this.daoInterface);
        String[] names = idbd.getMethodNames();
        block0: for (int i = 0; i < names.length; ++i) {
            Method[] methods = this.daoBeanDesc.getMethods(names[i]);
            if (methods.length == 1 && MethodUtil.isAbstract((Method)methods[0])) {
                this.setupMethod(methods[0]);
                continue;
            }
            if (methods.length <= 1) continue;
            for (int j = 0; j < methods.length; ++j) {
                if (!MethodUtil.isAbstract((Method)methods[j])) continue;
                String methodName = methods[j].getName();
                this.putSqlCommand(methodName, new OverloadNotSupportedSqlCommand(this.daoInterface.getName(), methodName));
                continue block0;
            }
        }
    }

    protected void setupMethod(Method method) {
        this.setupMethod(this.daoInterface, method);
    }

    protected void setupMethod(Class daoInterface, Method method) {
        try {
            this.assertAnnotation(method);
            this.setupMethodByAnnotation(daoInterface, method);
            if (!this.completedSetupMethod(method)) {
                this.setupMethodBySqlFile(daoInterface, method);
            }
            if (!this.completedSetupMethod(method)) {
                this.setupMethodByInterfaces(daoInterface, method);
            }
            if (!this.completedSetupMethod(method)) {
                this.setupMethodBySuperClass(daoInterface, method);
            }
            if (!this.completedSetupMethod(method) && this.daoAnnotationReader.isSqlFile(method)) {
                String fileName = this.getSqlFilePath(daoInterface, method) + ".sql";
                throw new SqlFileNotFoundRuntimeException(daoInterface, method, fileName);
            }
            if (!this.completedSetupMethod(method)) {
                this.setupMethodByAuto(method);
            }
        }
        catch (SRuntimeException e) {
            throw new MethodSetupFailureRuntimeException(daoInterface.getName(), method.getName(), e);
        }
    }

    protected void setupMethodByAnnotation(Class daoInterface, Method method) {
        String sql = this.daoAnnotationReader.getSQL(method, this.dbms.getSuffix());
        if (sql != null) {
            this.setupMethodByManual(method, sql);
            return;
        }
        String procedureCallName = this.daoAnnotationReader.getProcedureCallName(method);
        if (procedureCallName != null) {
            this.setupProcedureCallMethod(method, procedureCallName);
            return;
        }
        String procedureName = this.daoAnnotationReader.getStoredProcedureName(method);
        if (procedureName != null) {
            this.setupProcedureMethod(method, procedureName);
            return;
        }
    }

    protected void assertAnnotation(Method method) {
        if ((this.isInsert(method.getName()) || this.isUpdate(method.getName())) && this.daoAnnotationReader.getQuery(method) != null) {
            throw new IllegalAnnotationRuntimeException("Query");
        }
    }

    protected void setupProcedureMethod(Method method, String procedureName) {
        ProcedureHandlerImpl handler = new ProcedureHandlerImpl();
        handler.setDataSource(this.dataSource);
        handler.setDbms(this.dbms);
        handler.setDaoMethod(method);
        handler.setDaoAnnotationReader(this.daoAnnotationReader);
        handler.setBeanMetaData(this.beanMetaData);
        handler.setProcedureName(procedureName);
        handler.setResultSetHandlerFactory(this.resultSetHandlerFactory);
        handler.setStatementFactory(this.statementFactory);
        handler.initialize();
        StaticStoredProcedureCommand command = new StaticStoredProcedureCommand(handler);
        this.putSqlCommand(method.getName(), command);
    }

    protected void setupProcedureCallMethod(Method method, String procedureName) {
        ProcedureMetaData metaData = this.procedureMetaDataFactory.createProcedureMetaData(procedureName, method);
        ResultSetHandler resultSetHandler = this.createResultSetHandler(method);
        ArgumentDtoProcedureCommand command = new ArgumentDtoProcedureCommand(this.dataSource, resultSetHandler, this.statementFactory, this.resultSetFactory, metaData);
        this.putSqlCommand(method.getName(), command);
    }

    protected String readText(String path) {
        InputStream is = ResourceUtil.getResourceAsStream((String)path);
        InputStreamReader reader = InputStreamReaderUtil.create((InputStream)is, (String)this.getSqlFileEncoding());
        return ReaderUtil.readText((Reader)reader);
    }

    protected void setupMethodBySqlFile(Class daoInterface, Method method) {
        String query;
        String base = this.getSqlFilePath(daoInterface, method);
        String dbmsPath = base + this.dbms.getSuffix() + ".sql";
        String standardPath = base + ".sql";
        if (ResourceUtil.isExist((String)dbmsPath)) {
            String sql = this.readText(dbmsPath);
            this.setupMethodByManual(method, sql);
        } else if (ResourceUtil.isExist((String)standardPath)) {
            String sql = this.readText(standardPath);
            this.setupMethodByManual(method, sql);
        } else if (this.isDelete(method.getName()) && StringUtil.isNotBlank((String)(query = this.daoAnnotationReader.getQuery(method)))) {
            if (query.trim().toUpperCase().startsWith("WHERE")) {
                this.setupMethodByManual(method, "DELETE FROM " + this.beanMetaData.getTableName() + " " + query);
            } else {
                this.setupMethodByManual(method, "DELETE FROM " + this.beanMetaData.getTableName() + " WHERE " + query);
            }
        }
    }

    protected String getSqlFilePath(Class daoInterface, Method method) {
        String fileByAnnotation = this.daoAnnotationReader.getSqlFilePath(method);
        String base = StringUtil.isEmpty((String)fileByAnnotation) ? daoInterface.getName().replace('.', '/') + "_" + method.getName() : fileByAnnotation.replaceAll(".sql$", "");
        return base;
    }

    protected void setupMethodByInterfaces(Class daoInterface, Method method) {
        Class<?>[] interfaces = daoInterface.getInterfaces();
        if (interfaces == null) {
            return;
        }
        for (int i = 0; i < interfaces.length; ++i) {
            Method interfaceMethod = this.getSameSignatureMethod(interfaces[i], method);
            if (interfaceMethod == null) continue;
            this.setupMethod(interfaces[i], interfaceMethod);
        }
    }

    protected void setupMethodBySuperClass(Class daoInterface, Method method) {
        Method superClassMethod;
        Class superDaoClass = daoInterface.getSuperclass();
        if (superDaoClass != null && !Object.class.equals(superDaoClass) && (superClassMethod = this.getSameSignatureMethod(superDaoClass, method)) != null) {
            this.setupMethod(superDaoClass, method);
        }
    }

    protected boolean completedSetupMethod(Method method) {
        return this.hasSqlCommand(method.getName());
    }

    private Method getSameSignatureMethod(Class clazz, Method method) {
        try {
            String methodName = method.getName();
            Class[] parameterTypes = method.getParameterTypes();
            return ClassUtil.getMethod((Class)clazz, (String)methodName, (Class[])parameterTypes);
        }
        catch (NoSuchMethodRuntimeException e) {
            return null;
        }
    }

    protected void setupMethodByManual(Method method, String sql) {
        if (this.isSelect(method)) {
            this.setupSelectMethodByManual(method, sql);
        } else {
            this.setupUpdateMethodByManual(method, sql);
        }
    }

    protected void setupMethodByAuto(Method method) {
        if (this.isInsert(method.getName())) {
            this.setupInsertMethodByAuto(method);
        } else if (this.isUpdate(method.getName())) {
            this.setupUpdateMethodByAuto(method);
        } else if (this.isDelete(method.getName())) {
            this.setupDeleteMethodByAuto(method);
        } else {
            this.setupSelectMethodByAuto(method);
        }
    }

    protected void setupSelectMethodByManual(Method method, String sql) {
        SelectDynamicCommand cmd = this.createSelectDynamicCommand(this.createResultSetHandler(method));
        cmd.setSql(sql);
        cmd.setArgNames(this.daoAnnotationReader.getArgNames(method));
        cmd.setArgTypes(method.getParameterTypes());
        this.putSqlCommand(method.getName(), cmd);
    }

    protected SelectDynamicCommand createSelectDynamicCommand(ResultSetHandler rsh) {
        return new SelectDynamicCommand(this.dataSource, this.statementFactory, rsh, this.resultSetFactory, this.pagingSqlRewriter);
    }

    protected SelectDynamicCommand createSelectDynamicCommand(ResultSetHandler resultSetHandler, String query) {
        SelectDynamicCommand cmd = this.createSelectDynamicCommand(resultSetHandler);
        StringBuffer buf = new StringBuffer(255);
        if (DaoMetaDataImpl.startsWithSelect(query)) {
            buf.append(query);
        } else {
            String sql = this.dbms.getAutoSelectSql(this.getBeanMetaData());
            buf.append(sql);
            if (query != null) {
                boolean whereContained;
                String adjustedQuery = query;
                boolean began = false;
                boolean bl = whereContained = sql.lastIndexOf("WHERE") > 0;
                if (DaoMetaDataImpl.startsWithOrderBy(query)) {
                    buf.append(" ");
                } else if (this.startsWithBeginComment(query)) {
                    buf.append(" ");
                    if (whereContained) {
                        Matcher matcher = beginCommentPattern.matcher(query);
                        adjustedQuery = matcher.replaceFirst("/*BEGIN*/AND");
                    }
                } else if (!whereContained) {
                    if (this.startsWithIfComment(query)) {
                        buf.append("/*BEGIN*/");
                        began = true;
                    }
                    buf.append(" WHERE ");
                } else {
                    if (this.startsWithIfComment(query)) {
                        buf.append("/*BEGIN*/");
                        began = true;
                    }
                    buf.append(" AND ");
                }
                buf.append(adjustedQuery);
                if (began) {
                    buf.append("/*END*/");
                }
            }
        }
        cmd.setSql(buf.toString());
        return cmd;
    }

    protected boolean startsWithIfComment(String query) {
        Matcher m = startWithIfCommentPattern.matcher(query);
        return m.lookingAt();
    }

    protected boolean startsWithBeginComment(String query) {
        Matcher m = startWithBeginCommentPattern.matcher(query);
        return m.lookingAt();
    }

    protected static boolean startsWithSelect(String query) {
        Matcher m;
        return query != null && (m = startWithSelectPattern.matcher(query)).lookingAt();
    }

    protected static boolean startsWithOrderBy(String query) {
        Matcher m;
        return query != null && (m = startWithOrderByPattern.matcher(query)).lookingAt();
    }

    protected ResultSetHandler createResultSetHandler(Method method) {
        return this.resultSetHandlerFactory.getResultSetHandler(this.daoAnnotationReader, this.beanMetaData, method);
    }

    protected boolean isBeanClassAssignable(Class clazz) {
        return this.beanClass.isAssignableFrom(clazz) || clazz.isAssignableFrom(this.beanClass);
    }

    protected void setupUpdateMethodByManual(Method method, String sql) {
        UpdateDynamicCommand cmd = new UpdateDynamicCommand(this.dataSource, this.statementFactory);
        cmd.setSql(sql);
        String[] argNames = this.daoAnnotationReader.getArgNames(method);
        if (argNames.length == 0 && this.isUpdateSignatureForBean(method)) {
            argNames = new String[]{StringUtil.decapitalize((String)ClassUtil.getShortClassName((Class)this.beanClass))};
        }
        cmd.setArgNames(argNames);
        cmd.setArgTypes(method.getParameterTypes());
        cmd.setNotSingleRowUpdatedExceptionClass(this.getNotSingleRowUpdatedExceptionClass(method));
        this.putSqlCommand(method.getName(), cmd);
    }

    protected boolean isUpdateSignatureForBean(Method method) {
        return method.getParameterTypes().length == 1 && this.isBeanClassAssignable(method.getParameterTypes()[0]);
    }

    protected Class getNotSingleRowUpdatedExceptionClass(Method method) {
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        if (exceptionTypes != null) {
            for (int i = 0; i < exceptionTypes.length; ++i) {
                Class<?> exceptionType = exceptionTypes[i];
                if (exceptionType.getName().indexOf(NOT_SINGLE_ROW_UPDATED) < 0) continue;
                return exceptionType;
            }
        }
        return null;
    }

    protected void setupInsertMethodByAuto(Method method) {
        SqlCommand command;
        this.checkAutoUpdateMethod(method);
        String[] propertyNames = this.getPersistentPropertyNames(method);
        if (this.isUpdateSignatureForBean(method)) {
            InsertAutoDynamicCommand cmd = new InsertAutoDynamicCommand();
            cmd.setBeanMetaData(this.getBeanMetaData());
            cmd.setDataSource(this.dataSource);
            cmd.setNotSingleRowUpdatedExceptionClass(this.getNotSingleRowUpdatedExceptionClass(method));
            cmd.setPropertyNames(propertyNames);
            cmd.setStatementFactory(this.statementFactory);
            cmd.setCheckSingleRowUpdate(this.isCheckSingleRowUpdate(method));
            command = cmd;
        } else {
            InsertBatchAutoStaticCommand cmd;
            boolean returningRows = false;
            if ([I.class.isAssignableFrom(method.getReturnType())) {
                returningRows = true;
            }
            command = cmd = new InsertBatchAutoStaticCommand(this.dataSource, this.statementFactory, this.getBeanMetaData(), propertyNames, returningRows);
        }
        this.putSqlCommand(method.getName(), command);
    }

    protected void setupUpdateMethodByAuto(Method method) {
        AbstractSqlCommand cmd;
        this.checkAutoUpdateMethod(method);
        String[] propertyNames = this.getPersistentPropertyNames(method);
        if (this.isUpdateSignatureForBean(method)) {
            cmd = this.isUnlessNull(method.getName()) ? this.createUpdateAutoDynamicCommand(method, propertyNames) : (this.isModifiedOnly(method.getName()) ? this.createUpdateModifiedOnlyCommand(method, propertyNames) : this.createUpdateAutoStaticCommand(method, propertyNames));
        } else {
            boolean returningRows = false;
            if ([I.class.isAssignableFrom(method.getReturnType())) {
                returningRows = true;
            }
            cmd = this.createUpdateBatchAutoStaticCommand(method, propertyNames, returningRows);
        }
        this.putSqlCommand(method.getName(), cmd);
    }

    protected UpdateAutoStaticCommand createUpdateAutoStaticCommand(Method method, String[] propertyNames) {
        UpdateAutoStaticCommand cmd = new UpdateAutoStaticCommand(this.dataSource, this.statementFactory, this.beanMetaData, propertyNames);
        cmd.setCheckSingleRowUpdate(this.isCheckSingleRowUpdate(method));
        return cmd;
    }

    protected AbstractSqlCommand createUpdateAutoDynamicCommand(Method method, String[] propertyNames) {
        UpdateAutoDynamicCommand uac = new UpdateAutoDynamicCommand(this.dataSource, this.statementFactory);
        uac.setBeanMetaData(this.beanMetaData);
        uac.setPropertyNames(propertyNames);
        uac.setNotSingleRowUpdatedExceptionClass(this.getNotSingleRowUpdatedExceptionClass(method));
        uac.setCheckSingleRowUpdate(this.isCheckSingleRowUpdate(method));
        UpdateAutoDynamicCommand cmd = uac;
        return cmd;
    }

    protected AbstractSqlCommand createUpdateModifiedOnlyCommand(Method method, String[] propertyNames) {
        UpdateModifiedOnlyCommand uac = new UpdateModifiedOnlyCommand(this.dataSource, this.statementFactory);
        uac.setBeanMetaData(this.beanMetaData);
        uac.setPropertyNames(propertyNames);
        uac.setNotSingleRowUpdatedExceptionClass(this.getNotSingleRowUpdatedExceptionClass(method));
        uac.setCheckSingleRowUpdate(this.isCheckSingleRowUpdate(method));
        return uac;
    }

    protected UpdateBatchAutoStaticCommand createUpdateBatchAutoStaticCommand(Method method, String[] propertyNames, boolean returningRows) {
        return new UpdateBatchAutoStaticCommand(this.dataSource, this.statementFactory, this.beanMetaData, propertyNames, returningRows);
    }

    protected void setupDeleteMethodByAuto(Method method) {
        this.checkAutoUpdateMethod(method);
        String[] propertyNames = this.getPersistentPropertyNames(method);
        AbstractAutoStaticCommand cmd = null;
        if (this.isUpdateSignatureForBean(method)) {
            cmd = this.createDeleteAutoStaticCommand(method, propertyNames);
        } else {
            boolean returningRows = false;
            if ([I.class.isAssignableFrom(method.getReturnType())) {
                returningRows = true;
            }
            cmd = this.createDeleteBatchAutoStaticCommand(method, propertyNames, returningRows);
        }
        this.putSqlCommand(method.getName(), cmd);
    }

    protected DeleteAutoStaticCommand createDeleteAutoStaticCommand(Method method, String[] propertyNames) {
        DeleteAutoStaticCommand cmd = new DeleteAutoStaticCommand(this.dataSource, this.statementFactory, this.beanMetaData, propertyNames);
        cmd.setCheckSingleRowUpdate(this.isCheckSingleRowUpdate(method));
        return cmd;
    }

    protected DeleteBatchAutoStaticCommand createDeleteBatchAutoStaticCommand(Method method, String[] propertyNames, boolean returningRows) {
        return new DeleteBatchAutoStaticCommand(this.dataSource, this.statementFactory, this.beanMetaData, propertyNames, returningRows);
    }

    protected String[] getPersistentPropertyNames(Method method) {
        PropertyType pt;
        int i;
        ArrayList<String> names = new ArrayList<String>();
        String[] props = this.daoAnnotationReader.getNoPersistentProps(method);
        if (props != null) {
            for (i = 0; i < this.beanMetaData.getPropertyTypeSize(); ++i) {
                pt = this.beanMetaData.getPropertyType(i);
                if (!pt.isPersistent() || this.isPropertyExist(props, pt.getPropertyName())) continue;
                names.add(pt.getPropertyName());
            }
        } else {
            props = this.daoAnnotationReader.getPersistentProps(method);
            if (props != null) {
                names.addAll(Arrays.asList(props));
                for (i = 0; i < this.beanMetaData.getPrimaryKeySize(); ++i) {
                    String pk = this.beanMetaData.getPrimaryKey(i);
                    PropertyType pt2 = this.beanMetaData.getPropertyTypeByColumnName(pk);
                    names.add(pt2.getPropertyName());
                }
                if (this.beanMetaData.hasVersionNoPropertyType()) {
                    names.add(this.beanMetaData.getVersionNoPropertyName());
                }
                if (this.beanMetaData.hasTimestampPropertyType()) {
                    names.add(this.beanMetaData.getTimestampPropertyName());
                }
            }
        }
        if (names.size() == 0) {
            for (i = 0; i < this.beanMetaData.getPropertyTypeSize(); ++i) {
                pt = this.beanMetaData.getPropertyType(i);
                if (!pt.isPersistent()) continue;
                names.add(pt.getPropertyName());
            }
        }
        return names.toArray(new String[names.size()]);
    }

    protected boolean isPropertyExist(String[] props, String propertyName) {
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].equalsIgnoreCase(propertyName)) continue;
            return true;
        }
        return false;
    }

    protected void setupSelectMethodByAuto(Method method) {
        ResultSetHandler handler = this.createResultSetHandler(method);
        String[] argNames = this.daoAnnotationReader.getArgNames(method);
        String query = this.daoAnnotationReader.getQuery(method);
        SelectDynamicCommand cmd = null;
        cmd = query != null && !DaoMetaDataImpl.startsWithOrderBy(query) ? this.setupQuerySelectMethodByAuto(method, handler, argNames, query) : this.setupNonQuerySelectMethodByAuto(method, handler, argNames, query);
        this.putSqlCommand(method.getName(), cmd);
    }

    protected boolean isQuerySelectMethodByAuto(Method method, String query) {
        return query != null && !DaoMetaDataImpl.startsWithOrderBy(query);
    }

    protected SelectDynamicCommand setupQuerySelectMethodByAuto(Method method, ResultSetHandler handler, String[] argNames, String query) {
        Class[] types = method.getParameterTypes();
        SelectDynamicCommand cmd = this.createSelectDynamicCommand(handler, query);
        cmd.setArgNames(argNames);
        cmd.setArgTypes(types);
        return cmd;
    }

    protected SelectDynamicCommand setupNonQuerySelectMethodByAuto(Method method, ResultSetHandler handler, String[] argNames, String query) {
        if (this.isAutoSelectSqlByDto(method, argNames)) {
            return this.setupNonQuerySelectMethodByDto(method, handler, argNames, query);
        }
        return this.setupNonQuerySelectMethodByArgs(method, handler, argNames, query);
    }

    protected boolean isAutoSelectSqlByDto(Method method, String[] argNames) {
        if (argNames.length == 0) {
            Class<?> clazz;
            if (method.getParameterTypes().length == 1) {
                return true;
            }
            if (method.getParameterTypes().length == 2 && FetchHandlerUtil.isFetchHandler(clazz = method.getParameterTypes()[1])) {
                return true;
            }
        }
        return false;
    }

    protected SelectDynamicCommand setupNonQuerySelectMethodByDto(Method method, ResultSetHandler handler, String[] argNames, String query) {
        SelectDynamicCommand cmd = this.createSelectDynamicCommand(handler);
        Class clazz = method.getParameterTypes()[0];
        if (this.isUpdateSignatureForBean(method)) {
            clazz = this.beanClass;
        }
        Class[] types = new Class[]{clazz};
        String sql = this.createAutoSelectSqlByDto(clazz);
        if (query != null) {
            sql = sql + " " + query;
        }
        cmd.setSql(sql);
        cmd.setArgNames(argNames);
        cmd.setArgTypes(types);
        return cmd;
    }

    protected SelectDynamicCommand setupNonQuerySelectMethodByArgs(Method method, ResultSetHandler handler, String[] argNames, String query) {
        SelectDynamicCommand cmd = this.createSelectDynamicCommand(handler);
        Class[] types = method.getParameterTypes();
        String sql = this.createAutoSelectSql(argNames);
        if (query != null) {
            sql = sql + " " + query;
        }
        cmd.setSql(sql);
        cmd.setArgNames(argNames);
        cmd.setArgTypes(types);
        return cmd;
    }

    protected String createAutoSelectSqlByDto(Class dtoClass) {
        String sql = this.dbms.getAutoSelectSql(this.getBeanMetaData());
        StringBuffer buf = new StringBuffer(sql);
        if (dtoClass.isPrimitive()) {
            return sql;
        }
        DtoMetaData dmd = this.createDtoMetaData(dtoClass);
        boolean began = false;
        if (sql.lastIndexOf("WHERE") <= 0) {
            buf.append("/*BEGIN*/ WHERE ");
            began = true;
        }
        for (int i = 0; i < dmd.getPropertyTypeSize(); ++i) {
            PropertyType pt = dmd.getPropertyType(i);
            String aliasName = pt.getColumnName();
            if (!this.beanMetaData.hasPropertyTypeByAliasName(aliasName) || !this.beanMetaData.getPropertyTypeByAliasName(aliasName).isPersistent()) continue;
            String columnName = this.beanMetaData.convertFullColumnName(aliasName);
            String propertyName = "dto." + pt.getPropertyName();
            buf.append("/*IF ");
            buf.append(propertyName);
            buf.append(" != null*/");
            buf.append(" ");
            if (!began || i != 0) {
                buf.append("AND ");
            }
            buf.append(columnName);
            buf.append(" = /*");
            buf.append(propertyName);
            buf.append("*/null");
            buf.append("/*END*/");
        }
        if (began) {
            buf.append("/*END*/");
        }
        return buf.toString();
    }

    private DtoMetaData createDtoMetaData(Class dtoClass) {
        DtoMetaData dtoMetaData = this.dtoMetaDataFactory.getDtoMetaData(dtoClass);
        for (int i = 0; i < this.beanMetaData.getPropertyTypeSize(); ++i) {
            PropertyType master = this.beanMetaData.getPropertyType(i);
            String name = master.getPropertyName();
            if (!dtoMetaData.hasPropertyType(name)) continue;
            PropertyType slave = dtoMetaData.getPropertyType(name);
            slave.setColumnName(master.getColumnName());
        }
        return dtoMetaData;
    }

    protected String createAutoSelectSql(String[] argNames) {
        String sql = this.dbms.getAutoSelectSql(this.getBeanMetaData());
        StringBuffer buf = new StringBuffer(sql);
        if (argNames.length != 0) {
            boolean began = false;
            if (sql.lastIndexOf("WHERE") <= 0) {
                buf.append("/*BEGIN*/ WHERE ");
                began = true;
            }
            for (int i = 0; i < argNames.length; ++i) {
                String columnName = this.beanMetaData.convertFullColumnName(argNames[i]);
                buf.append("/*IF ");
                buf.append(argNames[i]);
                buf.append(" != null*/");
                buf.append(" ");
                if (!began || i != 0) {
                    buf.append("AND ");
                }
                buf.append(columnName);
                buf.append(" = /*");
                buf.append(argNames[i]);
                buf.append("*/null");
                buf.append("/*END*/");
            }
            if (began) {
                buf.append("/*END*/");
            }
        }
        return buf.toString();
    }

    protected void checkAutoUpdateMethod(Method method) {
        if (method.getParameterTypes().length != 1 || !this.isBeanClassAssignable(method.getParameterTypes()[0]) && !method.getParameterTypes()[0].isAssignableFrom(List.class) && !method.getParameterTypes()[0].isArray()) {
            throw new IllegalSignatureRuntimeException("EDAO0006", method.toString());
        }
    }

    protected boolean isSelect(Method method) {
        if (this.isInsert(method.getName())) {
            return false;
        }
        if (this.isUpdate(method.getName())) {
            return false;
        }
        return !this.isDelete(method.getName());
    }

    protected boolean isInsert(String methodName) {
        String[] insertPrefixes = this.getDaoNamingConvention().getInsertPrefixes();
        for (int i = 0; i < insertPrefixes.length; ++i) {
            if (!methodName.startsWith(insertPrefixes[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isUpdate(String methodName) {
        String[] updatePrefixes = this.getDaoNamingConvention().getUpdatePrefixes();
        for (int i = 0; i < updatePrefixes.length; ++i) {
            if (!methodName.startsWith(updatePrefixes[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isDelete(String methodName) {
        String[] deletePrefixes = this.getDaoNamingConvention().getDeletePrefixes();
        for (int i = 0; i < deletePrefixes.length; ++i) {
            if (!methodName.startsWith(deletePrefixes[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isUnlessNull(String methodName) {
        String[] unlessNullSuffixes = this.getDaoNamingConvention().getUnlessNullSuffixes();
        for (int i = 0; i < unlessNullSuffixes.length; ++i) {
            if (!methodName.endsWith(unlessNullSuffixes[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isModifiedOnly(String methodName) {
        String[] modifiedOnlySuffixes = this.getDaoNamingConvention().getModifiedOnlySuffixes();
        for (int i = 0; i < modifiedOnlySuffixes.length; ++i) {
            if (!methodName.endsWith(modifiedOnlySuffixes[i])) continue;
            return true;
        }
        return false;
    }

    protected void putSqlCommand(String methodName, SqlCommand cmd) {
        if (this.useDaoClassForLog && cmd instanceof InjectDaoClassSupport) {
            ((InjectDaoClassSupport)((Object)cmd)).setDaoClass(this.daoClass);
        }
        this.sqlCommands.put(methodName, cmd);
    }

    protected boolean isCheckSingleRowUpdate(Method method) {
        return this.checkSingleRowUpdateForAll & this.daoAnnotationReader.isCheckSingleRowUpdate(method);
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    protected void setBeanClass(Class beanClass) {
        this.beanClass = beanClass;
    }

    public BeanMetaData getBeanMetaData() {
        return this.beanMetaData;
    }

    public SqlCommand getSqlCommand(String methodName) throws MethodNotFoundRuntimeException {
        SqlCommand cmd = (SqlCommand)this.sqlCommands.get(methodName);
        if (cmd == null) {
            throw new MethodNotFoundRuntimeException(this.daoClass, methodName, null);
        }
        return cmd;
    }

    public boolean hasSqlCommand(String methodName) {
        return this.sqlCommands.containsKey(methodName);
    }

    public SqlCommand createFindCommand(String query) {
        return this.createSelectDynamicCommand(new BeanListMetaDataResultSetHandler(this.beanMetaData, this.createRowCreator(), this.createRelationRowCreator()), query);
    }

    public SqlCommand createFindCommand(Class dtoClass, String query) {
        return this.createSelectDynamicCommand(new DtoListMetaDataResultSetHandler(this.dtoMetaDataFactory.getDtoMetaData(dtoClass), this.createRowCreator()), query);
    }

    public SqlCommand createFindArrayCommand(String query) {
        return this.createSelectDynamicCommand(new BeanArrayMetaDataResultSetHandler(this.beanMetaData, this.createRowCreator(), this.createRelationRowCreator()), query);
    }

    public SqlCommand createFindArrayCommand(Class dtoClass, String query) {
        return this.createSelectDynamicCommand(new DtoArrayMetaDataResultSetHandler(this.dtoMetaDataFactory.getDtoMetaData(dtoClass), this.createRowCreator()), query);
    }

    public SqlCommand createFindBeanCommand(String query) {
        return this.createSelectDynamicCommand(new BeanMetaDataResultSetHandler(this.beanMetaData, this.createRowCreator(), this.createRelationRowCreator()), query);
    }

    public SqlCommand createFindBeanCommand(Class dtoClass, String query) {
        return this.createSelectDynamicCommand(new DtoMetaDataResultSetHandler(this.dtoMetaDataFactory.getDtoMetaData(dtoClass), this.createRowCreator()), query);
    }

    public SqlCommand createFindMapCommand(String query) {
        return this.createSelectDynamicCommand(new MapResultSetHandler(), query);
    }

    public SqlCommand createFindMapListCommand(String query) {
        return this.createSelectDynamicCommand(new MapListResultSetHandler(), query);
    }

    public SqlCommand createFindMapArrayCommand(String query) {
        return this.createSelectDynamicCommand(new MapArrayResultSetHandler(), query);
    }

    protected RowCreator createRowCreator() {
        return new RowCreatorImpl();
    }

    protected RelationRowCreator createRelationRowCreator() {
        return new RelationRowCreatorImpl();
    }

    public SqlCommand createFindObjectCommand(String query) {
        return this.createSelectDynamicCommand((ResultSetHandler)new ObjectResultSetHandler(), query);
    }

    public Class getDaoInterface(Class clazz) {
        if (clazz.isInterface()) {
            return clazz;
        }
        String[] daoSuffixes = this.getDaoNamingConvention().getDaoSuffixes();
        for (Class target = clazz; target != (class$org$seasar$dao$impl$AbstractDao == null ? DaoMetaDataImpl.class$("org.seasar.dao.impl.AbstractDao") : class$org$seasar$dao$impl$AbstractDao); target = target.getSuperclass()) {
            Class<?>[] interfaces = target.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> intf = interfaces[i];
                for (int j = 0; j < daoSuffixes.length; ++j) {
                    if (!intf.getName().endsWith(daoSuffixes[j])) continue;
                    return intf;
                }
            }
        }
        throw new DaoNotFoundRuntimeException(clazz);
    }

    public void setDbms(Dbms dbms) {
        this.dbms = dbms;
    }

    public void setResultSetFactory(ResultSetFactory resultSetFactory) {
        this.resultSetFactory = resultSetFactory;
    }

    public void setStatementFactory(StatementFactory statementFactory) {
        this.statementFactory = statementFactory;
    }

    protected String getSqlFileEncoding() {
        return this.sqlFileEncoding;
    }

    public void setSqlFileEncoding(String sencoding) {
        this.sqlFileEncoding = sencoding;
    }

    public ValueTypeFactory getValueTypeFactory() {
        return this.valueTypeFactory;
    }

    public void setValueTypeFactory(ValueTypeFactory valueTypeFactory) {
        this.valueTypeFactory = valueTypeFactory;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected Class getDaoClass() {
        return this.daoClass;
    }

    public void setDaoClass(Class daoClass) {
        this.daoClass = daoClass;
    }

    public void setBeanMetaDataFactory(BeanMetaDataFactory beanMetaDataFactory) {
        this.beanMetaDataFactory = beanMetaDataFactory;
    }

    public DtoMetaDataFactory getDtoMetaDataFactory() {
        return this.dtoMetaDataFactory;
    }

    public void setDtoMetaDataFactory(DtoMetaDataFactory dtoMetaDataFactory) {
        this.dtoMetaDataFactory = dtoMetaDataFactory;
    }

    public DaoNamingConvention getDaoNamingConvention() {
        return this.daoNamingConvention;
    }

    public void setDaoNamingConvention(DaoNamingConvention daoNamingConvention) {
        this.daoNamingConvention = daoNamingConvention;
    }

    public boolean isUseDaoClassForLog() {
        return this.useDaoClassForLog;
    }

    public void setUseDaoClassForLog(boolean setUserDaoClassForLog) {
        this.useDaoClassForLog = setUserDaoClassForLog;
    }

    public void setResultSetHandlerFactory(ResultSetHandlerFactory resultSetHandlerFactory) {
        this.resultSetHandlerFactory = resultSetHandlerFactory;
    }

    public DaoAnnotationReader getDaoAnnotationReader() {
        return this.daoAnnotationReader;
    }

    public void setDaoAnnotationReader(DaoAnnotationReader daoAnnotationReader) {
        this.daoAnnotationReader = daoAnnotationReader;
    }

    public void setPagingSQLRewriter(PagingSqlRewriter pagingSqlRewriter) {
        this.pagingSqlRewriter = pagingSqlRewriter;
    }

    public void setProcedureMetaDataFactory(ProcedureMetaDataFactory procedureMetaDataFactory) {
        this.procedureMetaDataFactory = procedureMetaDataFactory;
    }
}

