/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.unit;

import java.sql.DatabaseMetaData;
import java.util.List;
import org.seasar.dao.AnnotationReaderFactory;
import org.seasar.dao.BeanAnnotationReader;
import org.seasar.dao.BeanEnhancer;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.BeanMetaDataFactory;
import org.seasar.dao.ColumnNaming;
import org.seasar.dao.DaoAnnotationReader;
import org.seasar.dao.DaoNamingConvention;
import org.seasar.dao.Dbms;
import org.seasar.dao.DtoMetaDataFactory;
import org.seasar.dao.ProcedureMetaDataFactory;
import org.seasar.dao.PropertyTypeFactory;
import org.seasar.dao.PropertyTypeFactoryBuilder;
import org.seasar.dao.RelationPropertyTypeFactoryBuilder;
import org.seasar.dao.ResultSetHandlerFactory;
import org.seasar.dao.TableNaming;
import org.seasar.dao.ValueTypeFactory;
import org.seasar.dao.dbms.DbmsManager;
import org.seasar.dao.impl.BeanEnhancerImpl;
import org.seasar.dao.impl.BeanMetaDataFactoryImpl;
import org.seasar.dao.impl.DaoMetaDataImpl;
import org.seasar.dao.impl.DaoNamingConventionImpl;
import org.seasar.dao.impl.DefaultColumnNaming;
import org.seasar.dao.impl.DefaultTableNaming;
import org.seasar.dao.impl.DtoMetaDataFactoryImpl;
import org.seasar.dao.impl.DtoMetaDataImpl;
import org.seasar.dao.impl.FieldAnnotationReaderFactory;
import org.seasar.dao.impl.ProcedureMetaDataFactoryImpl;
import org.seasar.dao.impl.PropertyTypeFactoryBuilderImpl;
import org.seasar.dao.impl.RelationPropertyTypeFactoryBuilderImpl;
import org.seasar.dao.impl.ResultSetHandlerFactorySelector;
import org.seasar.dao.impl.ValueTypeFactoryImpl;
import org.seasar.dao.pager.PagerContext;
import org.seasar.dao.unit.S2DaoBeanListReader;
import org.seasar.dao.unit.S2DaoBeanReader;
import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.jdbc.impl.BasicResultSetFactory;
import org.seasar.extension.jdbc.impl.BasicStatementFactory;
import org.seasar.extension.unit.S2TestCase;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;

public abstract class S2DaoTestCase
extends S2TestCase {
    private ValueTypeFactory valueTypeFactory;
    private AnnotationReaderFactory annotationReaderFactory;
    private BeanMetaDataFactory beanMetaDataFactory;
    private DaoNamingConvention daoNamingConvention;
    private Dbms dbms;
    private BeanEnhancer beanEnhancer;
    private ResultSetHandlerFactory resultSetHandlerFactory;
    private DtoMetaDataFactory dtoMetaDataFactory;
    private PropertyTypeFactoryBuilder propertyTypeFactoryBuilder;
    private RelationPropertyTypeFactoryBuilder relationPropertyTypeFactoryBuilder;
    private TableNaming tableNaming;
    private ColumnNaming columnNaming;
    private ProcedureMetaDataFactory procedureMetaDataFactory;

    public S2DaoTestCase() {
    }

    public S2DaoTestCase(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        this.valueTypeFactory = null;
        this.annotationReaderFactory = null;
        this.beanMetaDataFactory = null;
        this.dbms = null;
        this.beanEnhancer = null;
        this.resultSetHandlerFactory = null;
        this.dtoMetaDataFactory = null;
        this.propertyTypeFactoryBuilder = null;
        this.relationPropertyTypeFactoryBuilder = null;
        this.tableNaming = null;
        this.columnNaming = null;
        this.procedureMetaDataFactory = null;
        PagerContext.end();
        super.tearDown();
    }

    protected void assertBeanEquals(String message, DataSet expected, Object bean) {
        S2DaoBeanReader reader = new S2DaoBeanReader(bean, this.createBeanMetaData(bean.getClass()));
        this.assertEquals(message, expected, reader.read());
    }

    protected void assertBeanListEquals(String message, DataSet expected, List list) {
        S2DaoBeanListReader reader = new S2DaoBeanListReader(list, this.createBeanMetaData(list.get(0).getClass()));
        this.assertEquals(message, expected, reader.read());
    }

    protected BeanMetaData createBeanMetaData(Class beanClass) {
        BeanMetaDataFactory factory = this.getBeanMetaDataFactory();
        return factory.createBeanMetaData(beanClass);
    }

    protected DtoMetaDataImpl createDtoMetaData(Class dtoClass) {
        DtoMetaDataImpl dmd = new DtoMetaDataImpl();
        BeanAnnotationReader reader = this.getAnnotationReaderFactory().createBeanAnnotationReader(dtoClass);
        PropertyTypeFactoryBuilder builder = this.getPropertyTypeFactoryBuilder();
        PropertyTypeFactory propertyTypeFactory = builder.build(dtoClass, reader);
        dmd.setBeanClass(dtoClass);
        dmd.setBeanAnnotationReader(this.getAnnotationReaderFactory().createBeanAnnotationReader(dtoClass));
        dmd.setPropertyTypeFactory(propertyTypeFactory);
        dmd.initialize();
        return dmd;
    }

    protected DaoMetaDataImpl createDaoMetaData(Class daoClass) {
        DaoMetaDataImpl dmd = new DaoMetaDataImpl();
        BeanDesc daoBeanDesc = BeanDescFactory.getBeanDesc((Class)daoClass);
        DaoAnnotationReader daoAnnotationReader = this.getAnnotationReaderFactory().createDaoAnnotationReader(daoBeanDesc);
        BeanMetaDataFactory bmdf = this.getBeanMetaDataFactory();
        DtoMetaDataFactory dmdf = this.getDtoMetaDataFactory();
        dmd.setDaoClass(daoClass);
        dmd.setDataSource(this.getDataSource());
        dmd.setStatementFactory(BasicStatementFactory.INSTANCE);
        dmd.setResultSetFactory(BasicResultSetFactory.INSTANCE);
        dmd.setValueTypeFactory(this.getValueTypeFactory());
        dmd.setBeanMetaDataFactory(bmdf);
        dmd.setDaoNamingConvention(this.getDaoNamingConvention());
        dmd.setDaoAnnotationReader(daoAnnotationReader);
        dmd.setProcedureMetaDataFactory(this.getProcedureMetaDataFactory());
        dmd.setDtoMetaDataFactory(dmdf);
        dmd.setResultSetHandlerFactory(this.getResultSetHandlerFactory());
        dmd.initialize();
        return dmd;
    }

    protected BeanMetaDataFactory getBeanMetaDataFactory() {
        if (this.beanMetaDataFactory == null) {
            BeanMetaDataFactoryImpl impl = new BeanMetaDataFactoryImpl(){

                protected Dbms getDbms() {
                    return S2DaoTestCase.this.getDbms();
                }
            };
            impl.setAnnotationReaderFactory(this.getAnnotationReaderFactory());
            impl.setDataSource(this.getDataSource());
            impl.setDaoNamingConvention(this.getDaoNamingConvention());
            impl.setBeanEnhancer(this.getBeanEnhancer());
            impl.setPropertyTypeFactoryBuilder(this.getPropertyTypeFactoryBuilder());
            impl.setRelationPropertyTypeFactoryBuilder(this.getRelationPropertyTypeFactoryBuilder(impl));
            impl.setTableNaming(this.getTableNaming());
            this.beanMetaDataFactory = impl;
        }
        return this.beanMetaDataFactory;
    }

    protected Dbms getDbms() {
        if (this.dbms == null) {
            DatabaseMetaData dbMetaData = this.getDatabaseMetaData();
            this.dbms = DbmsManager.getDbms(dbMetaData);
        }
        return this.dbms;
    }

    protected void setDbms(Dbms dbms) {
        this.dbms = dbms;
    }

    protected AnnotationReaderFactory getAnnotationReaderFactory() {
        if (this.annotationReaderFactory == null) {
            this.annotationReaderFactory = new FieldAnnotationReaderFactory();
        }
        return this.annotationReaderFactory;
    }

    protected void setAnnotationReaderFactory(AnnotationReaderFactory annotationReaderFactory) {
        this.annotationReaderFactory = annotationReaderFactory;
    }

    protected ValueTypeFactory getValueTypeFactory() {
        if (this.valueTypeFactory == null) {
            ValueTypeFactoryImpl impl = new ValueTypeFactoryImpl();
            impl.setContainer(this.getContainer());
            this.valueTypeFactory = impl;
        }
        return this.valueTypeFactory;
    }

    protected void setValueTypeFactory(ValueTypeFactory valueTypeFactory) {
        this.valueTypeFactory = valueTypeFactory;
    }

    protected DaoNamingConvention getDaoNamingConvention() {
        if (this.daoNamingConvention == null) {
            this.daoNamingConvention = new DaoNamingConventionImpl();
        }
        return this.daoNamingConvention;
    }

    protected void setDaoNamingConvention(DaoNamingConvention daoNamingConvention) {
        this.daoNamingConvention = daoNamingConvention;
    }

    protected BeanEnhancer getBeanEnhancer() {
        if (this.beanEnhancer == null) {
            BeanEnhancerImpl impl = new BeanEnhancerImpl();
            impl.setDaoNamingConvention(this.getDaoNamingConvention());
            this.beanEnhancer = impl;
        }
        return this.beanEnhancer;
    }

    protected void setBeanEnhancer(BeanEnhancer beanEnhancer) {
        this.beanEnhancer = beanEnhancer;
    }

    protected ResultSetHandlerFactory getResultSetHandlerFactory() {
        if (this.resultSetHandlerFactory == null) {
            ResultSetHandlerFactorySelector factory = new ResultSetHandlerFactorySelector();
            factory.setDtoMetaDataFactory(this.getDtoMetaDataFactory());
            factory.init();
            this.resultSetHandlerFactory = factory;
        }
        return this.resultSetHandlerFactory;
    }

    protected void setResultSetHandlerFactory(ResultSetHandlerFactory resultSetHandlerFactory) {
        this.resultSetHandlerFactory = resultSetHandlerFactory;
    }

    protected DtoMetaDataFactory getDtoMetaDataFactory() {
        if (this.dtoMetaDataFactory == null) {
            DtoMetaDataFactoryImpl factory = new DtoMetaDataFactoryImpl();
            factory.setAnnotationReaderFactory(this.getAnnotationReaderFactory());
            factory.setPropertyTypeFactoryBuilder(this.getPropertyTypeFactoryBuilder());
            this.dtoMetaDataFactory = factory;
        }
        return this.dtoMetaDataFactory;
    }

    protected void setDtoMetaDataFactory(DtoMetaDataFactory dtoMetaDataFactory) {
        this.dtoMetaDataFactory = dtoMetaDataFactory;
    }

    protected ColumnNaming getColumnNaming() {
        if (this.columnNaming == null) {
            this.columnNaming = new DefaultColumnNaming();
        }
        return this.columnNaming;
    }

    protected void setColumnNaming(ColumnNaming columnNaming) {
        this.columnNaming = columnNaming;
    }

    protected PropertyTypeFactoryBuilder getPropertyTypeFactoryBuilder() {
        if (this.propertyTypeFactoryBuilder == null) {
            PropertyTypeFactoryBuilderImpl builder = new PropertyTypeFactoryBuilderImpl();
            builder.setColumnNaming(this.getColumnNaming());
            builder.setDaoNamingConvention(this.getDaoNamingConvention());
            builder.setValueTypeFactory(this.getValueTypeFactory());
            this.propertyTypeFactoryBuilder = builder;
        }
        return this.propertyTypeFactoryBuilder;
    }

    protected void setPropertyTypeFactoryBuilder(PropertyTypeFactoryBuilder propertyTypeFactoryBuilder) {
        this.propertyTypeFactoryBuilder = propertyTypeFactoryBuilder;
    }

    protected RelationPropertyTypeFactoryBuilder getRelationPropertyTypeFactoryBuilder(BeanMetaDataFactory beanMetaDataFactory) {
        if (this.relationPropertyTypeFactoryBuilder == null) {
            RelationPropertyTypeFactoryBuilderImpl builder = new RelationPropertyTypeFactoryBuilderImpl();
            builder.setBeanEnhancer(this.beanEnhancer);
            builder.setBeanMetaDataFactory(beanMetaDataFactory);
            this.relationPropertyTypeFactoryBuilder = builder;
        }
        return this.relationPropertyTypeFactoryBuilder;
    }

    protected void setRelationPropertyTypeFactoryBuilder(RelationPropertyTypeFactoryBuilder relationPropertyTypeFactoryBuilder) {
        this.relationPropertyTypeFactoryBuilder = relationPropertyTypeFactoryBuilder;
    }

    protected TableNaming getTableNaming() {
        if (this.tableNaming == null) {
            this.tableNaming = new DefaultTableNaming();
        }
        return this.tableNaming;
    }

    protected void setTableNaming(TableNaming tableNaming) {
        this.tableNaming = tableNaming;
    }

    protected ProcedureMetaDataFactory getProcedureMetaDataFactory() {
        if (this.procedureMetaDataFactory == null) {
            ProcedureMetaDataFactoryImpl factory = new ProcedureMetaDataFactoryImpl();
            factory.setValueTypeFactory(this.valueTypeFactory);
            factory.setAnnotationReaderFactory(this.annotationReaderFactory);
            factory.initialize();
            this.procedureMetaDataFactory = factory;
        }
        return this.procedureMetaDataFactory;
    }

    protected void setProcedureMetaDataFactory(ProcedureMetaDataFactory procedureMetaDataFactory) {
        this.procedureMetaDataFactory = procedureMetaDataFactory;
    }
}

