/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.seasar.dao.BeanAnnotationReader;
import org.seasar.dao.BeanEnhancer;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.BeanMetaDataFactory;
import org.seasar.dao.RelationPropertyType;
import org.seasar.dao.RelationPropertyTypeFactory;
import org.seasar.dao.impl.RelationPropertyTypeImpl;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.beans.impl.PropertyDescImpl;

public class RelationPropertyTypeFactoryImpl
implements RelationPropertyTypeFactory {
    protected Class beanClass;
    protected BeanAnnotationReader beanAnnotationReader;
    protected BeanMetaDataFactory beanMetaDataFactory;
    protected DatabaseMetaData databaseMetaData;
    protected int relationNestLevel;
    protected boolean isStopRelationCreation;
    protected BeanEnhancer beanEnhancer;

    public RelationPropertyTypeFactoryImpl(Class beanClass, BeanAnnotationReader beanAnnotationReader, BeanMetaDataFactory beanMetaDataFactory, DatabaseMetaData databaseMetaData, int relationNestLevel, boolean isStopRelationCreation, BeanEnhancer beanEnhancer) {
        this.beanClass = beanClass;
        this.beanAnnotationReader = beanAnnotationReader;
        this.beanMetaDataFactory = beanMetaDataFactory;
        this.databaseMetaData = databaseMetaData;
        this.relationNestLevel = relationNestLevel;
        this.isStopRelationCreation = isStopRelationCreation;
        this.beanEnhancer = beanEnhancer;
    }

    public RelationPropertyType[] createRelationPropertyTypes() {
        ArrayList<RelationPropertyType> list = new ArrayList<RelationPropertyType>();
        BeanDesc beanDesc = this.getBeanDesc();
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            if (this.isStopRelationCreation || !this.isRelationProperty(pd)) continue;
            RelationPropertyType rpt = this.createRelationPropertyType(pd);
            list.add(rpt);
        }
        return list.toArray(new RelationPropertyType[list.size()]);
    }

    protected RelationPropertyType createRelationPropertyType(PropertyDesc propertyDesc) {
        String[] myKeys = new String[]{};
        String[] yourKeys = new String[]{};
        int relno = this.beanAnnotationReader.getRelationNo(propertyDesc);
        String relkeys = this.beanAnnotationReader.getRelationKey(propertyDesc);
        if (relkeys != null) {
            StringTokenizer st = new StringTokenizer(relkeys, " \t\n\r\f,");
            ArrayList<String> myKeyList = new ArrayList<String>();
            ArrayList<String> yourKeyList = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int index = token.indexOf(58);
                if (index > 0) {
                    myKeyList.add(token.substring(0, index));
                    yourKeyList.add(token.substring(index + 1));
                    continue;
                }
                myKeyList.add(token);
                yourKeyList.add(token);
            }
            myKeys = myKeyList.toArray(new String[myKeyList.size()]);
            yourKeys = yourKeyList.toArray(new String[yourKeyList.size()]);
        }
        BeanMetaData beanMetaData = this.createRelationBeanMetaData(propertyDesc.getPropertyType());
        Object enhancedPd = null;
        enhancedPd = this.beanEnhancer.isEnhancedClass(beanMetaData.getBeanClass()) ? new PropertyDescImpl(propertyDesc.getPropertyName(), beanMetaData.getBeanClass(), propertyDesc.getReadMethod(), propertyDesc.getWriteMethod(), this.getBeanDesc()) : propertyDesc;
        RelationPropertyTypeImpl rpt = new RelationPropertyTypeImpl((PropertyDesc)enhancedPd, relno, myKeys, yourKeys, beanMetaData);
        return rpt;
    }

    protected BeanMetaData createRelationBeanMetaData(Class relationBeanClass) {
        return this.beanMetaDataFactory.createBeanMetaData(this.databaseMetaData, relationBeanClass, this.relationNestLevel + 1);
    }

    protected boolean isRelationProperty(PropertyDesc propertyDesc) {
        return this.beanAnnotationReader.hasRelationNo(propertyDesc);
    }

    protected BeanDesc getBeanDesc() {
        return BeanDescFactory.getBeanDesc((Class)this.beanClass);
    }
}

