/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.handler;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.sql.DataSource;
import org.seasar.dao.handler.AbstractBasicProcedureHandler;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.extension.jdbc.impl.BasicStatementFactory;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.util.StatementUtil;

public class MapBasicProcedureHandler
extends AbstractBasicProcedureHandler {
    public MapBasicProcedureHandler(DataSource ds, String procedureName) {
        this(ds, procedureName, BasicStatementFactory.INSTANCE);
    }

    public MapBasicProcedureHandler(DataSource ds, String procedureName, StatementFactory statementFactory) {
        this.setDataSource(ds);
        this.setProcedureName(procedureName);
        this.setStatementFactory(statementFactory);
    }

    public void initialize() {
        this.initTypes();
    }

    protected Object execute(Connection connection, Object[] args) {
        CallableStatement cs = null;
        try {
            cs = this.prepareCallableStatement(connection);
            this.bindArgs(cs, args);
            cs.execute();
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (int i = 0; i < this.columnInOutTypes.length; ++i) {
                if (!this.isOutputColum(this.columnInOutTypes[i])) continue;
                result.put(this.columnNames[i], cs.getObject(i + 1));
            }
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        finally {
            StatementUtil.close((Statement)cs);
        }
    }
}

