/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.pager;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.seasar.dao.pager.LimitOffsetPagingSqlRewriter;

public class MySQLLimitOffsetPagingSqlRewriter
extends LimitOffsetPagingSqlRewriter {
    private static final Pattern baseSqlPattern = Pattern.compile("^.*?(select)", 2);

    protected String makeLimitOffsetSql(String baseSQL, int limit, int offset) {
        return super.makeLimitOffsetSql(this.makeCalcFoundRowsSQL(baseSQL), limit, offset);
    }

    public MySQLLimitOffsetPagingSqlRewriter() {
        this.countSqlCompatibility = false;
    }

    public String makeCountSql(String baseSQL) {
        return "SELECT FOUND_ROWS()";
    }

    public String makeCalcFoundRowsSQL(String baseSQL) {
        Matcher matcher = baseSqlPattern.matcher(baseSQL);
        if (matcher.find()) {
            baseSQL = matcher.replaceFirst(matcher.group(1) + " SQL_CALC_FOUND_ROWS");
        }
        return baseSQL;
    }

    protected boolean isOriginalArgsRequiredForCounting() {
        return false;
    }
}

