/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.dbms;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.seasar.dao.Dbms;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.extension.jdbc.util.DataSourceUtil;
import org.seasar.extension.jdbc.util.DatabaseMetaDataUtil;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ResourceUtil;

public final class DbmsManager {
    private static Properties dbmsClassNames;
    private static Map dbmsInstances;

    private DbmsManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dbms getDbms(DataSource dataSource) {
        Dbms dbms = null;
        Connection con = DataSourceUtil.getConnection((DataSource)dataSource);
        try {
            DatabaseMetaData dmd = ConnectionUtil.getMetaData((Connection)con);
            dbms = DbmsManager.getDbms(dmd);
        }
        finally {
            ConnectionUtil.close((Connection)con);
        }
        return dbms;
    }

    public static Dbms getDbms(DatabaseMetaData dmd) {
        return DbmsManager.getDbms(DatabaseMetaDataUtil.getDatabaseProductName((DatabaseMetaData)dmd));
    }

    public static Dbms getDbms(String productName) {
        Dbms dbms = (Dbms)dbmsInstances.get(productName);
        if (dbms == null) {
            String className = dbmsClassNames.getProperty("");
            Iterator<Object> i = dbmsClassNames.keySet().iterator();
            while (i.hasNext()) {
                String productPrefix = (String)i.next();
                if (!productName.startsWith(productPrefix)) continue;
                className = dbmsClassNames.getProperty(productPrefix);
                break;
            }
            dbms = (Dbms)ClassUtil.newInstance((String)className);
            dbmsInstances.put(productName, dbms);
        }
        return dbms;
    }

    static {
        dbmsInstances = new HashMap();
        dbmsClassNames = ResourceUtil.getProperties((String)"dbms.properties");
    }
}

