/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.pager;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.seasar.dao.pager.DefaultPagerCondition;
import org.seasar.dao.pager.PagerContext;
import org.seasar.dao.pager.PagerResultSetFactoryWrapper;
import org.seasar.dao.pager.PagerStatementFactory;
import org.seasar.extension.jdbc.impl.BasicResultSetFactory;
import org.seasar.extension.unit.S2TestCase;
import org.seasar.framework.util.ResultSetUtil;
import org.seasar.framework.util.StatementUtil;

public class ScrollCursorTest
extends S2TestCase {
    private PagerResultSetFactoryWrapper pagerResultSetFactoryWrapper;
    private PagerStatementFactory pagerStatementFactory = new PagerStatementFactory();

    protected void setUp() throws Exception {
        super.setUp();
        this.include("j2ee.dicon");
        PagerContext.start();
    }

    protected void setUpAfterBindFields() throws Throwable {
        super.setUpAfterBindFields();
        this.pagerResultSetFactoryWrapper = new PagerResultSetFactoryWrapper(BasicResultSetFactory.INSTANCE);
        this.pagerResultSetFactoryWrapper.setUseScrollCursor(this.isScrollCursor());
    }

    protected boolean isScrollCursor() {
        return true;
    }

    protected void tearDown() throws Exception {
        PagerContext.end();
        super.tearDown();
    }

    public void testPageLimitTx() throws Exception {
        DefaultPagerCondition condition = new DefaultPagerCondition();
        condition.setLimit(2);
        ScrollCursorTest.assertEquals((int)0, (int)condition.getOffset());
        ScrollCursorTest.assertEquals((int)0, (int)condition.getCount());
        PagerContext.getContext().pushArgs(new Object[]{condition});
        List employees = this.getEmployees();
        ScrollCursorTest.assertEquals((int)14, (int)condition.getCount());
        ScrollCursorTest.assertEquals((int)2, (int)employees.size());
        ScrollCursorTest.assertEquals((Object)new BigDecimal("7369"), (Object)((BigDecimal)employees.get(0)));
        ScrollCursorTest.assertEquals((Object)new BigDecimal("7499"), (Object)((BigDecimal)employees.get(1)));
    }

    public void testOffsetTx() throws Exception {
        DefaultPagerCondition condition = new DefaultPagerCondition();
        condition.setLimit(2);
        condition.setOffset(1);
        PagerContext.getContext().pushArgs(new Object[]{condition});
        List employees = this.getEmployees();
        ScrollCursorTest.assertEquals((int)14, (int)condition.getCount());
        ScrollCursorTest.assertEquals((int)2, (int)employees.size());
        ScrollCursorTest.assertEquals((Object)new BigDecimal("7499"), (Object)((BigDecimal)employees.get(0)));
        ScrollCursorTest.assertEquals((Object)new BigDecimal("7521"), (Object)((BigDecimal)employees.get(1)));
    }

    public void testLastPageTx() throws Exception {
        DefaultPagerCondition condition = new DefaultPagerCondition();
        condition.setLimit(5);
        condition.setOffset(10);
        PagerContext.getContext().pushArgs(new Object[]{condition});
        List employees = this.getEmployees();
        ScrollCursorTest.assertEquals((int)14, (int)condition.getCount());
        ScrollCursorTest.assertEquals((int)4, (int)employees.size());
        ScrollCursorTest.assertEquals((Object)new BigDecimal("7876"), (Object)((BigDecimal)employees.get(0)));
        ScrollCursorTest.assertEquals((Object)new BigDecimal("7900"), (Object)((BigDecimal)employees.get(1)));
        ScrollCursorTest.assertEquals((Object)new BigDecimal("7902"), (Object)((BigDecimal)employees.get(2)));
        ScrollCursorTest.assertEquals((Object)new BigDecimal("7934"), (Object)((BigDecimal)employees.get(3)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getEmployees() throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>();
        PreparedStatement ps = this.pagerStatementFactory.createPreparedStatement(this.getConnection(), "SELECT EMPNO FROM EMP ORDER BY EMPNO");
        try {
            ResultSet rs = this.pagerResultSetFactoryWrapper.createResultSet(ps);
            try {
                while (rs.next()) {
                    result.add(rs.getObject(1));
                }
            }
            finally {
                ResultSetUtil.close((ResultSet)rs);
            }
        }
        finally {
            StatementUtil.close((Statement)ps);
        }
        return result;
    }
}

