/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.pager;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.seasar.dao.pager.DefaultPagerCondition;
import org.seasar.dao.pager.PagerCondition;
import org.seasar.dao.pager.PagerUtil;

public class PagerUtilTest
extends TestCase {
    private List list;
    DefaultPagerCondition condition;

    protected void setUp() throws Exception {
        this.list = new ArrayList();
        for (int i = 0; i < 21; ++i) {
            this.list.add(String.valueOf(i));
        }
        this.condition = new DefaultPagerCondition();
    }

    public void testFilter1() {
        this.condition.setLimit(10);
        this.condition.setOffset(0);
        List result = PagerUtil.filter((List)this.list, (PagerCondition)this.condition);
        PagerUtilTest.assertEquals((int)21, (int)this.condition.getCount());
        PagerUtilTest.assertEquals((int)10, (int)result.size());
        for (int i = 0; i < result.size(); ++i) {
            PagerUtilTest.assertEquals((Object)String.valueOf(i), result.get(i));
        }
    }

    public void testFilter2() {
        this.condition.setLimit(10);
        this.condition.setOffset(10);
        List result = PagerUtil.filter((List)this.list, (PagerCondition)this.condition);
        PagerUtilTest.assertEquals((int)21, (int)this.condition.getCount());
        PagerUtilTest.assertEquals((int)10, (int)result.size());
        for (int i = 0; i < result.size(); ++i) {
            PagerUtilTest.assertEquals((Object)String.valueOf(i + 10), result.get(i));
        }
    }

    public void testFilter3() {
        this.condition.setLimit(10);
        this.condition.setOffset(20);
        List result = PagerUtil.filter((List)this.list, (PagerCondition)this.condition);
        PagerUtilTest.assertEquals((int)21, (int)this.condition.getCount());
        PagerUtilTest.assertEquals((int)1, (int)result.size());
        for (int i = 0; i < result.size(); ++i) {
            PagerUtilTest.assertEquals((Object)String.valueOf(i + 20), result.get(i));
        }
    }

    public void testFilter4() {
        this.condition.setLimit(-1);
        this.condition.setOffset(20);
        List result = PagerUtil.filter((List)this.list, (PagerCondition)this.condition);
        PagerUtilTest.assertEquals((int)21, (int)this.condition.getCount());
        PagerUtilTest.assertEquals((int)21, (int)result.size());
        for (int i = 0; i < result.size(); ++i) {
            PagerUtilTest.assertEquals((Object)String.valueOf(i), result.get(i));
        }
    }

    public void testGetCurrentLastOffset() {
        this.condition.setLimit(10);
        this.condition.setOffset(0);
        this.condition.setCount(11);
        PagerUtilTest.assertEquals((int)9, (int)PagerUtil.getCurrentLastOffset((PagerCondition)this.condition));
        this.condition.setOffset(1);
        PagerUtilTest.assertEquals((int)10, (int)PagerUtil.getCurrentLastOffset((PagerCondition)this.condition));
        this.condition.setOffset(2);
        PagerUtilTest.assertEquals((int)10, (int)PagerUtil.getCurrentLastOffset((PagerCondition)this.condition));
    }
}

