/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.pager;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import junit.framework.TestCase;
import org.seasar.dao.mock.NullConnection;
import org.seasar.dao.pager.DefaultPagerCondition;
import org.seasar.dao.pager.PagerContext;
import org.seasar.dao.pager.PagerStatementFactory;
import org.seasar.extension.jdbc.impl.BooleanToIntPreparedStatement;

public class PagerStatementFactoryTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        PagerContext.start();
    }

    protected void tearDown() throws Exception {
        PagerContext.end();
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreatePreparedStatement_NoPager() throws Exception {
        PagerContext pagerContext = PagerContext.getContext();
        pagerContext.pushArgs(new Object[]{new Integer(1)});
        final boolean[] calls = new boolean[]{false};
        NullConnection con = new NullConnection(){

            public PreparedStatement prepareStatement(String sql) throws SQLException {
                calls[0] = true;
                return null;
            }
        };
        PreparedStatement pstmt = null;
        try {
            PagerStatementFactory statementFactory = new PagerStatementFactory();
            pstmt = statementFactory.createPreparedStatement((Connection)con, "aaaa");
        }
        finally {
            pagerContext.popArgs();
        }
        PagerStatementFactoryTest.assertEquals((boolean)true, (boolean)calls[0]);
        PagerStatementFactoryTest.assertNull((Object)pstmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreatePreparedStatement_Pager() throws Exception {
        PagerContext pagerContext = PagerContext.getContext();
        DefaultPagerCondition pagerCondition = new DefaultPagerCondition();
        pagerCondition.setLimit(10);
        pagerContext.pushArgs(new Object[]{pagerCondition});
        final boolean[] calls = new boolean[]{false};
        NullConnection con = new NullConnection(){

            public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
                calls[0] = true;
                return null;
            }
        };
        Object pstmt = null;
        try {
            PagerStatementFactory statementFactory = new PagerStatementFactory();
            statementFactory.createPreparedStatement((Connection)con, "aaaa");
        }
        finally {
            pagerContext.popArgs();
        }
        PagerStatementFactoryTest.assertEquals((boolean)true, (boolean)calls[0]);
        PagerStatementFactoryTest.assertNull(pstmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreatePreparedStatement_Pager_NoneLimit() throws Exception {
        PagerContext pagerContext = PagerContext.getContext();
        pagerContext.pushArgs(new Object[]{new DefaultPagerCondition()});
        final boolean[] calls = new boolean[]{false};
        NullConnection con = new NullConnection(){

            public PreparedStatement prepareStatement(String sql) throws SQLException {
                calls[0] = true;
                return null;
            }
        };
        PreparedStatement pstmt = null;
        try {
            PagerStatementFactory statementFactory = new PagerStatementFactory();
            pstmt = statementFactory.createPreparedStatement((Connection)con, "aaaa");
        }
        finally {
            pagerContext.popArgs();
        }
        PagerStatementFactoryTest.assertEquals((boolean)true, (boolean)calls[0]);
        PagerStatementFactoryTest.assertNull((Object)pstmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreatePreparedStatement_Pager_NoneLimitAndOffSet() throws Exception {
        PagerContext pagerContext = PagerContext.getContext();
        DefaultPagerCondition pagerCondition = new DefaultPagerCondition();
        pagerCondition.setOffset(10);
        pagerContext.pushArgs(new Object[]{pagerCondition});
        final boolean[] calls = new boolean[]{false};
        NullConnection con = new NullConnection(){

            public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
                calls[0] = true;
                return null;
            }
        };
        PreparedStatement pstmt = null;
        try {
            PagerStatementFactory statementFactory = new PagerStatementFactory();
            pstmt = statementFactory.createPreparedStatement((Connection)con, "aaaa");
        }
        finally {
            pagerContext.popArgs();
        }
        PagerStatementFactoryTest.assertEquals((boolean)true, (boolean)calls[0]);
        PagerStatementFactoryTest.assertNull((Object)pstmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreatePreparedStatement_NoPager_BooleanToInt() throws Exception {
        PagerContext pagerContext = PagerContext.getContext();
        pagerContext.pushArgs(new Object[]{new Integer(1)});
        final boolean[] calls = new boolean[]{false};
        NullConnection con = new NullConnection(){

            public PreparedStatement prepareStatement(String sql) throws SQLException {
                calls[0] = true;
                return null;
            }
        };
        PreparedStatement stmt = null;
        try {
            PagerStatementFactory statementFactory = new PagerStatementFactory();
            statementFactory.setBooleanToInt(true);
            stmt = statementFactory.createPreparedStatement((Connection)con, "aaaa");
        }
        finally {
            pagerContext.popArgs();
        }
        PagerStatementFactoryTest.assertEquals((boolean)true, (boolean)calls[0]);
        PagerStatementFactoryTest.assertTrue((boolean)(stmt instanceof BooleanToIntPreparedStatement));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreatePreparedStatement_Pager_BooleanToInt() throws Exception {
        PagerContext pagerContext = PagerContext.getContext();
        DefaultPagerCondition pagerCondition = new DefaultPagerCondition();
        pagerCondition.setLimit(10);
        pagerContext.pushArgs(new Object[]{pagerCondition});
        final boolean[] calls = new boolean[]{false};
        NullConnection con = new NullConnection(){

            public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
                calls[0] = true;
                return null;
            }
        };
        PreparedStatement stmt = null;
        try {
            PagerStatementFactory statementFactory = new PagerStatementFactory();
            statementFactory.setBooleanToInt(true);
            stmt = statementFactory.createPreparedStatement((Connection)con, "aaaa");
        }
        finally {
            pagerContext.popArgs();
        }
        PagerStatementFactoryTest.assertEquals((boolean)true, (boolean)calls[0]);
        PagerStatementFactoryTest.assertTrue((boolean)(stmt instanceof BooleanToIntPreparedStatement));
    }
}

