/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.pager;

import java.text.SimpleDateFormat;
import org.seasar.dao.pager.Customer;
import org.seasar.dao.pager.CustomerDao;
import org.seasar.dao.pager.DefaultPagerCondition;
import org.seasar.dao.pager.LimitOffsetPagingSqlRewriter;
import org.seasar.dao.pager.PagerTestCondition;
import org.seasar.dao.unit.S2DaoTestCase;
import org.seasar.extension.dataset.DataSet;

public class LimitOffsetPagingSqlRewriterTest
extends S2DaoTestCase {
    private static final int TEST_OFFSET = 18;
    private static final int TEST_LIMIT = 12;
    CustomerDao dao;
    LimitOffsetPagingSqlRewriter rewriter;

    protected void setUp() throws Exception {
        super.setUp();
        this.include("LimitOffsetTest.dicon");
        this.rewriter = new LimitOffsetPagingSqlRewriter();
    }

    public void testMakeCountSql() {
        LimitOffsetPagingSqlRewriterTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT) AS total", (String)this.rewriter.makeCountSql("SELECT * FROM DEPARTMENT"));
        LimitOffsetPagingSqlRewriterTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(order by \u9664\u53bb)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT ) AS total", (String)this.rewriter.makeCountSql("SELECT * FROM DEPARTMENT order by id"));
        LimitOffsetPagingSqlRewriterTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(ORDER BY \u9664\u53bb)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT ) AS total", (String)this.rewriter.makeCountSql("SELECT * FROM DEPARTMENT ORDER BY id"));
        LimitOffsetPagingSqlRewriterTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(whitespace\u4ed8\u304dorder by \u9664\u53bb)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT\n) AS total", (String)this.rewriter.makeCountSql("SELECT * FROM DEPARTMENT\norder by\n    id"));
        LimitOffsetPagingSqlRewriterTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(\u9014\u4e2d\u306eorder by\u306f\u9664\u53bb\u3057\u306a\u3044)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT WHERE name like '%order by%' ) AS total", (String)this.rewriter.makeCountSql("SELECT * FROM DEPARTMENT WHERE name like '%order by%' order by id"));
        LimitOffsetPagingSqlRewriterTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(\u9014\u4e2d\u306eorder by\u306f\u9664\u53bb\u3057\u306a\u3044)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT WHERE name='aaa'/*order by*/) AS total", (String)this.rewriter.makeCountSql("SELECT * FROM DEPARTMENT WHERE name='aaa'/*order by*/order by id"));
        LimitOffsetPagingSqlRewriterTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(\u9014\u4e2d\u306eorder by\u306f\u9664\u53bb\u3057\u306a\u3044)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT WHERE\n--order by\nname=1\n) AS total", (String)this.rewriter.makeCountSql("SELECT * FROM DEPARTMENT WHERE\n--order by\nname=1\norder by id"));
        LimitOffsetPagingSqlRewriterTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(order by\u9664\u53bb UNICODE)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT ) AS total", (String)this.rewriter.makeCountSql("SELECT * FROM DEPARTMENT order by \uff2e\uff2f"));
        LimitOffsetPagingSqlRewriterTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(order by\u9664\u53bb UNICODE)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT ) AS total", (String)this.rewriter.makeCountSql("SELECT * FROM DEPARTMENT order by \u540d\u524d, \u7d44\u7e54_ID"));
        LimitOffsetPagingSqlRewriterTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(order by\u9664\u53bb ASC,DESC)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT ) AS total", (String)this.rewriter.makeCountSql("SELECT * FROM DEPARTMENT order by \u540d\u524d ASC\n, \u7d44\u7e54_ID DESC"));
        LimitOffsetPagingSqlRewriterTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(order by\u9664\u53bb ASC,DESC+\u7a7a\u884c)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT ) AS total", (String)this.rewriter.makeCountSql("SELECT * FROM DEPARTMENT order\n\tby\n\n \u540d\u524d \n\tASC \n\n\n, \u7d44\u7e54_ID \n\tDESC \n"));
    }

    public void testSetChopOrderByAndMakeCountSql() throws Exception {
        LimitOffsetPagingSqlRewriterTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(chopOrderBy=true, order by \u9664\u53bb)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT ) AS total", (String)this.rewriter.makeCountSql("SELECT * FROM DEPARTMENT order by id"));
        this.rewriter.setChopOrderBy(false);
        LimitOffsetPagingSqlRewriterTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(chopOrderBy=false, order by \u9664\u53bb)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT order by id) AS total", (String)this.rewriter.makeCountSql("SELECT * FROM DEPARTMENT order by id"));
    }

    public void testLimitOffsetSql() throws Exception {
        LimitOffsetPagingSqlRewriterTest.assertEquals((String)"\u6307\u5b9a\u3055\u308c\u305flimit offset\u304c\u4ed8\u52a0\u3055\u308c\u305fSQL\u3092\u751f\u6210", (String)"SELECT * FROM DEPARTMENT LIMIT 10 OFFSET 55", (String)this.rewriter.makeLimitOffsetSql("SELECT * FROM DEPARTMENT", 10, 55));
    }

    public void testPagingTx() throws Exception {
        this.readXlsAllReplaceDb("PagerTestData.xls");
        DefaultPagerCondition condition = new DefaultPagerCondition();
        condition.setLimit(12);
        condition.setOffset(18);
        Customer[] test = this.dao.getPagedRow(condition);
        LimitOffsetPagingSqlRewriterTest.assertNotNull((Object)test);
        LimitOffsetPagingSqlRewriterTest.assertEquals((int)12, (int)test.length);
        for (int i = 0; i < 12; ++i) {
            LimitOffsetPagingSqlRewriterTest.assertEquals((int)(18 + i + 1), (int)test[i].getPriority());
        }
    }

    public void testWithSqlCommentTx() throws Exception {
        this.readXlsAllReplaceDb("PagerTestData.xls");
        DataSet expected = this.readXls("PagingData01.xls");
        PagerTestCondition condition = new PagerTestCondition();
        condition.setStartDate(new SimpleDateFormat("yyyy/MM/dd").parse("2006/01/01"));
        condition.setSortKey("PRIORITY");
        condition.setLimit(12);
        condition.setOffset(18);
        Customer[] actual = this.dao.getPagedRow2(condition);
        LimitOffsetPagingSqlRewriterTest.assertNotNull((Object)actual);
        this.assertEquals(expected, actual);
        LimitOffsetPagingSqlRewriterTest.assertEquals((int)81, (int)condition.getCount());
    }

    public void testPagingCompatibityFalseTx() throws Exception {
        this.rewriter.setCountSqlCompatibility(false);
        this.readXlsAllReplaceDb("PagerTestData.xls");
        DataSet expected = this.readXls("PagingData01.xls");
        PagerTestCondition condition = new PagerTestCondition();
        condition.setStartDate(new SimpleDateFormat("yyyy/MM/dd").parse("2006/01/01"));
        condition.setSortKey("PRIORITY");
        condition.setLimit(12);
        condition.setOffset(18);
        Customer[] actual = this.dao.getPagedRow2(condition);
        LimitOffsetPagingSqlRewriterTest.assertNotNull((Object)actual);
        this.assertEquals(expected, actual);
        LimitOffsetPagingSqlRewriterTest.assertEquals((int)81, (int)condition.getCount());
    }

    public void testNonPagingCompatibityFalseTx() throws Exception {
        this.rewriter.setCountSqlCompatibility(false);
        this.readXlsAllReplaceDb("PagerTestData.xls");
        DataSet expected = this.readXls("PagerTestData.xls");
        Customer[] actual = this.dao.getAll();
        LimitOffsetPagingSqlRewriterTest.assertNotNull((Object)actual);
        this.assertEquals(expected, actual);
    }
}

