/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import junit.textui.TestRunner;
import org.seasar.dao.SqlCommand;
import org.seasar.dao.UpdateFailureRuntimeException;
import org.seasar.dao.impl.DaoMetaDataImpl;
import org.seasar.dao.impl.Department;
import org.seasar.dao.impl.DepartmentAutoDao;
import org.seasar.dao.impl.Employee;
import org.seasar.dao.impl.EmployeeAutoDao;
import org.seasar.dao.unit.S2DaoTestCase;

public class UpdateAutoStaticCommandTest
extends S2DaoTestCase {
    public UpdateAutoStaticCommandTest(String arg0) {
        super(arg0);
    }

    public void testExecuteTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(EmployeeAutoDao.class);
        SqlCommand cmd = dmd.getSqlCommand("update");
        SqlCommand cmd2 = dmd.getSqlCommand("getEmployee");
        Employee emp = (Employee)cmd2.execute(new Object[]{new Integer(7788)});
        Integer count = (Integer)cmd.execute(new Object[]{emp});
        UpdateAutoStaticCommandTest.assertEquals((String)"1", (Object)new Integer(1), (Object)count);
    }

    public void testExecute2Tx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(DepartmentAutoDao.class);
        SqlCommand cmd = dmd.getSqlCommand("update");
        Department dept = new Department();
        dept.setDeptno(10);
        Integer count = (Integer)cmd.execute(new Object[]{dept});
        UpdateAutoStaticCommandTest.assertEquals((String)"1", (Object)new Integer(1), (Object)count);
        UpdateAutoStaticCommandTest.assertEquals((String)"2", (int)1, (int)dept.getVersionNo());
    }

    public void testExecute3Tx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(DepartmentAutoDao.class);
        SqlCommand cmd = dmd.getSqlCommand("update");
        Department dept = new Department();
        dept.setDeptno(10);
        dept.setVersionNo(-1);
        try {
            cmd.execute(new Object[]{dept});
            UpdateAutoStaticCommandTest.fail((String)"1");
        }
        catch (UpdateFailureRuntimeException ex) {
            System.out.println((Object)ex);
        }
    }

    public void testExecute4Tx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(EmployeeAutoDao.class);
        SqlCommand cmd = dmd.getSqlCommand("update2");
        SqlCommand cmd2 = dmd.getSqlCommand("getEmployee");
        Employee emp = (Employee)cmd2.execute(new Object[]{new Integer(7788)});
        Integer count = (Integer)cmd.execute(new Object[]{emp});
        UpdateAutoStaticCommandTest.assertEquals((String)"1", (Object)new Integer(1), (Object)count);
    }

    public void testExecute5Tx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(EmployeeAutoDao.class);
        SqlCommand cmd = dmd.getSqlCommand("update3");
        SqlCommand cmd2 = dmd.getSqlCommand("getEmployee");
        Employee emp = (Employee)cmd2.execute(new Object[]{new Integer(7788)});
        Integer count = (Integer)cmd.execute(new Object[]{emp});
        UpdateAutoStaticCommandTest.assertEquals((String)"1", (Object)new Integer(1), (Object)count);
    }

    public void setUp() {
        this.include("j2ee.dicon");
    }

    public static void main(String[] args) {
        TestRunner.run((Class)UpdateAutoStaticCommandTest.class);
    }
}

