/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import org.seasar.dao.AnnotationReaderFactory;
import org.seasar.dao.IllegalSignatureRuntimeException;
import org.seasar.dao.ProcedureMetaData;
import org.seasar.dao.ProcedureParameterType;
import org.seasar.dao.ValueTypeFactory;
import org.seasar.dao.impl.FieldAnnotationReaderFactory;
import org.seasar.dao.impl.ProcedureMetaDataFactoryImpl;
import org.seasar.dao.impl.ValueTypeFactoryImpl;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.extension.unit.S2TestCase;

public class ProcedureMetaDataFactoryImplTest
extends S2TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.include("j2ee-derby.dicon");
    }

    public void testCreateProcedureMetaData() throws Exception {
        String name = "PROCEDURE_TEST_CCC2";
        ProcedureMetaDataFactoryImpl factory = new ProcedureMetaDataFactoryImpl();
        factory.setValueTypeFactory((ValueTypeFactory)new ValueTypeFactoryImpl());
        factory.setAnnotationReaderFactory((AnnotationReaderFactory)new FieldAnnotationReaderFactory());
        factory.initialize();
        ProcedureMetaData metaData = factory.createProcedureMetaData(name, Dao.class.getMethod("execute", Hoge.class));
        ProcedureMetaDataFactoryImplTest.assertNotNull((Object)metaData);
        ProcedureMetaDataFactoryImplTest.assertEquals((int)3, (int)metaData.getParameterTypeSize());
        ProcedureParameterType ppt = metaData.getParameterType("ccc");
        ProcedureMetaDataFactoryImplTest.assertTrue((boolean)ppt.isOutType());
        ProcedureMetaDataFactoryImplTest.assertEquals((Object)ValueTypes.STRING, (Object)ppt.getValueType());
        ppt = metaData.getParameterType("ddd");
        ProcedureMetaDataFactoryImplTest.assertTrue((boolean)ppt.isInType());
        ProcedureMetaDataFactoryImplTest.assertEquals((Object)ValueTypes.INTEGER, (Object)ppt.getValueType());
        ppt = metaData.getParameterType("eee");
        ProcedureMetaDataFactoryImplTest.assertTrue((boolean)ppt.isOutType());
        ProcedureMetaDataFactoryImplTest.assertEquals((Object)ValueTypes.STRING, (Object)ppt.getValueType());
    }

    public void testCreateProcedureMetaData_noParameter() throws Exception {
        String name = "PROCEDURE_TEST_CCC2";
        ProcedureMetaDataFactoryImpl factory = new ProcedureMetaDataFactoryImpl();
        factory.setValueTypeFactory((ValueTypeFactory)new ValueTypeFactoryImpl());
        factory.setAnnotationReaderFactory((AnnotationReaderFactory)new FieldAnnotationReaderFactory());
        factory.initialize();
        ProcedureMetaData metaData = factory.createProcedureMetaData(name, Dao.class.getMethod("executeWithNoParameter", new Class[0]));
        ProcedureMetaDataFactoryImplTest.assertNotNull((Object)metaData);
        ProcedureMetaDataFactoryImplTest.assertEquals((int)0, (int)metaData.getParameterTypeSize());
    }

    public void testCreateProcedureMetaData_simpleParameter() throws Exception {
        String name = "PROCEDURE_TEST_CCC2";
        ProcedureMetaDataFactoryImpl factory = new ProcedureMetaDataFactoryImpl();
        factory.setValueTypeFactory((ValueTypeFactory)new ValueTypeFactoryImpl());
        factory.setAnnotationReaderFactory((AnnotationReaderFactory)new FieldAnnotationReaderFactory());
        factory.initialize();
        try {
            factory.createProcedureMetaData(name, Dao.class.getMethod("executeWithSimpleParameter", Integer.TYPE));
            ProcedureMetaDataFactoryImplTest.fail();
        }
        catch (IllegalSignatureRuntimeException e) {
            System.out.println(e.getMessage());
        }
    }

    public void testCreateProcedureMetaData_multiParameters() throws Exception {
        String name = "PROCEDURE_TEST_CCC2";
        ProcedureMetaDataFactoryImpl factory = new ProcedureMetaDataFactoryImpl();
        factory.setValueTypeFactory((ValueTypeFactory)new ValueTypeFactoryImpl());
        factory.setAnnotationReaderFactory((AnnotationReaderFactory)new FieldAnnotationReaderFactory());
        factory.initialize();
        try {
            factory.createProcedureMetaData(name, Dao.class.getMethod("executeWithMultiParameters", Hoge.class, Integer.TYPE));
            ProcedureMetaDataFactoryImplTest.fail();
        }
        catch (IllegalSignatureRuntimeException e) {
            System.out.println(e.getMessage());
        }
    }

    public static class Hoge {
        public static String PROCEDURE_PARAMETERS = null;
        public static String ccc_PROCEDURE_PARAMETER = "out";
        public static String ddd_PROCEDURE_PARAMETER = "in";
        public static String eee_PROCEDURE_PARAMETER = "out";
        private String ccc;
        private int ddd;
        private String eee;

        public String getCcc() {
            return this.ccc;
        }

        public void setCcc(String ccc) {
            this.ccc = ccc;
        }

        public int getDdd() {
            return this.ddd;
        }

        public void setDdd(int ddd) {
            this.ddd = ddd;
        }

        public String getEee() {
            return this.eee;
        }

        public void setEee(String eee) {
            this.eee = eee;
        }
    }

    public static interface Dao {
        public void execute(Hoge var1);

        public void executeWithNoParameter();

        public void executeWithSimpleParameter(int var1);

        public void executeWithMultiParameters(Hoge var1, int var2);
    }
}

