/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.lang.reflect.Field;
import junit.framework.TestCase;
import org.seasar.dao.impl.FieldArgumentDtoAnnotationReader;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;

public class FieldArgumentDtoAnnotationReaderTest
extends TestCase {
    private FieldArgumentDtoAnnotationReader reader = new FieldArgumentDtoAnnotationReader();
    private BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)Hoge.class);

    public void testGetProcedureParameter() throws Exception {
        Field field = this.beanDesc.getField("aaa");
        String value = this.reader.getProcedureParameter(this.beanDesc, field);
        FieldArgumentDtoAnnotationReaderTest.assertEquals((String)"in", (String)value);
    }

    public void testGetProcedureParameter_none() throws Exception {
        Field field = this.beanDesc.getField("bbb");
        String value = this.reader.getProcedureParameter(this.beanDesc, field);
        FieldArgumentDtoAnnotationReaderTest.assertNull((Object)value);
    }

    public void testGetProcedureParameter_public() throws Exception {
        Field field = this.beanDesc.getField("ccc");
        String value = this.reader.getProcedureParameter(this.beanDesc, field);
        FieldArgumentDtoAnnotationReaderTest.assertEquals((String)"out", (String)value);
    }

    public void testGetValueType() throws Exception {
        Field field = this.beanDesc.getField("aaa");
        FieldArgumentDtoAnnotationReaderTest.assertEquals((String)"hogeValueType", (String)this.reader.getValueType(this.beanDesc, field));
    }

    public static class Hoge {
        public static final String PROCEDURE_PARAMETERS = null;
        public static final String aaa_VALUE_TYPE = "hogeValueType";
        public static final String aaa_PROCEDURE_PARAMETER = "in";
        public static final String ccc_PROCEDURE_PARAMETER = "out";
        private String aaa;
        private String bbb;
        public String ccc;
    }
}

