/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.seasar.dao.DtoMetaData;
import org.seasar.dao.NotSingleResultRuntimeException;
import org.seasar.dao.RowCreator;
import org.seasar.dao.impl.DtoMetaDataResultSetHandler;
import org.seasar.dao.impl.EmployeeDto;
import org.seasar.dao.impl.RowCreatorImpl;
import org.seasar.dao.unit.S2DaoTestCase;

public class DtoMetaDataResultSetHandlerTest
extends S2DaoTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHandle() throws Exception {
        DtoMetaDataResultSetHandler handler = new DtoMetaDataResultSetHandler((DtoMetaData)this.createDtoMetaData(EmployeeDto.class), this.createRowCreator());
        String sql = "select empno, ename, dname from emp, dept where empno = 7788 and emp.deptno = dept.deptno";
        Connection con = this.getConnection();
        PreparedStatement ps = con.prepareStatement(sql);
        EmployeeDto dto = null;
        try {
            ResultSet rs = ps.executeQuery();
            try {
                dto = (EmployeeDto)handler.handle(rs);
            }
            finally {
                rs.close();
            }
        }
        finally {
            ps.close();
        }
        DtoMetaDataResultSetHandlerTest.assertNotNull((Object)dto);
        DtoMetaDataResultSetHandlerTest.assertEquals((long)7788L, (long)dto.getEmpno());
        DtoMetaDataResultSetHandlerTest.assertEquals((String)"SCOTT", (String)dto.getEname());
        DtoMetaDataResultSetHandlerTest.assertEquals((String)"RESEARCH", (String)dto.getDname());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHandleRestrict() throws Exception {
        DtoMetaDataResultSetHandler.RestrictDtoMetaDataResultSetHandler handler = new DtoMetaDataResultSetHandler.RestrictDtoMetaDataResultSetHandler((DtoMetaData)this.createDtoMetaData(EmployeeDto.class), this.createRowCreator());
        String sql = "select empno, ename, dname from emp, dept where emp.deptno = dept.deptno";
        Connection con = this.getConnection();
        PreparedStatement ps = con.prepareStatement(sql);
        EmployeeDto dto = null;
        try {
            ResultSet rs = ps.executeQuery();
            try {
                try {
                    dto = (EmployeeDto)handler.handle(rs);
                    DtoMetaDataResultSetHandlerTest.fail();
                }
                catch (NotSingleResultRuntimeException e) {
                    DtoMetaDataResultSetHandlerTest.assertTrue((boolean)true);
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            ps.close();
        }
        DtoMetaDataResultSetHandlerTest.assertNull((Object)dto);
    }

    protected RowCreator createRowCreator() {
        return new RowCreatorImpl();
    }

    public void setUp() {
        this.include("j2ee.dicon");
    }
}

