/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.NotSingleResultRuntimeException;
import org.seasar.dao.RelationRowCreator;
import org.seasar.dao.RowCreator;
import org.seasar.dao.impl.BeanMetaDataResultSetHandler;
import org.seasar.dao.impl.Department;
import org.seasar.dao.impl.Employee;
import org.seasar.dao.impl.Employee23;
import org.seasar.dao.impl.RelationRowCreatorImpl;
import org.seasar.dao.impl.RowCreatorImpl;
import org.seasar.dao.unit.S2DaoTestCase;

public class BeanMetaDataResultSetHandlerTest
extends S2DaoTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHandle() throws Exception {
        BeanMetaData beanMetaData = this.createBeanMetaData(Employee.class);
        BeanMetaDataResultSetHandler handler = new BeanMetaDataResultSetHandler(beanMetaData, this.createRowCreator(), this.createRelationRowCreator());
        String sql = "select emp.*, dept.deptno as deptno_0, dept.dname as dname_0 from emp, dept where empno = 7788 and emp.deptno = dept.deptno";
        Connection con = this.getConnection();
        PreparedStatement ps = con.prepareStatement(sql);
        Employee ret = null;
        try {
            ResultSet rs = ps.executeQuery();
            try {
                ret = (Employee)handler.handle(rs);
            }
            finally {
                rs.close();
            }
        }
        finally {
            ps.close();
        }
        BeanMetaDataResultSetHandlerTest.assertNotNull((String)"1", (Object)ret);
        System.out.println(ret.getEmpno() + "," + ret.getEname());
        Department dept = ret.getDepartment();
        BeanMetaDataResultSetHandlerTest.assertNotNull((String)"2", (Object)dept);
        BeanMetaDataResultSetHandlerTest.assertEquals((String)"3", (int)20, (int)dept.getDeptno());
        BeanMetaDataResultSetHandlerTest.assertEquals((String)"4", (String)"RESEARCH", (String)dept.getDname());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHandle2() throws Exception {
        BeanMetaData beanMetaData = this.createBeanMetaData(Employee.class);
        BeanMetaDataResultSetHandler handler = new BeanMetaDataResultSetHandler(beanMetaData, this.createRowCreator(), this.createRelationRowCreator());
        String sql = "select ename, job from emp where empno = 7788";
        Connection con = this.getConnection();
        PreparedStatement ps = con.prepareStatement(sql);
        Employee ret = null;
        try {
            ResultSet rs = ps.executeQuery();
            try {
                ret = (Employee)handler.handle(rs);
            }
            finally {
                rs.close();
            }
        }
        finally {
            ps.close();
        }
        BeanMetaDataResultSetHandlerTest.assertNotNull((String)"1", (Object)ret);
        System.out.println(ret.getEmpno() + "," + ret.getEname());
        Department dept = ret.getDepartment();
        BeanMetaDataResultSetHandlerTest.assertNull((String)"2", (Object)dept);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHandle_relationshipIsNull() throws Exception {
        BeanMetaData beanMetaData = this.createBeanMetaData(Employee23.class);
        BeanMetaDataResultSetHandler handler = new BeanMetaDataResultSetHandler(beanMetaData, this.createRowCreator(), this.createRelationRowCreator());
        String sql = "select emp.empno, emp.ename, emp.deptno, department.deptno as deptno_0, department.dname as dname_0 from EMP5 emp LEFT OUTER JOIN DEPT department on emp.deptno = department.deptno where emp.empno = 7788";
        Connection con = this.getConnection();
        PreparedStatement ps = con.prepareStatement(sql);
        Employee23 ret = null;
        try {
            ResultSet rs = ps.executeQuery();
            try {
                ret = (Employee23)handler.handle(rs);
            }
            finally {
                rs.close();
            }
        }
        finally {
            ps.close();
        }
        BeanMetaDataResultSetHandlerTest.assertNotNull((Object)ret);
        BeanMetaDataResultSetHandlerTest.assertEquals((long)7788L, (long)ret.getEmpno());
        BeanMetaDataResultSetHandlerTest.assertEquals((String)"SCOTT", (String)ret.getEname());
        BeanMetaDataResultSetHandlerTest.assertNull((Object)ret.getDeptno());
        BeanMetaDataResultSetHandlerTest.assertNull((Object)ret.getDepartment());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHandle_relationshipIsNotNull() throws Exception {
        BeanMetaData beanMetaData = this.createBeanMetaData(Employee23.class);
        BeanMetaDataResultSetHandler handler = new BeanMetaDataResultSetHandler(beanMetaData, this.createRowCreator(), this.createRelationRowCreator());
        String sql = "select emp.empno, emp.ename, emp.deptno, department.deptno as deptno_0, department.dname as dname_0 from EMP5 emp LEFT OUTER JOIN DEPT department on emp.deptno = department.deptno where emp.empno = 7839";
        Connection con = this.getConnection();
        PreparedStatement ps = con.prepareStatement(sql);
        Employee23 ret = null;
        try {
            ResultSet rs = ps.executeQuery();
            try {
                ret = (Employee23)handler.handle(rs);
            }
            finally {
                rs.close();
            }
        }
        finally {
            ps.close();
        }
        BeanMetaDataResultSetHandlerTest.assertNotNull((Object)ret);
        BeanMetaDataResultSetHandlerTest.assertEquals((long)7839L, (long)ret.getEmpno());
        BeanMetaDataResultSetHandlerTest.assertEquals((String)"KING", (String)ret.getEname());
        BeanMetaDataResultSetHandlerTest.assertEquals((Object)new Integer(10), (Object)ret.getDeptno());
        Department dept = ret.getDepartment();
        BeanMetaDataResultSetHandlerTest.assertNotNull((Object)dept);
        BeanMetaDataResultSetHandlerTest.assertEquals((int)10, (int)dept.getDeptno());
        BeanMetaDataResultSetHandlerTest.assertEquals((String)"ACCOUNTING", (String)dept.getDname());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHandle_notSingleResult() throws Exception {
        BeanMetaData beanMetaData = this.createBeanMetaData(Employee23.class);
        BeanMetaDataResultSetHandler.RestrictBeanMetaDataResultSetHandler handler = new BeanMetaDataResultSetHandler.RestrictBeanMetaDataResultSetHandler(beanMetaData, this.createRowCreator(), this.createRelationRowCreator());
        String sql = "select emp.empno, emp.ename, emp.deptno, department.deptno as deptno_0, department.dname as dname_0 from EMP5 emp LEFT OUTER JOIN DEPT department on emp.deptno = department.deptno";
        Connection con = this.getConnection();
        PreparedStatement ps = con.prepareStatement(sql);
        Employee23 ret = null;
        try {
            ResultSet rs = ps.executeQuery();
            try {
                try {
                    ret = (Employee23)handler.handle(rs);
                    BeanMetaDataResultSetHandlerTest.fail();
                }
                catch (NotSingleResultRuntimeException e) {
                    BeanMetaDataResultSetHandlerTest.assertTrue((boolean)true);
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            ps.close();
        }
        BeanMetaDataResultSetHandlerTest.assertNull((Object)ret);
    }

    protected RowCreator createRowCreator() {
        return new RowCreatorImpl();
    }

    protected RelationRowCreator createRelationRowCreator() {
        return new RelationRowCreatorImpl();
    }

    public void setUp() {
        this.include("j2ee.dicon");
    }
}

