/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.RelationRowCreator;
import org.seasar.dao.RowCreator;
import org.seasar.dao.impl.BeanListMetaDataResultSetHandler;
import org.seasar.dao.impl.Department;
import org.seasar.dao.impl.Employee;
import org.seasar.dao.impl.Employee23;
import org.seasar.dao.impl.RelationRowCreatorImpl;
import org.seasar.dao.impl.RowCreatorImpl;
import org.seasar.dao.unit.S2DaoTestCase;

public class BeanListMetaDataResultSetHandlerTest
extends S2DaoTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHandle() throws Exception {
        BeanMetaData beanMetaData = this.createBeanMetaData(Employee.class);
        BeanListMetaDataResultSetHandler handler = new BeanListMetaDataResultSetHandler(beanMetaData, this.createRowCreator(), this.createRelationRowCreator());
        String sql = "select * from emp";
        Connection con = this.getConnection();
        PreparedStatement ps = con.prepareStatement(sql);
        List ret = null;
        try {
            ResultSet rs = ps.executeQuery();
            try {
                ret = (List)handler.handle(rs);
            }
            finally {
                rs.close();
            }
        }
        finally {
            ps.close();
        }
        BeanListMetaDataResultSetHandlerTest.assertNotNull((String)"1", (Object)ret);
        for (int i = 0; i < ret.size(); ++i) {
            Employee emp = (Employee)ret.get(i);
            System.out.println(emp.getEmpno() + "," + emp.getEname());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHandle2() throws Exception {
        BeanMetaData beanMetaData = this.createBeanMetaData(Employee.class);
        BeanListMetaDataResultSetHandler handler = new BeanListMetaDataResultSetHandler(beanMetaData, this.createRowCreator(), this.createRelationRowCreator());
        String sql = "select emp.*, dept.dname as dname_0 from emp, dept where emp.deptno = dept.deptno and emp.deptno = 20";
        Connection con = this.getConnection();
        PreparedStatement ps = con.prepareStatement(sql);
        List ret = null;
        try {
            ResultSet rs = ps.executeQuery();
            try {
                ret = (List)handler.handle(rs);
            }
            finally {
                rs.close();
            }
        }
        finally {
            ps.close();
        }
        BeanListMetaDataResultSetHandlerTest.assertNotNull((String)"1", (Object)ret);
        for (int i = 0; i < ret.size(); ++i) {
            Employee emp = (Employee)ret.get(i);
            System.out.println(emp);
            Department dept = emp.getDepartment();
            BeanListMetaDataResultSetHandlerTest.assertNotNull((String)"2", (Object)dept);
            BeanListMetaDataResultSetHandlerTest.assertEquals((String)"3", (int)emp.getDeptno(), (int)dept.getDeptno());
            BeanListMetaDataResultSetHandlerTest.assertNotNull((String)"4", (Object)dept.getDname());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHandle3() throws Exception {
        BeanMetaData beanMetaData = this.createBeanMetaData(Employee.class);
        BeanListMetaDataResultSetHandler handler = new BeanListMetaDataResultSetHandler(beanMetaData, this.createRowCreator(), this.createRelationRowCreator());
        String sql = "select emp.*, dept.deptno as deptno_0, dept.dname as dname_0 from emp, dept where dept.deptno = 20 and emp.deptno = dept.deptno";
        Connection con = this.getConnection();
        PreparedStatement ps = con.prepareStatement(sql);
        List ret = null;
        try {
            ResultSet rs = ps.executeQuery();
            try {
                ret = (List)handler.handle(rs);
            }
            finally {
                rs.close();
            }
        }
        finally {
            ps.close();
        }
        Employee emp = (Employee)ret.get(0);
        Employee emp2 = (Employee)ret.get(1);
        BeanListMetaDataResultSetHandlerTest.assertSame((String)"1", (Object)emp.getDepartment(), (Object)emp2.getDepartment());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHandle_relationship() throws Exception {
        BeanMetaData beanMetaData = this.createBeanMetaData(Employee23.class);
        BeanListMetaDataResultSetHandler handler = new BeanListMetaDataResultSetHandler(beanMetaData, this.createRowCreator(), this.createRelationRowCreator());
        String sql = "select emp.empno, emp.ename, emp.deptno, department.deptno as deptno_0, department.dname as dname_0 from EMP5 emp LEFT OUTER JOIN DEPT department on emp.deptno = department.deptno order by emp.empno";
        Connection con = this.getConnection();
        PreparedStatement ps = con.prepareStatement(sql);
        List ret = null;
        try {
            ResultSet rs = ps.executeQuery();
            try {
                ret = (List)handler.handle(rs);
            }
            finally {
                rs.close();
            }
        }
        finally {
            ps.close();
        }
        Employee23 emp = (Employee23)ret.get(0);
        BeanListMetaDataResultSetHandlerTest.assertNull((Object)emp.getDepartment());
        Employee23 emp2 = (Employee23)ret.get(1);
        Department dept2 = emp2.getDepartment();
        BeanListMetaDataResultSetHandlerTest.assertNotNull((Object)dept2);
        BeanListMetaDataResultSetHandlerTest.assertEquals((int)10, (int)dept2.getDeptno());
        BeanListMetaDataResultSetHandlerTest.assertEquals((String)"ACCOUNTING", (String)dept2.getDname());
    }

    protected RowCreator createRowCreator() {
        return new RowCreatorImpl();
    }

    protected RelationRowCreator createRelationRowCreator() {
        return new RelationRowCreatorImpl();
    }

    public void setUp() {
        this.include("j2ee.dicon");
    }
}

