/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import org.seasar.dao.SqlCommand;
import org.seasar.dao.impl.DaoMetaDataImpl;
import org.seasar.dao.impl.Procedures;
import org.seasar.dao.unit.S2DaoTestCase;
import org.seasar.framework.exception.SIllegalArgumentException;

public class ArgumentDtoProcedureCommandTest
extends S2DaoTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.include("j2ee-derby.dicon");
        Procedures.params = new HashMap();
    }

    protected void tearDown() throws Exception {
        Procedures.params = null;
        super.tearDown();
    }

    public void testOutParameterTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(Dao.class);
        SqlCommand command = dmd.getSqlCommand("executeAaa1");
        Aaa1 dto = new Aaa1();
        command.execute(new Object[]{dto});
        ArgumentDtoProcedureCommandTest.assertNotNull((Object)dto.getFoo());
    }

    public void testMultiOutParametersTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(Dao.class);
        SqlCommand command = dmd.getSqlCommand("executeAaa2");
        Aaa2 dto = new Aaa2();
        command.execute(new Object[]{dto});
        ArgumentDtoProcedureCommandTest.assertNotNull((Object)dto.getBbb());
        ArgumentDtoProcedureCommandTest.assertNotNull((Object)dto.getCcc());
    }

    public void testEmptyArgumentTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(Dao.class);
        SqlCommand command = dmd.getSqlCommand("executeAaa3");
        command.execute(new Object[0]);
        ArgumentDtoProcedureCommandTest.assertTrue((boolean)Procedures.isAaa3Invoked);
    }

    public void testInParameterTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(Dao.class);
        SqlCommand command = dmd.getSqlCommand("executeBbb1");
        Bbb1 dto = new Bbb1();
        dto.setCcc("hoge");
        command.execute(new Object[]{dto});
        ArgumentDtoProcedureCommandTest.assertEquals((Object)"hoge", Procedures.params.get("ccc"));
    }

    public void testMultiInParametersTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(Dao.class);
        SqlCommand command = dmd.getSqlCommand("executeBbb2");
        Bbb2 dto = new Bbb2();
        dto.setCcc("hoge");
        dto.setDdd(new BigDecimal("10"));
        dto.setXxx(Timestamp.valueOf("2007-08-26 14:30:00"));
        command.execute(new Object[]{dto});
        ArgumentDtoProcedureCommandTest.assertEquals((Object)"hoge", Procedures.params.get("ccc"));
        ArgumentDtoProcedureCommandTest.assertEquals((Object)new BigDecimal("10"), (Object)((BigDecimal)Procedures.params.get("ddd")));
        ArgumentDtoProcedureCommandTest.assertEquals((Object)Timestamp.valueOf("2007-08-26 14:30:00"), (Object)((Timestamp)Procedures.params.get("eee")));
    }

    public void testInOutMixedParametersTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(Dao.class);
        SqlCommand command = dmd.getSqlCommand("executeCcc1");
        Ccc1 dto = new Ccc1();
        dto.setCcc("hoge");
        dto.setDdd(new BigDecimal("10"));
        command.execute(new Object[]{dto});
        ArgumentDtoProcedureCommandTest.assertEquals((Object)"hoge", Procedures.params.get("ccc"));
        ArgumentDtoProcedureCommandTest.assertEquals((Object)new BigDecimal("10"), (Object)((BigDecimal)Procedures.params.get("ddd")));
        ArgumentDtoProcedureCommandTest.assertNotNull((Object)dto.getEee());
    }

    public void testNullArgumentTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(Dao.class);
        SqlCommand command = dmd.getSqlCommand("executeCcc1");
        try {
            command.execute(new Object[]{null});
            ArgumentDtoProcedureCommandTest.fail();
        }
        catch (SIllegalArgumentException e) {
            ArgumentDtoProcedureCommandTest.assertEquals((String)"EDAO0029", (String)e.getMessageCode());
            System.out.println(e.getMessage());
        }
    }

    public void testInOutMixedParameters2Tx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(Dao.class);
        SqlCommand command = dmd.getSqlCommand("executeCcc2");
        Ccc2 dto = new Ccc2();
        dto.setDdd(new BigDecimal("10"));
        command.execute(new Object[]{dto});
        ArgumentDtoProcedureCommandTest.assertNotNull((Object)dto.getCcc());
        ArgumentDtoProcedureCommandTest.assertEquals((Object)new BigDecimal("10"), (Object)((BigDecimal)Procedures.params.get("ddd")));
        ArgumentDtoProcedureCommandTest.assertNotNull((Object)dto.getEee());
    }

    public void testInOutParameterTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(Dao.class);
        SqlCommand command = dmd.getSqlCommand("executeDdd1");
        Ddd1 dto = new Ddd1();
        dto.setCcc("ab");
        command.execute(new Object[]{dto});
        ArgumentDtoProcedureCommandTest.assertEquals((String)"abcd", (String)dto.getCcc());
    }

    public void testReturnParameterTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(Dao.class);
        SqlCommand command = dmd.getSqlCommand("max");
        MaxDto dto = new MaxDto();
        dto.setBbb(5.0);
        dto.setCcc(10.0);
        command.execute(new Object[]{dto});
        ArgumentDtoProcedureCommandTest.assertEquals((double)10.0, (double)dto.getAaa(), (double)0.0);
    }

    public static class MaxDto {
        public static String aaa_PROCEDURE_PARAMETER = "return";
        public static String bbb_PROCEDURE_PARAMETER = "in";
        public static String ccc_PROCEDURE_PARAMETER = "in";
        private double aaa;
        private double bbb;
        private double ccc;

        public double getAaa() {
            return this.aaa;
        }

        public void setAaa(double aaa) {
            this.aaa = aaa;
        }

        public double getBbb() {
            return this.bbb;
        }

        public void setBbb(double bbb) {
            this.bbb = bbb;
        }

        public double getCcc() {
            return this.ccc;
        }

        public void setCcc(double ccc) {
            this.ccc = ccc;
        }
    }

    public static class Ddd1 {
        public static String ccc_PROCEDURE_PARAMETER = "inout";
        private String ccc;

        public String getCcc() {
            return this.ccc;
        }

        public void setCcc(String ccc) {
            this.ccc = ccc;
        }
    }

    public static class Ccc2 {
        public static String ccc_PROCEDURE_PARAMETER = "out";
        public static String ddd_PROCEDURE_PARAMETER = "in";
        public static String eee_PROCEDURE_PARAMETER = "out";
        private String ccc;
        private BigDecimal ddd;
        private String eee;

        public String getCcc() {
            return this.ccc;
        }

        public void setCcc(String ccc) {
            this.ccc = ccc;
        }

        public BigDecimal getDdd() {
            return this.ddd;
        }

        public void setDdd(BigDecimal ddd) {
            this.ddd = ddd;
        }

        public String getEee() {
            return this.eee;
        }

        public void setEee(String eee) {
            this.eee = eee;
        }
    }

    public static class Ccc1 {
        public static String ccc_PROCEDURE_PARAMETER = "in";
        public static String ddd_PROCEDURE_PARAMETER = "in";
        public static String eee_PROCEDURE_PARAMETER = "out";
        private String ccc;
        private BigDecimal ddd;
        private String eee;

        public String getCcc() {
            return this.ccc;
        }

        public void setCcc(String ccc) {
            this.ccc = ccc;
        }

        public BigDecimal getDdd() {
            return this.ddd;
        }

        public void setDdd(BigDecimal ddd) {
            this.ddd = ddd;
        }

        public String getEee() {
            return this.eee;
        }

        public void setEee(String eee) {
            this.eee = eee;
        }
    }

    public static class Bbb2 {
        public static String ccc_PROCEDURE_PARAMETER = "in";
        public static String ddd_PROCEDURE_PARAMETER = "in";
        public static String xxx_PROCEDURE_PARAMETER = "in";
        private String ccc;
        private BigDecimal ddd;
        private Timestamp xxx;

        public String getCcc() {
            return this.ccc;
        }

        public void setCcc(String ccc) {
            this.ccc = ccc;
        }

        public BigDecimal getDdd() {
            return this.ddd;
        }

        public void setDdd(BigDecimal ddd) {
            this.ddd = ddd;
        }

        public Timestamp getXxx() {
            return this.xxx;
        }

        public void setXxx(Timestamp xxx) {
            this.xxx = xxx;
        }
    }

    public static class Bbb1 {
        public static String ccc_PROCEDURE_PARAMETER = "in";
        private String ccc;

        public String getCcc() {
            return this.ccc;
        }

        public void setCcc(String ccc) {
            this.ccc = ccc;
        }
    }

    public static class Aaa2 {
        public static String bbb_PROCEDURE_PARAMETER = "out";
        public static String ccc_PROCEDURE_PARAMETER = "out";
        private String bbb;
        private Timestamp ccc;

        public String getBbb() {
            return this.bbb;
        }

        public void setBbb(String bbb) {
            this.bbb = bbb;
        }

        public Timestamp getCcc() {
            return this.ccc;
        }

        public void setCcc(Timestamp ccc) {
            this.ccc = ccc;
        }
    }

    public static class Aaa1 {
        public static String foo_PROCEDURE_PARAMETER = "out";
        private String foo;

        public String getFoo() {
            return this.foo;
        }

        public void setFoo(String foo) {
            this.foo = foo;
        }
    }

    public static interface Dao {
        public static final String executeAaa1_PROCEDURE_CALL = "PROCEDURE_TEST_AAA1";
        public static final String executeAaa2_PROCEDURE_CALL = "PROCEDURE_TEST_AAA2";
        public static final String executeAaa3_PROCEDURE_CALL = "PROCEDURE_TEST_AAA3";
        public static final String executeBbb1_PROCEDURE_CALL = "PROCEDURE_TEST_BBB1";
        public static final String executeBbb2_PROCEDURE_CALL = "PROCEDURE_TEST_BBB2";
        public static final String executeCcc1_PROCEDURE_CALL = "PROCEDURE_TEST_CCC1";
        public static final String executeCcc2_PROCEDURE_CALL = "PROCEDURE_TEST_CCC2";
        public static final String executeDdd1_PROCEDURE_CALL = "PROCEDURE_TEST_DDD1";
        public static final String max_PROCEDURE_CALL = "FUNCTION_TEST_MAX";

        public void executeAaa1(Aaa1 var1);

        public void executeAaa2(Aaa2 var1);

        public void executeAaa3();

        public void executeBbb1(Bbb1 var1);

        public void executeBbb2(Bbb2 var1);

        public void executeCcc1(Ccc1 var1);

        public void executeCcc2(Ccc2 var1);

        public void executeDdd1(Ddd1 var1);

        public double max(MaxDto var1);
    }
}

