/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import junit.framework.TestCase;
import org.seasar.dao.BeanAnnotationReader;
import org.seasar.dao.Dbms;
import org.seasar.dao.dbms.HSQL;
import org.seasar.dao.dbms.MySQL;
import org.seasar.dao.dbms.Oracle;
import org.seasar.dao.dbms.PostgreSQL;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;

public abstract class AbstractBeanAnnotationReaderTest
extends TestCase {
    protected abstract Class getBeanClass(String var1);

    protected abstract BeanAnnotationReader createBeanAnnotationReader(Class var1);

    public void testGetColumnAnnotation() {
        Class clazz = this.getBeanClass("AnnotationTestBean1");
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)clazz);
        BeanAnnotationReader reader = this.createBeanAnnotationReader(clazz);
        AbstractBeanAnnotationReaderTest.assertEquals((String)"1", (String)"Cprop1", (String)reader.getColumnAnnotation(beanDesc.getPropertyDesc("prop1")));
        AbstractBeanAnnotationReaderTest.assertEquals((String)"2", (String)null, (String)reader.getColumnAnnotation(beanDesc.getPropertyDesc("prop2")));
    }

    public void testGetTableAnnotation() {
        Class clazz1 = this.getBeanClass("AnnotationTestBean1");
        BeanAnnotationReader reader1 = this.createBeanAnnotationReader(clazz1);
        AbstractBeanAnnotationReaderTest.assertEquals((String)"1", (String)"TABLE", (String)reader1.getTableAnnotation());
        Class clazz2 = this.getBeanClass("AnnotationTestBean2");
        BeanAnnotationReader reader2 = this.createBeanAnnotationReader(clazz2);
        AbstractBeanAnnotationReaderTest.assertNull((String)"2", (Object)reader2.getTableAnnotation());
    }

    public void testGetVersionNoProteryNameAnnotation() {
        Class clazz1 = this.getBeanClass("AnnotationTestBean1");
        BeanAnnotationReader reader1 = this.createBeanAnnotationReader(clazz1);
        String str1 = reader1.getVersionNoPropertyName();
        AbstractBeanAnnotationReaderTest.assertEquals((String)"1", (String)"myVersionNo", (String)str1);
        Class clazz2 = this.getBeanClass("AnnotationTestBean2");
        BeanAnnotationReader reader2 = this.createBeanAnnotationReader(clazz2);
        String str2 = reader2.getVersionNoPropertyName();
        AbstractBeanAnnotationReaderTest.assertNull((String)"1", (Object)str2);
    }

    public void testGetTimestampPropertyName() {
        Class clazz1 = this.getBeanClass("AnnotationTestBean1");
        BeanAnnotationReader reader1 = this.createBeanAnnotationReader(clazz1);
        String str1 = reader1.getTimestampPropertyName();
        AbstractBeanAnnotationReaderTest.assertEquals((String)"1", (String)"myTimestamp", (String)str1);
        Class clazz2 = this.getBeanClass("AnnotationTestBean2");
        BeanAnnotationReader reader2 = this.createBeanAnnotationReader(clazz2);
        String str2 = reader2.getTimestampPropertyName();
        AbstractBeanAnnotationReaderTest.assertNull((String)"1", (Object)str2);
    }

    public void testGetIds() {
        Class clazz1 = this.getBeanClass("AnnotationTestBean4");
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)clazz1);
        BeanAnnotationReader reader1 = this.createBeanAnnotationReader(clazz1);
        String str1 = reader1.getId(beanDesc.getPropertyDesc("aaa"), (Dbms)new Oracle());
        AbstractBeanAnnotationReaderTest.assertEquals((String)"1", (String)"identity", (String)str1);
        String str2 = reader1.getId(beanDesc.getPropertyDesc("aaa"), (Dbms)new MySQL());
        AbstractBeanAnnotationReaderTest.assertEquals((String)"2", (String)"sequence, sequenceName=myseq, allocationSize=0", (String)str2);
        String str3 = reader1.getId(beanDesc.getPropertyDesc("aaa"), (Dbms)new PostgreSQL());
        AbstractBeanAnnotationReaderTest.assertEquals((String)"3", (String)"sequence, sequenceName=myseq_2, allocationSize=10", (String)str3);
        String str4 = reader1.getId(beanDesc.getPropertyDesc("bbb"), (Dbms)new MySQL());
        AbstractBeanAnnotationReaderTest.assertNull((String)"4", (Object)str4);
    }

    public void testGetId1() {
        Class clazz1 = this.getBeanClass("AnnotationTestBean5");
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)clazz1);
        BeanAnnotationReader reader1 = this.createBeanAnnotationReader(clazz1);
        String str1 = reader1.getId(beanDesc.getPropertyDesc("aaa"), (Dbms)new Oracle());
        AbstractBeanAnnotationReaderTest.assertEquals((String)"1", (String)"identity", (String)str1);
        String str2 = reader1.getId(beanDesc.getPropertyDesc("aaa"), (Dbms)new HSQL());
        AbstractBeanAnnotationReaderTest.assertNull((String)"2", (Object)str2);
        String str3 = reader1.getId(beanDesc.getPropertyDesc("bbb"), (Dbms)new Oracle());
        AbstractBeanAnnotationReaderTest.assertNull((String)"3", (Object)str3);
    }

    public void testGetId2() {
        Class clazz1 = this.getBeanClass("AnnotationTestBean6");
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)clazz1);
        BeanAnnotationReader reader1 = this.createBeanAnnotationReader(clazz1);
        String str1 = reader1.getId(beanDesc.getPropertyDesc("aaa"), (Dbms)new Oracle());
        AbstractBeanAnnotationReaderTest.assertEquals((String)"1", (String)"identity", (String)str1);
        String str3 = reader1.getId(beanDesc.getPropertyDesc("bbb"), (Dbms)new Oracle());
        AbstractBeanAnnotationReaderTest.assertNull((String)"2", (Object)str3);
    }

    public void testGetNoPersisteneProps() {
        Class clazz1 = this.getBeanClass("AnnotationTestBean1");
        BeanAnnotationReader reader1 = this.createBeanAnnotationReader(clazz1);
        String[] strings1 = reader1.getNoPersisteneProps();
        AbstractBeanAnnotationReaderTest.assertEquals((String)"1", (String)"prop2", (String)strings1[0]);
        Class clazz2 = this.getBeanClass("AnnotationTestBean2");
        BeanAnnotationReader reader2 = this.createBeanAnnotationReader(clazz2);
        String[] strings2 = reader2.getNoPersisteneProps();
        AbstractBeanAnnotationReaderTest.assertNull((String)"1", (Object)strings2);
    }

    public void testGetRelationKey() {
        Class clazz1 = this.getBeanClass("AnnotationTestBean1");
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)clazz1);
        BeanAnnotationReader reader1 = this.createBeanAnnotationReader(clazz1);
        PropertyDesc pd = beanDesc.getPropertyDesc("department");
        AbstractBeanAnnotationReaderTest.assertTrue((String)"1", (boolean)reader1.hasRelationNo(pd));
        AbstractBeanAnnotationReaderTest.assertEquals((String)"1", (int)0, (int)reader1.getRelationNo(pd));
        AbstractBeanAnnotationReaderTest.assertEquals((String)"1", (String)"DEPTNUM:DEPTNO", (String)reader1.getRelationKey(pd));
        AbstractBeanAnnotationReaderTest.assertFalse((String)"1", (boolean)reader1.hasRelationNo(beanDesc.getPropertyDesc("prop2")));
    }

    public void testGetValueType() throws Exception {
        Class clazz = this.getBeanClass("AnnotationTestBean3");
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)clazz);
        BeanAnnotationReader annotationReader = this.createBeanAnnotationReader(clazz);
        PropertyDesc aaaPd = beanDesc.getPropertyDesc("aaa");
        AbstractBeanAnnotationReaderTest.assertEquals((String)null, (String)annotationReader.getValueType(aaaPd));
        PropertyDesc bbbPd = beanDesc.getPropertyDesc("bbb");
        AbstractBeanAnnotationReaderTest.assertEquals((String)"fooType", (String)annotationReader.getValueType(bbbPd));
    }
}

