/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.types.AbstractValueType;
import org.seasar.framework.util.BigDecimalConversionUtil;

public class BigDecimalType
extends AbstractValueType {
    public BigDecimalType() {
        super(3);
    }

    public Object getValue(ResultSet resultSet, int index) throws SQLException {
        return resultSet.getBigDecimal(index);
    }

    public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
        return resultSet.getBigDecimal(columnName);
    }

    public Object getValue(CallableStatement cs, int index) throws SQLException {
        return cs.getBigDecimal(index);
    }

    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        return cs.getBigDecimal(parameterName);
    }

    public void bindValue(PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            this.setNull(ps, index);
        } else {
            ps.setBigDecimal(index, BigDecimalConversionUtil.toBigDecimal((Object)value));
        }
    }

    public void bindValue(CallableStatement cs, String parameterName, Object value) throws SQLException {
        if (value == null) {
            this.setNull(cs, parameterName);
        } else {
            cs.setBigDecimal(parameterName, BigDecimalConversionUtil.toBigDecimal((Object)value));
        }
    }
}

