/*
 * Copyright 2004-2006 H2 Group. Licensed under the H2 License, Version 1.0 (http://h2database.com/html/license.html).
 * Initial Developer: H2 Group
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.table.Column;
import org.h2.util.ObjectArray;

public class ValueResultSet extends Value {

    private LocalResult result;
    
    public static ValueResultSet get(Session session, ResultSet rs, int maxrows) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        ObjectArray cols = new ObjectArray();
        int[] types = new int[columnCount];
        Database db = session == null ? null : session.getDatabase();
        for(int i=0; i<columnCount; i++) {
            String name = meta.getColumnLabel(i+1);
            int type = DataType.convertSQLTypeToValueType(meta.getColumnType(i+1));
            types[i] = type;
            int precision = meta.getPrecision(i+1);
            int scale = meta.getScale(i+1);
            Column col = new Column(name, type, precision, scale);
            Expression expr = new ExpressionColumn(db, null, col);
            cols.add(expr);
        }
        ValueResultSet val = new ValueResultSet();
        val.result = new LocalResult(session, cols, columnCount);
        for(int i=0; i<maxrows && rs.next(); i++) {
            Value[] list = new Value[columnCount];
            for(int j=0; j<columnCount; j++) {
                list[j] = DataType.readValue(session, rs, j+1, types[j]);
            }
            val.result.addRow(list);
        }
        val.result.done();
        return val;
    }
    
    public int getType() {
        return Value.RESULT_SET;
    }

    public long getPrecision() {
        return 0;
    }

    public int getDisplaySize() {
        // it doesn't make sense to calculate this
        return 100;
    }

    public String getString() throws SQLException {
        StringBuffer buff = new StringBuffer();
        buff.append("(");
        result.reset();
        int i=0;
        while(result.next()) {
            if(i>0) {
                buff.append(", ");
            }
            i++;
            Value[] list = result.currentRow();
            buff.append(ValueArray.get(list).getString());
        }
        buff.append(")");
        return buff.toString();
    }

    protected int compareSecure(Value v, CompareMode mode) throws SQLException {
        throw Message.getUnsupportedException();
    }

    protected boolean isEqual(Value v) {
        return false;
    }

    public Object getObject() throws SQLException {
        return result;
    }
    
    public LocalResult getResult() throws SQLException {
        return result;
    }

    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public String getSQL() {
        return "";
    }

}
