/*
 * Decompiled with CFR 0.152.
 */
package org.h2.web;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.h2.message.TraceSystem;
import org.h2.util.FileUtils;
import org.h2.web.ConnectionInfo;

public class AppServer {
    private static final String[] GENERIC = new String[]{"Generic Firebird Server|org.firebirdsql.jdbc.FBDriver|jdbc:firebirdsql:localhost:c:/temp/firebird/test|sysdba", "Generic OneDollarDB|in.co.daffodil.db.jdbc.DaffodilDBDriver|jdbc:daffodilDB_embedded:school;path=C:/temp;create=true|sa", "Generic DB2|COM.ibm.db2.jdbc.net.DB2Driver|jdbc:db2://<host>/<db>|", "Generic Oracle|oracle.jdbc.driver.OracleDriver|jdbc:oracle:thin:@<host>:1521:<instance>|scott", "Generic PostgreSQL|org.postgresql.Driver|jdbc:postgresql:<db>|", "Generic MS SQL Server|com.microsoft.jdbc.sqlserver.SQLServerDriver|jdbc:Microsoft:sqlserver://localhost:1433;DatabaseName=sqlexpress|sa", "Generic MySQL|com.mysql.jdbc.Driver|jdbc:mysql://<host>:<port>/<db>|", "Generic Derby (Embedded)|org.apache.derby.jdbc.EmbeddedDriver|jdbc:derby:test;create=true|sa", "Generic Derby (Server)|org.apache.derby.jdbc.ClientDriver|jdbc:derby://localhost:1527/test;create=true|sa", "Generic HSQLDB|org.hsqldb.jdbcDriver|jdbc:hsqldb:test;hsqldb.default_table_type=cached|sa", "Generic H2|org.h2.Driver|jdbc:h2:test|sa"};
    private URLClassLoader urlClassLoader;
    private String driverList;
    private static int ticker;
    private int port;
    private boolean allowOthers;
    private boolean ssl;
    private HashMap connectionInfos = new HashMap();

    AppServer(String[] args) {
        Properties prop = this.loadProperties();
        this.driverList = prop.getProperty("drivers");
        this.port = FileUtils.getIntProperty(prop, "webPort", 8082);
        this.ssl = FileUtils.getBooleanProperty(prop, "webSSL", false);
        this.allowOthers = FileUtils.getBooleanProperty(prop, "webAllowOthers", false);
        for (int i = 0; args != null && i < args.length; ++i) {
            if ("-webPort".equals(args[i])) {
                this.port = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-webSSL".equals(args[i])) {
                this.ssl = Boolean.valueOf(args[++i]);
                continue;
            }
            if (!"-webAllowOthers".equals(args[i])) continue;
            this.allowOthers = Boolean.valueOf(args[++i]);
        }
    }

    void setAllowOthers(boolean b) {
        this.allowOthers = b;
    }

    void setSSL(boolean b) {
        this.ssl = b;
    }

    void setPort(int port) {
        this.port = port;
    }

    boolean getAllowOthers() {
        return this.allowOthers;
    }

    boolean getSSL() {
        return this.ssl;
    }

    int getPort() {
        return this.port;
    }

    ConnectionInfo getSetting(String name) {
        return (ConnectionInfo)this.connectionInfos.get(name);
    }

    void updateSetting(ConnectionInfo info) {
        this.connectionInfos.put(info.name, info);
        info.lastAccess = ticker++;
    }

    void removeSetting(String name) {
        this.connectionInfos.remove(name);
    }

    private File getPropertiesFile() {
        return FileUtils.getFileInUserHome(".h2.server.properties");
    }

    Properties loadProperties() {
        File file = this.getPropertiesFile();
        try {
            return FileUtils.loadProperties(file);
        }
        catch (IOException e) {
            return new Properties();
        }
    }

    String[] getSettingNames() {
        ArrayList list = this.getSettings();
        String[] names = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            names[i] = ((ConnectionInfo)list.get((int)i)).name;
        }
        return names;
    }

    synchronized ArrayList getSettings() {
        ArrayList<ConnectionInfo> settings = new ArrayList<ConnectionInfo>();
        if (this.connectionInfos.size() == 0) {
            Properties prop = this.loadProperties();
            if (prop.size() == 0) {
                for (int i = 0; i < GENERIC.length; ++i) {
                    ConnectionInfo info = new ConnectionInfo(GENERIC[i]);
                    settings.add(info);
                    this.updateSetting(info);
                }
            } else {
                String data;
                int i = 0;
                while ((data = prop.getProperty(String.valueOf(i))) != null) {
                    ConnectionInfo info = new ConnectionInfo(data);
                    settings.add(info);
                    this.updateSetting(info);
                    ++i;
                }
            }
        } else {
            settings.addAll(this.connectionInfos.values());
        }
        this.sortConnectionInfo(settings);
        return settings;
    }

    void sortConnectionInfo(ArrayList list) {
        for (int i = 1; i < list.size(); ++i) {
            int j;
            ConnectionInfo t = (ConnectionInfo)list.get(i);
            for (j = i - 1; j >= 0 && ((ConnectionInfo)list.get((int)j)).lastAccess < t.lastAccess; --j) {
                list.set(j + 1, list.get(j));
            }
            list.set(j + 1, t);
        }
    }

    synchronized void saveSettings() {
        try {
            Properties prop = new Properties();
            if (this.driverList != null) {
                prop.setProperty("drivers", this.driverList);
            }
            prop.setProperty("webPort", String.valueOf(this.port));
            prop.setProperty("webAllowOthers", String.valueOf(this.allowOthers));
            prop.setProperty("webSSL", String.valueOf(this.ssl));
            ArrayList settings = this.getSettings();
            int len = settings.size();
            for (int i = 0; i < len; ++i) {
                ConnectionInfo info = (ConnectionInfo)settings.get(i);
                if (info == null) continue;
                prop.setProperty(String.valueOf(len - i - 1), info.getString());
            }
            FileOutputStream out = new FileOutputStream(this.getPropertiesFile());
            prop.store(out, "H2 Server Properties");
            out.close();
        }
        catch (IOException e) {
            TraceSystem.traceThrowable(e);
        }
    }

    Connection getConnection(String driver, String url, String user, String password) throws Exception {
        driver = driver.trim();
        url = url.trim();
        user = user.trim();
        password = password.trim();
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            if (this.urlClassLoader == null) {
                throw e;
            }
            Driver dr = (Driver)this.urlClassLoader.loadClass(driver).newInstance();
            Properties p = new Properties();
            p.setProperty("user", user);
            p.setProperty("password", password);
            return dr.connect(url, p);
        }
        return DriverManager.getConnection(url, user, password);
    }
}

