/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.SQLException;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.util.HashBase;
import org.h2.util.ObjectArray;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class ValueHashMap
extends HashBase {
    private Value[] keys;
    private Object[] values;
    private DataHandler database;

    public ValueHashMap(DataHandler database) {
        this.database = database;
    }

    protected void reset(int newLevel) {
        super.reset(newLevel);
        this.keys = new Value[this.len];
        this.values = new Object[this.len];
    }

    protected void rehash(int newLevel) throws SQLException {
        Value[] oldKeys = this.keys;
        Object[] oldValues = this.values;
        this.reset(newLevel);
        for (int i = 0; i < oldKeys.length; ++i) {
            Value k = oldKeys[i];
            if (k == null || k == ValueNull.DELETED) continue;
            this.put(k, oldValues[i]);
        }
    }

    private int getIndex(Value key) {
        return key.hashCode() & this.mask;
    }

    public void put(Value key, Object value) throws SQLException {
        this.checkSizePut();
        int index = this.getIndex(key);
        int plus = 1;
        int deleted = -1;
        do {
            Value k;
            if ((k = this.keys[index]) == null) {
                if (deleted >= 0) {
                    index = deleted;
                    --this.deletedCount;
                }
                ++this.size;
                this.keys[index] = key;
                this.values[index] = value;
                return;
            }
            if (k == ValueNull.DELETED) {
                if (deleted < 0) {
                    deleted = index;
                }
            } else if (this.database.compareTypeSave(k, key) == 0) {
                this.values[index] = value;
                return;
            }
            index = index + plus++ & this.mask;
        } while (plus <= this.len);
        throw Message.internal("hashmap is full");
    }

    public void remove(Value key) throws SQLException {
        this.checkSizeRemove();
        int index = this.getIndex(key);
        int plus = 1;
        do {
            Value k;
            if ((k = this.keys[index]) == null) {
                return;
            }
            if (k != ValueNull.DELETED && this.database.compareTypeSave(k, key) == 0) {
                this.keys[index] = ValueNull.DELETED;
                this.values[index] = null;
                ++this.deletedCount;
                --this.size;
                return;
            }
            index = index + plus++ & this.mask;
            k = this.keys[index];
        } while (plus <= this.len);
    }

    public Object get(Value key) throws SQLException {
        int index = this.getIndex(key);
        int plus = 1;
        do {
            Value k;
            if ((k = this.keys[index]) == null) {
                return null;
            }
            if (k != ValueNull.DELETED && this.database.compareTypeSave(k, key) == 0) {
                return this.values[index];
            }
            index = index + plus++ & this.mask;
        } while (plus <= this.len);
        return null;
    }

    public ObjectArray keys() {
        ObjectArray list = new ObjectArray(this.size);
        for (int i = 0; i < this.keys.length; ++i) {
            Value k = this.keys[i];
            if (k == null || k == ValueNull.DELETED) continue;
            list.add(k);
        }
        return list;
    }

    public ObjectArray values() {
        ObjectArray list = new ObjectArray(this.size);
        for (int i = 0; i < this.keys.length; ++i) {
            Value k = this.keys[i];
            if (k == null || k == ValueNull.DELETED) continue;
            list.add(this.values[i]);
        }
        return list;
    }
}

