/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.assembler;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ExternalContext;
import org.seasar.framework.container.ExternalContextComponentDefRegister;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.assembler.AbstractPropertyAssembler;
import org.seasar.framework.container.external.servlet.HttpServletExternalContext;
import org.seasar.framework.container.external.servlet.HttpServletExternalContextComponentDefRegister;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.mock.servlet.MockHttpServletRequest;
import org.seasar.framework.mock.servlet.MockHttpServletRequestImpl;
import org.seasar.framework.mock.servlet.MockHttpServletResponse;
import org.seasar.framework.mock.servlet.MockHttpServletResponseImpl;
import org.seasar.framework.mock.servlet.MockServletContext;
import org.seasar.framework.mock.servlet.MockServletContextImpl;

public class AbstPropertyAssemblerTest
extends TestCase {
    S2Container container;
    HttpServletExternalContext externalContext;
    MockServletContext servletContext;
    MockHttpServletRequest request;
    MockHttpServletResponse response;
    BeanDesc beanDesc;
    PropertyDesc nameDesc;
    PropertyDesc ageDesc;
    PropertyDesc modelsDesc;
    PropertyDesc magazinesDesc;
    ComponentDef cd;
    TestPage testPage;
    TestPropertyAssembler assembler;
    Set set;

    protected void setUp() throws Exception {
        super.setUp();
        this.container = new S2ContainerImpl();
        this.externalContext = new HttpServletExternalContext();
        this.container.setExternalContext((ExternalContext)this.externalContext);
        this.servletContext = new MockServletContextImpl("/seasar2");
        this.externalContext.setApplication((Object)this.servletContext);
        this.request = new MockHttpServletRequestImpl((ServletContext)this.servletContext, "/sersar2");
        this.externalContext.setRequest((Object)this.request);
        this.response = new MockHttpServletResponseImpl((HttpServletRequest)this.request);
        this.externalContext.setResponse((Object)this.response);
        this.container.setExternalContextComponentDefRegister((ExternalContextComponentDefRegister)new HttpServletExternalContextComponentDefRegister());
        this.container.register(TestPage.class, "testPage");
        this.container.init();
        this.beanDesc = BeanDescFactory.getBeanDesc((Class)TestPage.class);
        this.nameDesc = this.beanDesc.getPropertyDesc("name");
        this.ageDesc = this.beanDesc.getPropertyDesc("age");
        this.modelsDesc = this.beanDesc.getPropertyDesc("models");
        this.magazinesDesc = this.beanDesc.getPropertyDesc("magazines");
        this.cd = this.container.getComponentDef((Object)"testPage");
        this.testPage = (TestPage)this.cd.getComponent();
        this.assembler = new TestPropertyAssembler(this.cd);
        this.set = new HashSet();
    }

    public void testBindParameter() throws Exception {
        this.request.setParameter("name", "Hoge");
        this.request.setParameter("age", "30");
        this.request.setParameter("models", new String[]{"Yuri", "Nao", "Maki"});
        this.request.setParameter("magazines", new String[]{"CanCam", "JJ", "Ray"});
        this.assembler.bindExternally(this.beanDesc, this.cd, this.testPage, this.set);
        AbstPropertyAssemblerTest.assertEquals((int)4, (int)this.set.size());
        AbstPropertyAssemblerTest.assertEquals((String)"Hoge", (String)this.testPage.name);
        AbstPropertyAssemblerTest.assertEquals((int)30, (int)this.testPage.age);
        AbstPropertyAssemblerTest.assertEquals((int)3, (int)this.testPage.models.length);
        AbstPropertyAssemblerTest.assertEquals((String)"Yuri", (String)this.testPage.models[0]);
        AbstPropertyAssemblerTest.assertEquals((String)"Nao", (String)this.testPage.models[1]);
        AbstPropertyAssemblerTest.assertEquals((String)"Maki", (String)this.testPage.models[2]);
        AbstPropertyAssemblerTest.assertEquals((int)3, (int)this.testPage.magazines.size());
        AbstPropertyAssemblerTest.assertEquals((Object)"CanCam", this.testPage.magazines.get(0));
        AbstPropertyAssemblerTest.assertEquals((Object)"JJ", this.testPage.magazines.get(1));
        AbstPropertyAssemblerTest.assertEquals((Object)"Ray", this.testPage.magazines.get(2));
    }

    public void testBindHeader() throws Exception {
        this.request.addHeader("name", "Hoge");
        this.request.addHeader("age", "30");
        this.request.addHeader("models", "Yuri");
        this.request.addHeader("models", "Nao");
        this.request.addHeader("models", "Maki");
        this.request.addHeader("magazines", "CanCam");
        this.request.addHeader("magazines", "JJ");
        this.request.addHeader("magazines", "Ray");
        this.assembler.bindExternally(this.beanDesc, this.cd, this.testPage, this.set);
        AbstPropertyAssemblerTest.assertEquals((int)4, (int)this.set.size());
        AbstPropertyAssemblerTest.assertEquals((String)"Hoge", (String)this.testPage.name);
        AbstPropertyAssemblerTest.assertEquals((int)30, (int)this.testPage.age);
        AbstPropertyAssemblerTest.assertEquals((int)3, (int)this.testPage.models.length);
        AbstPropertyAssemblerTest.assertEquals((String)"Yuri", (String)this.testPage.models[0]);
        AbstPropertyAssemblerTest.assertEquals((String)"Nao", (String)this.testPage.models[1]);
        AbstPropertyAssemblerTest.assertEquals((String)"Maki", (String)this.testPage.models[2]);
        AbstPropertyAssemblerTest.assertEquals((int)3, (int)this.testPage.magazines.size());
        AbstPropertyAssemblerTest.assertEquals((Object)"CanCam", this.testPage.magazines.get(0));
        AbstPropertyAssemblerTest.assertEquals((Object)"JJ", this.testPage.magazines.get(1));
        AbstPropertyAssemblerTest.assertEquals((Object)"Ray", this.testPage.magazines.get(2));
    }

    public void testPriority() throws Exception {
        this.request.setParameter("name", "Foo");
        this.request.addHeader("name", "Bar");
        this.request.setParameter("age", "20");
        this.request.addHeader("age", "30");
        this.assembler.bindExternally(this.beanDesc, this.cd, this.testPage, this.set);
        AbstPropertyAssemblerTest.assertEquals((int)2, (int)this.set.size());
        AbstPropertyAssemblerTest.assertEquals((String)"Foo", (String)this.testPage.name);
        AbstPropertyAssemblerTest.assertEquals((int)20, (int)this.testPage.age);
    }

    public void testExcept() throws Exception {
        this.request.setParameter("name", "null");
        this.assembler.bindExternally(this.beanDesc, this.cd, this.testPage, this.set);
        AbstPropertyAssemblerTest.assertEquals((int)1, (int)this.set.size());
        AbstPropertyAssemblerTest.assertEquals((String)"", (String)this.testPage.name);
    }

    public void testTypeMismatch() throws Exception {
        this.request.setParameter("contract", "hoge");
        this.assembler.bindExternally(this.beanDesc, this.cd, this.testPage, this.set);
        AbstPropertyAssemblerTest.assertEquals((int)0, (int)this.set.size());
        AbstPropertyAssemblerTest.assertEquals(null, (Object)this.testPage.contract);
    }

    public void testNotBind() throws Exception {
        this.assembler.bindExternally(this.beanDesc, this.cd, this.testPage, this.set);
        AbstPropertyAssemblerTest.assertTrue((boolean)this.set.isEmpty());
        AbstPropertyAssemblerTest.assertNull((Object)this.testPage.name);
        AbstPropertyAssemblerTest.assertEquals((int)0, (int)this.testPage.age);
        AbstPropertyAssemblerTest.assertNull((Object)this.testPage.models);
        AbstPropertyAssemblerTest.assertNull((Object)this.testPage.magazines);
    }

    public static class TestPage {
        String name;
        int age;
        String[] models;
        List magazines;
        Map contract;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public String[] getModels() {
            return this.models;
        }

        public void setModels(String[] models) {
            this.models = models;
        }

        public List getMagazines() {
            return this.magazines;
        }

        public void setMagazines(List magazines) {
            this.magazines = magazines;
        }

        public Map getContract() {
            return this.contract;
        }

        public void setContract(Map contract) {
            this.contract = contract;
        }
    }

    public static class TestPropertyAssembler
    extends AbstractPropertyAssembler {
        public TestPropertyAssembler(ComponentDef componentDef) {
            super(componentDef);
        }

        public void assemble(Object component) {
        }

        public void bindExternally(BeanDesc beanDesc, ComponentDef componentDef, Object component, Set names) {
            super.bindExternally(beanDesc, componentDef, component, names);
        }
    }
}

