/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.deployer;

import junit.framework.TestCase;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentDeployer;
import org.seasar.framework.container.deployer.ApplicationComponentDeployer;
import org.seasar.framework.container.deployer.ComponentDeployerFactory;
import org.seasar.framework.container.deployer.ExternalComponentDeployerProvider;
import org.seasar.framework.container.deployer.InstanceDefFactory;
import org.seasar.framework.container.deployer.OuterComponentDeployer;
import org.seasar.framework.container.deployer.PrototypeComponentDeployer;
import org.seasar.framework.container.deployer.RequestComponentDeployer;
import org.seasar.framework.container.deployer.SessionComponentDeployer;
import org.seasar.framework.container.deployer.SingletonComponentDeployer;
import org.seasar.framework.container.impl.ComponentDefImpl;

public class ComponentDeployerFactoryTest
extends TestCase {
    public void setUp() throws Exception {
        ComponentDeployerFactory.setProvider((ComponentDeployerFactory.Provider)new ExternalComponentDeployerProvider());
    }

    public void tearDown() throws Exception {
        ComponentDeployerFactory.setProvider((ComponentDeployerFactory.Provider)new ComponentDeployerFactory.DefaultProvider());
    }

    public void testSingleton() throws Exception {
        ComponentDefImpl cd = new ComponentDefImpl();
        cd.setInstanceDef(InstanceDefFactory.SINGLETON);
        ComponentDeployer deployer = ComponentDeployerFactory.createSingletonComponentDeployer((ComponentDef)cd);
        ComponentDeployerFactoryTest.assertTrue((String)"1", (boolean)(deployer instanceof SingletonComponentDeployer));
    }

    public void testPrototype() throws Exception {
        ComponentDefImpl cd = new ComponentDefImpl();
        cd.setInstanceDef(InstanceDefFactory.PROTOTYPE);
        ComponentDeployer deployer = ComponentDeployerFactory.createPrototypeComponentDeployer((ComponentDef)cd);
        ComponentDeployerFactoryTest.assertTrue((String)"1", (boolean)(deployer instanceof PrototypeComponentDeployer));
    }

    public void testRequest() throws Exception {
        ComponentDefImpl cd = new ComponentDefImpl();
        cd.setInstanceDef(InstanceDefFactory.REQUEST);
        ComponentDeployer deployer = ComponentDeployerFactory.createRequestComponentDeployer((ComponentDef)cd);
        ComponentDeployerFactoryTest.assertTrue((String)"1", (boolean)(deployer instanceof RequestComponentDeployer));
    }

    public void testApplication() throws Exception {
        ComponentDefImpl cd = new ComponentDefImpl();
        cd.setInstanceDef(InstanceDefFactory.APPLICATION);
        ComponentDeployer deployer = ComponentDeployerFactory.createServletContextComponentDeployer((ComponentDef)cd);
        ComponentDeployerFactoryTest.assertTrue((String)"1", (boolean)(deployer instanceof ApplicationComponentDeployer));
    }

    public void testSession() throws Exception {
        ComponentDefImpl cd = new ComponentDefImpl();
        cd.setInstanceDef(InstanceDefFactory.SESSION);
        ComponentDeployer deployer = ComponentDeployerFactory.createSessionComponentDeployer((ComponentDef)cd);
        ComponentDeployerFactoryTest.assertTrue((String)"1", (boolean)(deployer instanceof SessionComponentDeployer));
    }

    public void testOuter() throws Exception {
        ComponentDefImpl cd = new ComponentDefImpl();
        cd.setInstanceDef(InstanceDefFactory.OUTER);
        ComponentDeployer deployer = ComponentDeployerFactory.createOuterComponentDeployer((ComponentDef)cd);
        ComponentDeployerFactoryTest.assertTrue((String)"1", (boolean)(deployer instanceof OuterComponentDeployer));
    }
}

