/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.interceptors;

import java.util.Date;
import junit.framework.TestCase;
import org.aopalliance.intercept.MethodInterceptor;
import org.seasar.framework.aop.Aspect;
import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.aop.impl.AspectImpl;
import org.seasar.framework.aop.impl.PointcutImpl;
import org.seasar.framework.aop.interceptors.ToStringInterceptor;
import org.seasar.framework.aop.proxy.AopProxy;

public class ToStringInterceptorTest
extends TestCase {
    ToStringInterceptor interceptor;

    protected void setUp() throws Exception {
        super.setUp();
        this.interceptor = new ToStringInterceptor();
    }

    public void testIntercept() throws Exception {
        this.interceptor.setDateFormat("yy/MM/dd H:mm");
        FooEntity proxy = (FooEntity)this.applyInterceptor(FooEntity.class);
        String identityHashCode = Integer.toHexString(System.identityHashCode(proxy));
        System.out.println(proxy.toString());
        ToStringInterceptorTest.assertEquals((String)("org.seasar.framework.aop.interceptors.ToStringInterceptorTest$FooEntity@" + identityHashCode + "[intVal=12,longVal=123,charVal='a',doubleVal=1234.5" + ",dateVal=70/01/01 9:00,nullVal=null,longArray={1,2,3},intArray={1,2,3},shortArray={1,2,3}" + ",byteArray={1,2,3},charArray={'1','2','3'},doubleArray={1.0,2.0,3.0},floatArray={1.0,2.0,3.0}" + ",booleanArray={true,false,true},booleanClassArray={true,false,false}," + "stringArray={\"1\",\"2\",\"3\"}]"), (String)proxy.toString());
    }

    public void testInterceptExtendsField() throws Exception {
        this.interceptor.setDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        BarEntity proxy = (BarEntity)this.applyInterceptor(BarEntity.class);
        String identityHashCode = Integer.toHexString(System.identityHashCode(proxy));
        System.out.println(proxy.toString());
        ToStringInterceptorTest.assertEquals((String)("org.seasar.framework.aop.interceptors.ToStringInterceptorTest$BarEntity@" + identityHashCode + "[exIntVal=123456,exLongVal=1234567,exDoubleVal=1234567.8" + ",exDateVal=1970/01/01 09:00:00.001" + ",intVal=12,longVal=123,charVal='a',doubleVal=1234.5" + ",dateVal=1970/01/01 09:00:00.000,nullVal=null,longArray={1,2,3},intArray={1,2,3},shortArray={1,2,3}" + ",byteArray={1,2,3},charArray={'1','2','3'},doubleArray={1.0,2.0,3.0},floatArray={1.0,2.0,3.0}" + ",booleanArray={true,false,true},booleanClassArray={true,false,false}," + "stringArray={\"1\",\"2\",\"3\"}]"), (String)proxy.toString());
    }

    public void testIncludeConstant() throws Exception {
        this.interceptor.setIncludeConstant(true);
        this.interceptor.setDateFormat("yy/MM/dd H:mm");
        FooEntity proxy = (FooEntity)this.applyInterceptor(FooEntity.class);
        String identityHashCode = Integer.toHexString(System.identityHashCode(proxy));
        System.out.println(proxy.toString());
        ToStringInterceptorTest.assertEquals((String)("org.seasar.framework.aop.interceptors.ToStringInterceptorTest$FooEntity@" + identityHashCode + "[CONSTANT=\"Hoge\",intVal=12,longVal=123,charVal='a',doubleVal=1234.5" + ",dateVal=70/01/01 9:00,nullVal=null,longArray={1,2,3},intArray={1,2,3},shortArray={1,2,3}" + ",byteArray={1,2,3},charArray={'1','2','3'},doubleArray={1.0,2.0,3.0},floatArray={1.0,2.0,3.0}" + ",booleanArray={true,false,true},booleanClassArray={true,false,false}," + "stringArray={\"1\",\"2\",\"3\"}]"), (String)proxy.toString());
    }

    public void testIncludeStatic() throws Exception {
        this.interceptor.setIncludeStatic(true);
        this.interceptor.setDateFormat("yy/MM/dd H:mm");
        FooEntity proxy = (FooEntity)this.applyInterceptor(FooEntity.class);
        String identityHashCode = Integer.toHexString(System.identityHashCode(proxy));
        System.out.println(proxy.toString());
        ToStringInterceptorTest.assertEquals((String)("org.seasar.framework.aop.interceptors.ToStringInterceptorTest$FooEntity@" + identityHashCode + "[staticInt=1,intVal=12,longVal=123,charVal='a',doubleVal=1234.5" + ",dateVal=70/01/01 9:00,nullVal=null,longArray={1,2,3},intArray={1,2,3},shortArray={1,2,3}" + ",byteArray={1,2,3},charArray={'1','2','3'},doubleArray={1.0,2.0,3.0},floatArray={1.0,2.0,3.0}" + ",booleanArray={true,false,true},booleanClassArray={true,false,false}," + "stringArray={\"1\",\"2\",\"3\"}]"), (String)proxy.toString());
    }

    public void testIncludeConstantAndStatic() throws Exception {
        this.interceptor.setIncludeConstant(true);
        this.interceptor.setIncludeStatic(true);
        this.interceptor.setDateFormat("yy/MM/dd H:mm");
        FooEntity proxy = (FooEntity)this.applyInterceptor(FooEntity.class);
        String identityHashCode = Integer.toHexString(System.identityHashCode(proxy));
        System.out.println(proxy.toString());
        ToStringInterceptorTest.assertEquals((String)("org.seasar.framework.aop.interceptors.ToStringInterceptorTest$FooEntity@" + identityHashCode + "[CONSTANT=\"Hoge\",staticInt=1,intVal=12,longVal=123,charVal='a',doubleVal=1234.5" + ",dateVal=70/01/01 9:00,nullVal=null,longArray={1,2,3},intArray={1,2,3},shortArray={1,2,3}" + ",byteArray={1,2,3},charArray={'1','2','3'},doubleArray={1.0,2.0,3.0},floatArray={1.0,2.0,3.0}" + ",booleanArray={true,false,true},booleanClassArray={true,false,false}," + "stringArray={\"1\",\"2\",\"3\"}]"), (String)proxy.toString());
    }

    private Object applyInterceptor(Class clazz) {
        PointcutImpl pointcut = new PointcutImpl(new String[]{"toString"});
        AspectImpl aspect = new AspectImpl((MethodInterceptor)this.interceptor, (Pointcut)pointcut);
        AopProxy aopProxy = new AopProxy(clazz, new Aspect[]{aspect});
        return aopProxy.create();
    }

    static class BarEntity
    extends FooEntity {
        int exIntVal = 123456;
        protected long exLongVal = 1234567L;
        double exDoubleVal = 1234567.8;
        public Date exDateVal = new Date(1L);

        BarEntity() {
        }
    }

    static class FooEntity {
        static final String CONSTANT = "Hoge";
        static int staticInt = 1;
        int intVal = 12;
        protected long longVal = 123L;
        char charVal = (char)97;
        double doubleVal = 1234.5;
        public Date dateVal = new Date(0L);
        public Date nullVal = null;
        public long[] longArray = new long[]{1L, 2L, 3L};
        public int[] intArray = new int[]{1, 2, 3};
        public short[] shortArray = new short[]{1, 2, 3};
        public byte[] byteArray = new byte[]{1, 2, 3};
        public char[] charArray = new char[]{'1', '2', '3'};
        public double[] doubleArray = new double[]{1.0, 2.0, 3.0};
        public float[] floatArray = new float[]{1.0f, 2.0f, 3.0f};
        public boolean[] booleanArray = new boolean[]{true, false, true};
        public Boolean[] booleanClassArray = new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.FALSE};
        public String[] stringArray = new String[]{"1", "2", "3"};

        FooEntity() {
        }
    }
}

