/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.generator;

import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Locale;
import org.seasar.extension.jdbc.gen.generator.GenerationContext;
import org.seasar.extension.jdbc.gen.generator.Generator;
import org.seasar.extension.jdbc.gen.internal.exception.TemplateRuntimeException;
import org.seasar.extension.jdbc.gen.internal.generator.IncludeDirective;
import org.seasar.extension.jdbc.gen.internal.generator.OnDemandDateModel;
import org.seasar.extension.jdbc.gen.internal.generator.ResourceTemplateLoader;
import org.seasar.extension.jdbc.gen.internal.util.CloseableUtil;
import org.seasar.extension.jdbc.gen.internal.util.DeleteEmptyFileWriter;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.FileOutputStreamUtil;

public class GeneratorImpl
implements Generator {
    protected static Logger logger = Logger.getLogger(GeneratorImpl.class);
    protected static String DEFAULT_TEMPLATE_DIR_NAME = "org/seasar/extension/jdbc/gen/internal/generator/tempaltes";
    protected Configuration configuration;

    public GeneratorImpl(Configuration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration");
        }
        this.configuration = configuration;
    }

    public GeneratorImpl(String templateFileEncoding, File templateFilePrimaryDir) {
        if (templateFileEncoding == null) {
            throw new NullPointerException("templateFileEncoding");
        }
        this.configuration = new Configuration();
        this.configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        this.configuration.setSharedVariable("include", (TemplateModel)new IncludeDirective());
        this.configuration.setSharedVariable("currentDate", (TemplateModel)new OnDemandDateModel());
        this.configuration.setEncoding(Locale.getDefault(), templateFileEncoding);
        this.configuration.setNumberFormat("0.#####");
        this.configuration.setTemplateLoader(this.createTemplateLoader(templateFilePrimaryDir));
    }

    protected TemplateLoader createTemplateLoader(File templateFilePrimaryDir) {
        FileTemplateLoader primary = null;
        if (templateFilePrimaryDir != null) {
            try {
                primary = new FileTemplateLoader(templateFilePrimaryDir);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
        ResourceTemplateLoader secondary = new ResourceTemplateLoader(DEFAULT_TEMPLATE_DIR_NAME);
        if (primary == null) {
            return secondary;
        }
        return new MultiTemplateLoader(new TemplateLoader[]{primary, secondary});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(GenerationContext context) {
        boolean exists = this.exists(context.getFile());
        if (!context.isOverwrite() && exists) {
            return;
        }
        File dir = context.getFile().getParentFile();
        if (dir != null) {
            this.mkdirs(dir);
        }
        Writer writer = this.openWriter(context);
        try {
            Template template = this.getTemplate(context.getTemplateName());
            this.process(template, context.getModel(), writer);
        }
        finally {
            CloseableUtil.close(writer);
        }
        if (writer instanceof DeleteEmptyFileWriter && ((DeleteEmptyFileWriter)writer).isDeleted()) {
            return;
        }
        if (exists) {
            logger.log("DS2JDBCGen0009", new Object[]{context.getFile().getPath()});
        } else {
            logger.log("DS2JDBCGen0002", new Object[]{context.getFile().getPath()});
        }
    }

    protected boolean exists(File file) {
        return file.exists();
    }

    protected void mkdirs(File dir) {
        dir.mkdirs();
    }

    protected Writer openWriter(GenerationContext context) {
        Charset charset = Charset.forName(context.getEncoding());
        FileOutputStream fos = FileOutputStreamUtil.create((File)context.getFile());
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, charset);
        BufferedWriter bw = new BufferedWriter(osw);
        return new DeleteEmptyFileWriter(bw, context.getFile());
    }

    protected Template getTemplate(String name) {
        try {
            return this.configuration.getTemplate(name);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    protected void process(Template template, Object dataModel, Writer writer) {
        try {
            template.process(dataModel, writer);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        catch (TemplateException e) {
            throw new TemplateRuntimeException(e);
        }
    }
}

