/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import junit.framework.TestCase;
import org.seasar.framework.util.StringUtil;

public class StringUtilTest
extends TestCase {
    public void testReplace() throws Exception {
        StringUtilTest.assertEquals((String)"1", (String)"1bc45", (String)StringUtil.replace((String)"12345", (String)"23", (String)"bc"));
        StringUtilTest.assertEquals((String)"2", (String)"1234ef", (String)StringUtil.replace((String)"12345", (String)"5", (String)"ef"));
        StringUtilTest.assertEquals((String)"3", (String)"ab2345", (String)StringUtil.replace((String)"12345", (String)"1", (String)"ab"));
        StringUtilTest.assertEquals((String)"4", (String)"a234a", (String)StringUtil.replace((String)"12341", (String)"1", (String)"a"));
        StringUtilTest.assertEquals((String)"5", (String)"ab234abab234ab", (String)StringUtil.replace((String)"1234112341", (String)"1", (String)"ab"));
        StringUtilTest.assertEquals((String)"6", (String)"a\\nb", (String)StringUtil.replace((String)"a\nb", (String)"\n", (String)"\\n"));
    }

    public void testSplit() throws Exception {
        String[] array = StringUtil.split((String)"aaa\nbbb", (String)"\n");
        StringUtilTest.assertEquals((String)"1", (int)2, (int)array.length);
        StringUtilTest.assertEquals((String)"2", (String)"aaa", (String)array[0]);
        StringUtilTest.assertEquals((String)"3", (String)"bbb", (String)array[1]);
    }

    public void testSplit2() {
        String[] array = StringUtil.split((String)"aaa, bbb", (String)", ");
        StringUtilTest.assertEquals((String)"1", (int)2, (int)array.length);
        StringUtilTest.assertEquals((String)"2", (String)"aaa", (String)array[0]);
        StringUtilTest.assertEquals((String)"3", (String)"bbb", (String)array[1]);
    }

    public void testLtrim() throws Exception {
        StringUtilTest.assertEquals((String)"1", (String)"trim", (String)StringUtil.ltrim((String)"zzzytrim", (String)"xyz"));
        StringUtilTest.assertEquals((String)"2", (String)"", (String)StringUtil.ltrim((String)"xyz", (String)"xyz"));
    }

    public void testRtrim() throws Exception {
        StringUtilTest.assertEquals((String)"trim", (String)StringUtil.rtrim((String)"trimxxxx", (String)"x"));
        StringUtilTest.assertEquals((String)"", (String)StringUtil.rtrim((String)"xyz", (String)"xyz"));
        StringUtilTest.assertEquals((String)"trimxxxx", (String)StringUtil.rtrim((String)"trimxxxx", (String)"y"));
    }

    public void testTrimSuffix() throws Exception {
        StringUtilTest.assertEquals((String)"aaa", (String)StringUtil.trimSuffix((String)"aaaLogic", (String)"Logic"));
    }

    public void testTrimPrefix() throws Exception {
        StringUtilTest.assertEquals((String)"AAA", (String)StringUtil.trimPrefix((String)"T_AAA", (String)"T_"));
    }

    public void testIsBlank() throws Exception {
        StringUtilTest.assertEquals((String)"1", (boolean)true, (boolean)StringUtil.isBlank((String)" "));
        StringUtilTest.assertEquals((String)"2", (boolean)true, (boolean)StringUtil.isBlank((String)""));
        StringUtilTest.assertEquals((String)"3", (boolean)false, (boolean)StringUtil.isBlank((String)"a"));
        StringUtilTest.assertEquals((String)"4", (boolean)false, (boolean)StringUtil.isBlank((String)" a "));
    }

    public void testIsNotBlank() throws Exception {
        StringUtilTest.assertEquals((String)"1", (boolean)false, (boolean)StringUtil.isNotBlank((String)" "));
        StringUtilTest.assertEquals((String)"2", (boolean)false, (boolean)StringUtil.isNotBlank((String)""));
        StringUtilTest.assertEquals((String)"3", (boolean)true, (boolean)StringUtil.isNotBlank((String)"a"));
        StringUtilTest.assertEquals((String)"4", (boolean)true, (boolean)StringUtil.isNotBlank((String)" a "));
    }

    public void testContains() throws Exception {
        StringUtilTest.assertEquals((String)"1", (boolean)true, (boolean)StringUtil.contains((String)"a", (char)'a'));
        StringUtilTest.assertEquals((String)"2", (boolean)true, (boolean)StringUtil.contains((String)"abc", (char)'b'));
        StringUtilTest.assertEquals((String)"3", (boolean)false, (boolean)StringUtil.contains((String)"abc", (char)'d'));
    }

    public void testContains2() throws Exception {
        StringUtilTest.assertEquals((String)"1", (boolean)true, (boolean)StringUtil.contains((String)"a", (String)"a"));
        StringUtilTest.assertEquals((String)"2", (boolean)true, (boolean)StringUtil.contains((String)"abc", (String)"b"));
        StringUtilTest.assertEquals((String)"3", (boolean)false, (boolean)StringUtil.contains((String)"abc", (String)"d"));
    }

    public void testEquals() throws Exception {
        StringUtilTest.assertEquals((String)"1", (boolean)true, (boolean)StringUtil.equals((String)"a", (String)"a"));
        StringUtilTest.assertEquals((String)"2", (boolean)true, (boolean)StringUtil.equals(null, null));
        StringUtilTest.assertEquals((String)"3", (boolean)false, (boolean)StringUtil.equals((String)"a", null));
        StringUtilTest.assertEquals((String)"4", (boolean)false, (boolean)StringUtil.equals(null, (String)"a"));
        StringUtilTest.assertEquals((String)"5", (boolean)false, (boolean)StringUtil.equals((String)"a", (String)"b"));
    }

    public void testEqualsIgnoreCase() throws Exception {
        StringUtilTest.assertEquals((String)"1", (boolean)true, (boolean)StringUtil.equalsIgnoreCase((String)"a", (String)"a"));
        StringUtilTest.assertEquals((String)"2", (boolean)true, (boolean)StringUtil.equalsIgnoreCase((String)"a", (String)"A"));
        StringUtilTest.assertEquals((String)"3", (boolean)true, (boolean)StringUtil.equalsIgnoreCase((String)"A", (String)"a"));
        StringUtilTest.assertEquals((String)"4", (boolean)true, (boolean)StringUtil.equalsIgnoreCase(null, null));
        StringUtilTest.assertEquals((String)"5", (boolean)false, (boolean)StringUtil.equalsIgnoreCase((String)"a", null));
        StringUtilTest.assertEquals((String)"6", (boolean)false, (boolean)StringUtil.equalsIgnoreCase(null, (String)"a"));
        StringUtilTest.assertEquals((String)"7", (boolean)false, (boolean)StringUtil.equalsIgnoreCase((String)"a", (String)"b"));
    }

    public void testDecapitalize() throws Exception {
        StringUtilTest.assertEquals((String)"abc", (String)StringUtil.decapitalize((String)"abc"));
        StringUtilTest.assertEquals((String)"abc", (String)StringUtil.decapitalize((String)"Abc"));
        StringUtilTest.assertEquals((String)"ABC", (String)StringUtil.decapitalize((String)"ABC"));
    }

    public void testEndsWithIgnoreCase() throws Exception {
        StringUtilTest.assertTrue((boolean)StringUtil.endsWithIgnoreCase((String)"setHogeAaa", (String)"Aaa"));
        StringUtilTest.assertTrue((boolean)StringUtil.endsWithIgnoreCase((String)"setHogeAaa", (String)"aaa"));
        StringUtilTest.assertTrue((boolean)StringUtil.endsWithIgnoreCase((String)"aaa_hoge", (String)"HOge"));
        StringUtilTest.assertFalse((boolean)StringUtil.endsWithIgnoreCase((String)"setHogeaa", (String)"Aaa"));
        StringUtilTest.assertFalse((boolean)StringUtil.endsWithIgnoreCase((String)"aa", (String)"Aaa"));
    }

    public void testStartsWithIgnoreCase() throws Exception {
        StringUtilTest.assertTrue((boolean)StringUtil.startsWithIgnoreCase((String)"isHoge", (String)"is"));
        StringUtilTest.assertTrue((boolean)StringUtil.startsWithIgnoreCase((String)"isHoge", (String)"IS"));
        StringUtilTest.assertTrue((boolean)StringUtil.startsWithIgnoreCase((String)"ISHoge", (String)"is"));
        StringUtilTest.assertFalse((boolean)StringUtil.startsWithIgnoreCase((String)"isHoge", (String)"iss"));
        StringUtilTest.assertFalse((boolean)StringUtil.startsWithIgnoreCase((String)"is", (String)"iss"));
    }

    public void testSubstringFromLast() throws Exception {
        StringUtilTest.assertEquals((String)"ab", (String)StringUtil.substringFromLast((String)"abc", (String)"c"));
        StringUtilTest.assertEquals((String)"abcab", (String)StringUtil.substringFromLast((String)"abcabc", (String)"c"));
        StringUtilTest.assertEquals((String)"abc", (String)StringUtil.substringFromLast((String)"abc", (String)""));
        StringUtilTest.assertEquals((String)"abc", (String)StringUtil.substringFromLast((String)"abc", null));
        StringUtilTest.assertEquals((String)"abc", (String)StringUtil.substringFromLast((String)"abc", (String)"dddd"));
    }

    public void testSubstringToLast() throws Exception {
        StringUtilTest.assertEquals((String)"", (String)StringUtil.substringToLast((String)"abc", (String)"c"));
        StringUtilTest.assertEquals((String)"c", (String)StringUtil.substringToLast((String)"abc", (String)"b"));
        StringUtilTest.assertEquals((String)"c", (String)StringUtil.substringToLast((String)"abcbc", (String)"b"));
        StringUtilTest.assertEquals((String)"abc", (String)StringUtil.substringToLast((String)"abc", (String)""));
        StringUtilTest.assertEquals((String)"abc", (String)StringUtil.substringToLast((String)"abc", null));
        StringUtilTest.assertEquals((String)"abc", (String)StringUtil.substringToLast((String)"abc", (String)"dddd"));
    }

    public void testToHex() throws Exception {
        StringUtilTest.assertEquals((String)"010203", (String)StringUtil.toHex((byte[])new byte[]{1, 2, 3}));
    }

    public void testToHex2() throws Exception {
        StringUtilTest.assertEquals((String)"0001", (String)StringUtil.toHex((int)1));
    }

    public void testAppendHex() throws Exception {
        StringBuffer buf = new StringBuffer();
        StringUtil.appendHex((StringBuffer)buf, (byte)1);
        StringUtilTest.assertEquals((String)"01", (String)buf.toString());
    }

    public void testCamelize() throws Exception {
        StringUtilTest.assertNull((Object)StringUtil.camelize(null));
        StringUtilTest.assertEquals((String)"Emp", (String)StringUtil.camelize((String)"EMP"));
        StringUtilTest.assertEquals((String)"AaaBbb", (String)StringUtil.camelize((String)"AAA_BBB"));
    }

    public void testDecamelize() throws Exception {
        StringUtilTest.assertNull((Object)StringUtil.decamelize(null));
        StringUtilTest.assertEquals((String)"EMP", (String)StringUtil.decamelize((String)"Emp"));
        StringUtilTest.assertEquals((String)"AAA_BBB", (String)StringUtil.decamelize((String)"aaaBbb"));
        StringUtilTest.assertEquals((String)"AAA_BBB", (String)StringUtil.decamelize((String)"AaaBbb"));
        StringUtilTest.assertEquals((String)"AAA_BBB_C", (String)StringUtil.decamelize((String)"aaaBbbC"));
    }

    public void testIsNumver() throws Exception {
        StringUtilTest.assertFalse((boolean)StringUtil.isNumber(null));
        StringUtilTest.assertTrue((boolean)StringUtil.isNumber((String)"0123456789"));
        StringUtilTest.assertFalse((boolean)StringUtil.isNumber((String)"aaaBBBccc"));
        StringUtilTest.assertFalse((boolean)StringUtil.isNumber((String)"\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19"));
        StringUtilTest.assertFalse((boolean)StringUtil.isNumber((String)""));
        StringUtilTest.assertFalse((boolean)StringUtil.isNumber((String)"01234abcdef"));
        StringUtilTest.assertFalse((boolean)StringUtil.isNumber((String)"abcdef01234"));
    }

    public void testIsEmpty() {
        StringUtilTest.assertTrue((boolean)StringUtil.isEmpty(null));
        StringUtilTest.assertTrue((boolean)StringUtil.isEmpty((String)""));
        StringUtilTest.assertFalse((boolean)StringUtil.isEmpty((String)" "));
    }

    public void testIsNotEmpty() {
        StringUtilTest.assertFalse((boolean)StringUtil.isNotEmpty(null));
        StringUtilTest.assertFalse((boolean)StringUtil.isNotEmpty((String)""));
        StringUtilTest.assertTrue((boolean)StringUtil.isNotEmpty((String)" "));
    }
}

