/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.seasar.framework.util.ArrayIterator;
import org.seasar.framework.util.ExceptionAssert;

public class ArrayIteratorTest
extends TestCase {
    public void testNext() {
        ArrayIterator itr = new ArrayIterator(new Object[]{"a", "b", "c"});
        ArrayIteratorTest.assertEquals((Object)"a", (Object)itr.next());
        ArrayIteratorTest.assertEquals((Object)"b", (Object)itr.next());
        ArrayIteratorTest.assertEquals((Object)"c", (Object)itr.next());
        try {
            itr.next();
            ArrayIteratorTest.fail();
        }
        catch (NoSuchElementException expected) {
            ExceptionAssert.assertMessageExist(expected);
        }
    }

    public void testHasNext() {
        ArrayIterator itr = new ArrayIterator(new Object[]{"A", "B"});
        ArrayIteratorTest.assertEquals((boolean)true, (boolean)itr.hasNext());
        itr.next();
        ArrayIteratorTest.assertEquals((boolean)true, (boolean)itr.hasNext());
        itr.next();
        ArrayIteratorTest.assertEquals((boolean)false, (boolean)itr.hasNext());
    }

    public void testRemove() throws Exception {
        ArrayIterator itr = new ArrayIterator((Object[])new String[]{"1", "2"});
        try {
            itr.remove();
            ArrayIteratorTest.fail();
        }
        catch (UnsupportedOperationException expected) {
            ExceptionAssert.assertMessageExist(expected);
        }
    }
}

