/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.util;

import java.lang.reflect.Field;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.cooldeploy.S2ContainerFactoryCoolProvider;
import org.seasar.framework.container.factory.S2ContainerFactory;
import org.seasar.framework.container.hotdeploy.HotdeployBehavior;
import org.seasar.framework.container.impl.S2ContainerBehavior;
import org.seasar.framework.container.util.SmartDeployUtil;
import org.seasar.framework.container.warmdeploy.WarmdeployBehavior;
import org.seasar.framework.unit.S2FrameworkTestCase;
import org.seasar.framework.util.FieldUtil;

public class SmartDeployUtilTest
extends S2FrameworkTestCase {
    public SmartDeployUtilTest() {
        this.setWarmDeploy(false);
    }

    public void testHotdeployMode() throws Exception {
        S2Container container = this.getContainer();
        SmartDeployUtilTest.assertFalse((boolean)SmartDeployUtil.isHotdeployMode((S2Container)container));
        S2ContainerBehavior.setProvider((S2ContainerBehavior.Provider)new HotdeployBehavior());
        SmartDeployUtilTest.assertTrue((boolean)SmartDeployUtil.isHotdeployMode((S2Container)container));
    }

    public void tearDownHotdeployMode() {
        S2ContainerBehavior.setProvider((S2ContainerBehavior.Provider)new S2ContainerBehavior.DefaultProvider());
    }

    public void testCooldeployMode() throws Exception {
        S2Container container = this.getContainer();
        SmartDeployUtilTest.assertFalse((boolean)SmartDeployUtil.isCooldeployMode((S2Container)container));
        BeanDesc bd = BeanDescFactory.getBeanDesc((Class)S2ContainerFactory.class);
        FieldUtil.set((Field)bd.getField("provider"), null, (Object)new S2ContainerFactoryCoolProvider());
        SmartDeployUtilTest.assertTrue((boolean)SmartDeployUtil.isCooldeployMode((S2Container)container));
    }

    public void tearDownCooldeployMode() {
        BeanDesc bd = BeanDescFactory.getBeanDesc((Class)S2ContainerFactory.class);
        FieldUtil.set((Field)bd.getField("provider"), null, (Object)new S2ContainerFactory.DefaultProvider());
    }

    public void testWarmdeployMode() throws Exception {
        S2Container container = this.getContainer();
        SmartDeployUtilTest.assertFalse((boolean)SmartDeployUtil.isWarmdeployMode((S2Container)container));
        S2ContainerBehavior.setProvider((S2ContainerBehavior.Provider)new WarmdeployBehavior());
        SmartDeployUtilTest.assertTrue((boolean)SmartDeployUtil.isWarmdeployMode((S2Container)container));
    }

    public void tearDownWarmdeployMode() {
        S2ContainerBehavior.setProvider((S2ContainerBehavior.Provider)new S2ContainerBehavior.DefaultProvider());
    }
}

