/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.DestroyMethodDef;
import org.seasar.framework.container.IllegalDestroyMethodAnnotationRuntimeException;
import org.seasar.framework.container.IllegalInitMethodAnnotationRuntimeException;
import org.seasar.framework.container.InitMethodDef;
import org.seasar.framework.container.InterTypeDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.assembler.AutoBindingDefFactory;
import org.seasar.framework.container.assembler.BindingTypeDefFactory;
import org.seasar.framework.container.deployer.InstanceDefFactory;
import org.seasar.framework.container.factory.ConstantAnnotationHandler;
import org.seasar.framework.container.ognl.OgnlExpression;
import org.seasar.framework.unit.S2FrameworkTestCase;

public class ConstantAnnotationHandlerTest
extends S2FrameworkTestCase {
    private ConstantAnnotationHandler handler = new ConstantAnnotationHandler();

    public void testCreateComponentDef() throws Exception {
        ConstantAnnotationHandlerTest.assertNotNull((Object)this.handler.createComponentDef(Hoge.class, null));
        ComponentDef cd = this.handler.createComponentDef(Hoge2.class, null);
        ConstantAnnotationHandlerTest.assertEquals((String)"aaa", (String)cd.getComponentName());
        ConstantAnnotationHandlerTest.assertEquals((Object)InstanceDefFactory.PROTOTYPE, (Object)cd.getInstanceDef());
        ConstantAnnotationHandlerTest.assertEquals((Object)AutoBindingDefFactory.PROPERTY, (Object)cd.getAutoBindingDef());
        ConstantAnnotationHandlerTest.assertTrue((boolean)cd.isExternalBinding());
        ComponentDef cd2 = this.handler.createComponentDef(Hoge.class, InstanceDefFactory.REQUEST);
        ConstantAnnotationHandlerTest.assertEquals((Object)InstanceDefFactory.REQUEST, (Object)cd2.getInstanceDef());
        try {
            this.handler.createComponentDef(Hoge3.class, null);
            ConstantAnnotationHandlerTest.fail();
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex.getMessage());
        }
    }

    public void testCreatePropertyDef() throws Exception {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)Hoge.class);
        PropertyDesc propDesc = beanDesc.getPropertyDesc("aaa");
        ConstantAnnotationHandlerTest.assertNull((String)"1", (Object)this.handler.createPropertyDef(beanDesc, propDesc));
        beanDesc = BeanDescFactory.getBeanDesc((Class)Hoge2.class);
        propDesc = beanDesc.getPropertyDesc("aaa");
        PropertyDef propDef = this.handler.createPropertyDef(beanDesc, propDesc);
        ConstantAnnotationHandlerTest.assertEquals((String)"2", (String)"aaa", (String)propDef.getPropertyName());
        ConstantAnnotationHandlerTest.assertEquals((String)"3", (String)"aaa2", (String)((OgnlExpression)propDef.getExpression()).getSource());
        propDesc = beanDesc.getPropertyDesc("bbb");
        propDef = this.handler.createPropertyDef(beanDesc, propDesc);
        ConstantAnnotationHandlerTest.assertEquals((String)"4", (Object)BindingTypeDefFactory.NONE, (Object)propDef.getBindingTypeDef());
    }

    public void setUpAppendAspect() {
        this.include("aop.dicon");
    }

    public void testAppendAspect() throws Exception {
        ComponentDef cd = this.handler.createComponentDef(Hoge.class, null);
        this.handler.appendAspect(cd);
        ConstantAnnotationHandlerTest.assertEquals((String)"1", (int)1, (int)cd.getAspectDefSize());
        AspectDef aspectDef = cd.getAspectDef(0);
        ConstantAnnotationHandlerTest.assertEquals((String)"2", (String)"aop.traceInterceptor", (String)((OgnlExpression)aspectDef.getExpression()).getSource());
    }

    public void testAppendAspect2() throws Exception {
        ComponentDef cd = this.handler.createComponentDef(Hoge2.class, null);
        this.handler.appendAspect(cd);
        ConstantAnnotationHandlerTest.assertEquals((String)"1", (int)1, (int)cd.getAspectDefSize());
        AspectDef aspectDef = cd.getAspectDef(0);
        ConstantAnnotationHandlerTest.assertEquals((String)"2", (String)"aop.traceInterceptor", (String)((OgnlExpression)aspectDef.getExpression()).getSource());
    }

    public void testAppendInterType() throws Exception {
        ComponentDef cd = this.handler.createComponentDef(Hoge.class, null);
        this.handler.appendInterType(cd);
        ConstantAnnotationHandlerTest.assertEquals((String)"1", (int)1, (int)cd.getInterTypeDefSize());
        InterTypeDef interTypeDef = cd.getInterTypeDef(0);
        ConstantAnnotationHandlerTest.assertEquals((String)"2", (String)"fieldInterType", (String)((OgnlExpression)interTypeDef.getExpression()).getSource());
    }

    public void testAppendInitMethod() throws Exception {
        ComponentDef cd = this.handler.createComponentDef(Hoge.class, null);
        this.handler.appendInitMethod(cd);
        ConstantAnnotationHandlerTest.assertEquals((String)"1", (int)1, (int)cd.getInitMethodDefSize());
        InitMethodDef initMethodDef = cd.getInitMethodDef(0);
        ConstantAnnotationHandlerTest.assertEquals((String)"2", (String)"init", (String)initMethodDef.getMethodName());
    }

    public void testAppendInitMethodForException() throws Exception {
        ComponentDef cd;
        try {
            cd = this.handler.createComponentDef(Hoge4.class, null);
            this.handler.appendInitMethod(cd);
            ConstantAnnotationHandlerTest.fail((String)"1");
        }
        catch (IllegalInitMethodAnnotationRuntimeException ex) {
            System.out.println((Object)ex);
        }
        try {
            cd = this.handler.createComponentDef(Hoge5.class, null);
            this.handler.appendInitMethod(cd);
            ConstantAnnotationHandlerTest.fail((String)"2");
        }
        catch (IllegalInitMethodAnnotationRuntimeException ex) {
            System.out.println((Object)ex);
        }
    }

    public void testAppendDestroyMethod() throws Exception {
        ComponentDef cd = this.handler.createComponentDef(Hoge.class, null);
        this.handler.appendDestroyMethod(cd);
        ConstantAnnotationHandlerTest.assertEquals((String)"1", (int)1, (int)cd.getDestroyMethodDefSize());
        DestroyMethodDef destroyMethodDef = cd.getDestroyMethodDef(0);
        ConstantAnnotationHandlerTest.assertEquals((String)"2", (String)"destroy", (String)destroyMethodDef.getMethodName());
    }

    public void testAppendDestroyMethodForException() throws Exception {
        ComponentDef cd;
        try {
            cd = this.handler.createComponentDef(Hoge4.class, null);
            this.handler.appendDestroyMethod(cd);
            ConstantAnnotationHandlerTest.fail((String)"1");
        }
        catch (IllegalDestroyMethodAnnotationRuntimeException ex) {
            System.out.println((Object)ex);
        }
        try {
            cd = this.handler.createComponentDef(Hoge5.class, null);
            this.handler.appendDestroyMethod(cd);
            ConstantAnnotationHandlerTest.fail((String)"2");
        }
        catch (IllegalDestroyMethodAnnotationRuntimeException ex) {
            System.out.println((Object)ex);
        }
    }

    public void testNotMistakeAsConstantAnnotation1() throws Exception {
        ComponentDef cd = this.handler.createComponentDef(Hoge6.class, null);
        ConstantAnnotationHandlerTest.assertEquals(null, (String)cd.getComponentName());
    }

    public void testNotMistakeAsConstantAnnotation2() throws Exception {
        ComponentDef cd = this.handler.createComponentDef(Hoge7.class, null);
        ConstantAnnotationHandlerTest.assertEquals(null, (String)cd.getComponentName());
    }

    public void testNotMistakeAsConstantAnnotation3() throws Exception {
        ComponentDef cd = this.handler.createComponentDef(Hoge8.class, null);
        ConstantAnnotationHandlerTest.assertEquals(null, (String)cd.getComponentName());
    }

    public void testNotMistakeAsConstantAnnotation4() throws Exception {
        ComponentDef cd = this.handler.createComponentDef(Hoge9.class, null);
        ConstantAnnotationHandlerTest.assertEquals(null, (String)cd.getComponentName());
    }

    public void testNotMistakeAsConstantAnnotation5() throws Exception {
        ComponentDef cd = this.handler.createComponentDef(Hoge10.class, null);
        ConstantAnnotationHandlerTest.assertEquals(null, (String)cd.getComponentName());
    }

    public void testNotMistakeAsConstantAnnotation6() throws Exception {
        ComponentDef cd = this.handler.createComponentDef(Hoge11.class, null);
        ConstantAnnotationHandlerTest.assertEquals(null, (String)cd.getComponentName());
    }

    public static class Hoge11 {
        protected static final String COMPONENT = "name = a";
        protected static final String ASPECT = "a";
        protected static final String INIT_METHOD = "a";
    }

    public static class Hoge10 {
        public final String COMPONENT = "name = a";
        public final String ASPECT = "a";
        public final String INIT_METHOD = "a";
    }

    public static class Hoge9 {
        public static String COMPONENT = "name = a";
        public static String ASPECT;
        public static String INIT_METHOD;
    }

    public static class Hoge8 {
        public String COMPONENT = "name = a";
        public String ASPECT;
        public String INIT_METHOD;
    }

    public static class Hoge7 {
        protected String COMPONENT = "name = a";
        protected String ASPECT;
        protected String INIT_METHOD;
    }

    public static class Hoge6 {
        protected String component = "name = a";
        protected String aspect;
        protected String init_method;
    }

    public static class Hoge5 {
        public static final String INIT_METHOD = "init";
        public static final String DESTROY_METHOD = "destroy";

        public void init(String s) {
        }

        public void destroy(String s) {
        }
    }

    public static class Hoge4 {
        public static final String INIT_METHOD = "xxx";
        public static final String DESTROY_METHOD = "xxx";
    }

    public static class Hoge3 {
        public static final String COMPONENT = "dummy = aaa";
    }

    public static class Hoge2 {
        public static final String ASPECT = "aop.traceInterceptor";
        public static final String COMPONENT = "name = aaa, instance = prototype, autoBinding = property, externalBinding = true";
        public static final String aaa_BINDING = "aaa2";
        public static final String bbb_BINDING = "bindingType=none";
        public static final String ccc_BINDING = null;

        public void setAaa(String aaa) {
        }

        public void setBbb(String bbb) {
        }

        public void setCcc(String ccc) {
        }
    }

    public static class Hoge {
        public static final String INIT_METHOD = "init";
        public static final String DESTROY_METHOD = "destroy";
        private boolean inited = false;
        private boolean destroyed = false;
        public static final String ASPECT = "value=aop.traceInterceptor, pointcut=getAaa\ngetBbb";
        public static final String INTER_TYPE = "fieldInterType";

        public String getAaa() {
            return null;
        }

        public void init() {
            this.inited = true;
        }

        public boolean isInited() {
            return this.inited;
        }

        public void destroy() {
            this.destroyed = true;
        }

        public boolean isDestroyed() {
            return this.destroyed;
        }
    }
}

