/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.deployer;

import java.util.HashMap;
import junit.framework.TestCase;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.deployer.PrototypeComponentDeployer;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;

public class PrototypeComponentDeployerTest
extends TestCase {
    public void testDeployAutoAutoConstructor() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A.class);
        container.register((ComponentDef)cd);
        container.register(B.class);
        PrototypeComponentDeployer deployer = new PrototypeComponentDeployer((ComponentDef)cd);
        A a = (A)deployer.deploy();
        PrototypeComponentDeployerTest.assertEquals((String)"1", (String)"B", (String)a.getHogeName());
        PrototypeComponentDeployerTest.assertEquals((String)"2", (boolean)false, (a == deployer.deploy() ? 1 : 0) != 0);
    }

    public void testCyclicReference() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A2.class);
        ComponentDefImpl cd2 = new ComponentDefImpl(C.class);
        container.register((ComponentDef)cd);
        container.register((ComponentDef)cd2);
        PrototypeComponentDeployer deployer = new PrototypeComponentDeployer((ComponentDef)cd);
        PrototypeComponentDeployer deployer2 = new PrototypeComponentDeployer((ComponentDef)cd2);
        A2 a2 = (A2)deployer.deploy();
        C c = (C)deployer2.deploy();
        PrototypeComponentDeployerTest.assertEquals((String)"1", (String)"C", (String)a2.getHogeName());
        PrototypeComponentDeployerTest.assertEquals((String)"2", (String)"C", (String)c.getHogeName());
    }

    public void testInjectDependency() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(HashMap.class);
        container.register((ComponentDef)cd);
        PrototypeComponentDeployer deployer = new PrototypeComponentDeployer((ComponentDef)cd);
        try {
            deployer.injectDependency(new HashMap());
            PrototypeComponentDeployerTest.fail((String)"1");
        }
        catch (UnsupportedOperationException ex) {
            System.out.println(ex);
        }
    }

    public static class C
    implements Hoge {
        private Foo foo_;

        public void setFoo(Foo foo) {
            this.foo_ = foo;
        }

        public String getName() {
            return "C";
        }

        public String getHogeName() {
            return this.foo_.getHogeName();
        }
    }

    public static class B
    implements Hoge {
        public String getName() {
            return "B";
        }
    }

    public static interface Hoge {
        public String getName();
    }

    public static class A2
    implements Foo {
        private Hoge hoge_;

        public void setHoge(Hoge hoge) {
            this.hoge_ = hoge;
        }

        public String getHogeName() {
            return this.hoge_.getName();
        }
    }

    public static class A {
        private Hoge hoge_;

        public A(Hoge hoge) {
            this.hoge_ = hoge;
        }

        public String getHogeName() {
            return this.hoge_.getName();
        }
    }

    public static interface Foo {
        public String getHogeName();
    }
}

