/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.assembler;

import junit.framework.TestCase;
import org.seasar.framework.beans.IllegalPropertyRuntimeException;
import org.seasar.framework.beans.PropertyNotFoundRuntimeException;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.Expression;
import org.seasar.framework.container.ExternalContext;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.assembler.AccessTypeDefFactory;
import org.seasar.framework.container.assembler.AutoBindingDefFactory;
import org.seasar.framework.container.assembler.AutoPropertyAssembler;
import org.seasar.framework.container.assembler.SemiAutoPropertyAssembler;
import org.seasar.framework.container.external.servlet.HttpServletExternalContext;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.PropertyDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.container.ognl.OgnlExpression;
import org.seasar.framework.mock.servlet.MockHttpServletRequest;
import org.seasar.framework.mock.servlet.MockServletContextImpl;

public class SemiAutoPropertyAssemblerTest
extends TestCase {
    public void testAssemble() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A.class);
        ComponentDefImpl cd2 = new ComponentDefImpl(B.class, "hoge");
        PropertyDefImpl pd = new PropertyDefImpl("hoge");
        pd.setExpression((Expression)new OgnlExpression("hoge"));
        cd.addPropertyDef((PropertyDef)pd);
        container.register((ComponentDef)cd);
        container.register((ComponentDef)cd2);
        SemiAutoPropertyAssembler assembler = new SemiAutoPropertyAssembler((ComponentDef)cd);
        A a = new A();
        assembler.assemble((Object)a);
        SemiAutoPropertyAssemblerTest.assertEquals((String)"1", (String)"B", (String)a.getHogeName());
    }

    public void testAssembleForField() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(C.class);
        PropertyDefImpl pd = new PropertyDefImpl("aaa");
        pd.setAccessTypeDef(AccessTypeDefFactory.FIELD);
        cd.addPropertyDef((PropertyDef)pd);
        container.register((ComponentDef)cd);
        container.register((Object)"a", "aaa");
        SemiAutoPropertyAssembler assembler = new SemiAutoPropertyAssembler((ComponentDef)cd);
        C c = new C();
        assembler.assemble((Object)c);
        SemiAutoPropertyAssemblerTest.assertEquals((String)"1", (String)"a", (String)c.aaa);
    }

    public void testAssembleForField2() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(D.class);
        ComponentDefImpl cd2 = new ComponentDefImpl(B.class, "hoge2");
        PropertyDefImpl pd = new PropertyDefImpl("hoge");
        pd.setAccessTypeDef(AccessTypeDefFactory.FIELD);
        cd.addPropertyDef((PropertyDef)pd);
        container.register((ComponentDef)cd);
        container.register((ComponentDef)cd2);
        SemiAutoPropertyAssembler assembler = new SemiAutoPropertyAssembler((ComponentDef)cd);
        D d = new D();
        assembler.assemble((Object)d);
        SemiAutoPropertyAssemblerTest.assertEquals((String)"1", (String)"B", (String)d.getHogeName());
    }

    public void testAssembleIllegalProperty() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A.class);
        PropertyDefImpl pd = new PropertyDefImpl("hoge");
        pd.setExpression((Expression)new OgnlExpression("b"));
        cd.addPropertyDef((PropertyDef)pd);
        container.register((ComponentDef)cd);
        SemiAutoPropertyAssembler assembler = new SemiAutoPropertyAssembler((ComponentDef)cd);
        A a = new A();
        try {
            assembler.assemble((Object)a);
            SemiAutoPropertyAssemblerTest.fail((String)"1");
        }
        catch (IllegalPropertyRuntimeException ex) {
            System.out.println((Object)ex);
        }
    }

    public void testAssembleIllegalProperty2() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A.class);
        PropertyDefImpl pd = new PropertyDefImpl("abc", (Object)"111");
        cd.addPropertyDef((PropertyDef)pd);
        container.register((ComponentDef)cd);
        SemiAutoPropertyAssembler assembler = new SemiAutoPropertyAssembler((ComponentDef)cd);
        A a = new A();
        try {
            assembler.assemble((Object)a);
            SemiAutoPropertyAssemblerTest.fail((String)"1");
        }
        catch (PropertyNotFoundRuntimeException ex) {
            System.out.println((Object)ex);
        }
    }

    public void testAssembleIllegalProperty3() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(B.class);
        PropertyDefImpl pd = new PropertyDefImpl("aaa", (Object)"abc");
        cd.addPropertyDef((PropertyDef)pd);
        container.register((ComponentDef)cd);
        SemiAutoPropertyAssembler assembler = new SemiAutoPropertyAssembler((ComponentDef)cd);
        B b = new B();
        try {
            assembler.assemble((Object)b);
            SemiAutoPropertyAssemblerTest.fail((String)"1");
        }
        catch (IllegalPropertyRuntimeException ex) {
            System.out.println((Object)ex);
        }
    }

    public void testAssembleWhenComponentNull() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(D.class);
        ComponentDefImpl cd2 = new ComponentDefImpl(B.class, "hoge2");
        PropertyDefImpl pd = new PropertyDefImpl("hoge");
        cd.addPropertyDef((PropertyDef)pd);
        container.register((ComponentDef)cd);
        container.register((ComponentDef)cd2);
        SemiAutoPropertyAssembler assembler = new SemiAutoPropertyAssembler((ComponentDef)cd);
        assembler.assemble(null);
    }

    public void testBindExternally() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(E.class);
        cd.setAutoBindingDef(AutoBindingDefFactory.NONE);
        cd.setExternalBinding(true);
        container.register((ComponentDef)cd);
        HttpServletExternalContext extCtx = new HttpServletExternalContext();
        MockServletContextImpl servletContext = new MockServletContextImpl("s2-example");
        MockHttpServletRequest request = servletContext.createRequest("/hello.html");
        request.setParameter("name", "aaa");
        extCtx.setRequest((Object)request);
        container.setExternalContext((ExternalContext)extCtx);
        AutoPropertyAssembler assembler = new AutoPropertyAssembler((ComponentDef)cd);
        E e = new E();
        assembler.assemble((Object)e);
        SemiAutoPropertyAssemblerTest.assertEquals((String)"1", (String)"aaa", (String)e.getName());
    }

    public static class E {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class D
    implements Foo {
        private Hoge hoge;

        public String getHogeName() {
            return this.hoge.getName();
        }
    }

    public static class C {
        private String aaa;
    }

    public static class B
    implements Hoge {
        public String getName() {
            return "B";
        }

        public void setAaa(int aaa) {
        }
    }

    public static interface Hoge {
        public String getName();
    }

    public static class A
    implements Foo {
        private Hoge hoge_;

        public Hoge getHoge() {
            return this.hoge_;
        }

        public void setHoge(Hoge hoge) {
            this.hoge_ = hoge;
        }

        public String getHogeName() {
            return this.hoge_.getName();
        }
    }

    public static interface Foo {
        public String getHogeName();
    }
}

