/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.j2ee;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import org.seasar.extension.j2ee.JndiResourceLocator;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.exception.SRuntimeException;
import org.seasar.framework.util.StringUtil;

public class JndiContext
implements Context {
    protected final Hashtable env;
    protected final String path;

    public JndiContext(Hashtable env) {
        this.env = env;
        this.path = (String)env.get("java.naming.provider.url");
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.env.put(propName, propVal);
    }

    public void bind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new NamingException("name is empty");
        }
        this.bind(JndiResourceLocator.resolveName(name), obj);
    }

    public void bind(String name, Object obj) throws NamingException {
        this.bind(JndiResourceLocator.resolveName(name).split("\\."), obj);
    }

    public void close() throws NamingException {
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new OperationNotSupportedException("composeName");
    }

    public String composeName(String name, String prefix) throws NamingException {
        throw new OperationNotSupportedException("composeName");
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("createSubcontext");
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("createSubcontext");
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("destroySubcontext");
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("destroySubcontext");
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.env;
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("getNameInNamespace");
    }

    public NameParser getNameParser(Name name) throws NamingException {
        throw new OperationNotSupportedException("getNameParser");
    }

    public NameParser getNameParser(String name) throws NamingException {
        throw new OperationNotSupportedException("getNameParser");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        throw new OperationNotSupportedException("list");
    }

    public NamingEnumeration list(String name) throws NamingException {
        throw new OperationNotSupportedException("list");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        throw new OperationNotSupportedException("listBindings");
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        throw new OperationNotSupportedException("listBindings");
    }

    public Object lookup(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new JndiContext(new Hashtable(this.env));
        }
        return this.lookup(name.toString());
    }

    public Object lookup(String name) throws NamingException {
        if (StringUtil.isEmpty((String)name)) {
            return new JndiContext(new Hashtable(this.env));
        }
        return SingletonS2ContainerFactory.getContainer().getComponent((Object)JndiResourceLocator.resolveName(name));
    }

    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException("lookupLink");
    }

    public Object lookupLink(String name) throws NamingException {
        throw new OperationNotSupportedException("lookupLink");
    }

    public void rebind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException("rebind");
    }

    public void rebind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException("rebind");
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.env.remove(propName);
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        throw new OperationNotSupportedException("rename");
    }

    public void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException("rename");
    }

    public void unbind(Name name) throws NamingException {
        throw new OperationNotSupportedException("unbind");
    }

    public void unbind(String name) throws NamingException {
        throw new OperationNotSupportedException("unbind");
    }

    protected void bind(String[] names, Object obj) throws NamingException {
        StringBuffer buf = new StringBuffer(100);
        try {
            S2Container context = SingletonS2ContainerFactory.getContainer();
            for (int i = 0; i < names.length - 1; ++i) {
                buf.append(names[i]);
                context = (S2Container)context.getComponent((Object)names[i]);
                buf.append('/');
            }
            String name = names[names.length - 1];
            buf.append(name);
            if (context.hasComponentDef((Object)name)) {
                throw new NameAlreadyBoundException(new String(buf));
            }
            context.register(obj, name);
        }
        catch (ComponentNotFoundRuntimeException e) {
            throw this.createNamingException(new String(buf), e);
        }
        catch (SRuntimeException e) {
            throw this.createNamingException(e.getMessage(), e);
        }
    }

    protected NamingException createNamingException(String message, Throwable cause) {
        NamingException e = new NamingException(message);
        e.initCause(cause);
        return e;
    }
}

