create table department(department_id integer not null primary key, department_no integer not null unique,department_name varchar(20),location varchar(20) default 'tokyo', version integer);
create table address(address_id integer not null primary key, street varchar(20), version integer);
create table employee(employee_id integer not null primary key, employee_no integer not null ,employee_name varchar(20),manager_id integer,hiredate date,salary numeric(7,2),department_id integer,address_id integer,version integer, constraint fk_department_id foreign key(department_id) references department(department_id), constraint fk_address_id foreign key(address_id) references address(address_id));
create table comp_key_department(department_id1 integer not null, department_id2 integer not null, department_no integer not null unique,department_name varchar(20),location varchar(20) default 'tokyo', version integer, constraint pk_comp_key_department primary key(department_id1, department_id2));
create table comp_key_address(address_id1 integer not null, address_id2 integer not null, street varchar(20), version integer, constraint pk_comp_key_address primary key(address_id1, address_id2));
create table comp_key_employee(employee_id1 integer not null, employee_id2 integer not null, employee_no integer not null ,employee_name varchar(20),manager_id1 integer,manager_id2 integer,hiredate date,salary numeric(7,2),department_id1 integer,department_id2 integer,address_id1 integer,address_id2 integer,version integer, constraint pk_comp_key_employee primary key(employee_id1, employee_id2), constraint fk_comp_key_department_id foreign key(department_id1, department_id2) references comp_key_department(department_id1, department_id2), constraint fk_comp_key_address_id foreign key(address_id1, address_id2) references comp_key_address(address_id1, address_id2));
alter table employee add constraint employee_uk1 unique (address_id);
alter table comp_key_employee add constraint comp_key_employee_uk1 unique (address_id1, address_id2);

comment on table address is '住所';
comment on column address.address_id is '識別子';
comment on column address.street is 'ストリート';
comment on column address.version is 'バージョン';

-- supported
create table integer_table (integer_column integer);
create table int_table (int_column int);
create table mediumint_table (mediumint_column mediumint);
create table int4_table (int4_column int4);
create table signed_table (signed_column signed);
create table double_table (double_column double);
create table double_precision_table (double_precision_column double precision);
create table float_table (float_column float);
create table float4_table (float4_column float4);
create table float8_table (float8_column float8);
create table varchar_table (varchar_column varchar);
create table varchar_ignorecase_table (varchar_ignorecase_column varchar_ignorecase);
create table varchar2_table (varchar2_column varchar2);
create table nvarchar_table (nvarchar_column nvarchar);
create table nvarchar2_table (nvarchar2_column nvarchar2);
create table varchar_casesensitive_table (varchar_casesensitive_column varchar_casesensitive);
create table char_table (char_column char);
create table character_table (character_column character);
create table nchar_table (nchar_column nchar);
create table longvarchar_table (longvarchar_column longvarchar);
create table date_table (date_column date);
create table time_table (time_column time);
create table timestamp_table (timestamp_column timestamp);
create table datetime_table (datetime_column datetime);
create table smalldatetime_table (smalldatetime_column smalldatetime);
create table decimal_table (decimal_column decimal);
create table dec_table (dec_column dec);
create table numeric_table (numeric_column numeric);
create table number_table (number_column number);
create table boolean_table (boolean_column boolean);
create table bit_table (bit_column bit);
create table bool_table (bool_column bool);
create table tinyint_table (tinyint_column tinyint);
create table smallint_table (smallint_column smallint);
create table int2_table (smallint_column int2);
create table year_table (year_column year);
create table bigint_table (bigint_column bigint);
create table int8_table (int8_column int8);
create table real_table (real_column real);
create table binary_table (binary_column binary);
create table varbinary_table (varbinary_column varbinary);
create table raw_table (raw_column raw);
create table bytea_table (bytea_column bytea);
create table longvarbinary_table (longvarbinary_column longvarbinary);
create table identity_table (identity_column identity);
create table blob_table (blob_column blob);
create table tinyblob_table (tinyblob_column tinyblob);
create table mediumblob_table (mediumblob_column mediumblob);
create table longblob_table (longblob_column longblob);
create table image_table (image_column image);
create table oid_table (oid_column oid);
create table clob_table (clob_column clob);
create table tinytext_table (tinytext_column tinytext);
create table text_table (text_column text);
create table mediumtext_table (mediumtext_column mediumtext);
create table longtext_table (longtext_column longtext);
create table ntext_table (ntext_column ntext);
create table nclob_table (nclob_column nclob);
create table テーブル (カラム varchar(255));
