/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.meta;

import java.lang.reflect.Field;
import javax.persistence.Column;
import org.seasar.extension.jdbc.ColumnMeta;
import org.seasar.extension.jdbc.ColumnMetaFactory;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.convention.PersistenceConvention;
import org.seasar.framework.util.StringUtil;

public class ColumnMetaFactoryImpl
implements ColumnMetaFactory {
    private PersistenceConvention persistenceConvention;

    public ColumnMeta createColumnMeta(Field field, EntityMeta entityMeta, PropertyMeta propertyMeta) {
        ColumnMeta columnMeta = new ColumnMeta();
        String defaultName = this.persistenceConvention.fromPropertyNameToColumnName(propertyMeta.getName());
        Column column = field.getAnnotation(Column.class);
        if (column != null) {
            String name = column.name();
            if (StringUtil.isEmpty((String)name)) {
                name = defaultName;
            }
            columnMeta.setName(name);
            columnMeta.setInsertable(column.insertable());
            columnMeta.setUpdatable(column.updatable());
        } else {
            columnMeta.setName(defaultName);
        }
        return columnMeta;
    }

    public PersistenceConvention getPersistenceConvention() {
        return this.persistenceConvention;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setPersistenceConvention(PersistenceConvention persistenceConvention) {
        this.persistenceConvention = persistenceConvention;
    }
}

