/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.codec.PNGImageEncoder;
import org.apache.batik.svggen.DefaultImageHandler;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.apache.batik.svggen.SVGGraphics2DRuntimeException;
import org.apache.batik.util.Base64EncoderStream;
import org.w3c.dom.Element;

public class ImageHandlerBase64Encoder
extends DefaultImageHandler {
    public void handleHREF(Image image, Element element, SVGGeneratorContext sVGGeneratorContext) throws SVGGraphics2DIOException {
        if (image == null) {
            throw new SVGGraphics2DRuntimeException("image should not be null");
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (n == 0 || n2 == 0) {
            this.handleEmptyImage(element);
        } else if (image instanceof RenderedImage) {
            this.handleHREF((RenderedImage)((Object)image), element, sVGGeneratorContext);
        } else {
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
            this.handleHREF(bufferedImage, element, sVGGeneratorContext);
        }
    }

    public void handleHREF(RenderableImage renderableImage, Element element, SVGGeneratorContext sVGGeneratorContext) throws SVGGraphics2DIOException {
        if (renderableImage == null) {
            throw new SVGGraphics2DRuntimeException("image should not be null");
        }
        RenderedImage renderedImage = renderableImage.createDefaultRendering();
        if (renderedImage == null) {
            this.handleEmptyImage(element);
        } else {
            this.handleHREF(renderedImage, element, sVGGeneratorContext);
        }
    }

    protected void handleEmptyImage(Element element) {
        element.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "data:image/png;base64,");
        element.setAttributeNS(null, "width", "0");
        element.setAttributeNS(null, "height", "0");
    }

    public void handleHREF(RenderedImage renderedImage, Element element, SVGGeneratorContext sVGGeneratorContext) throws SVGGraphics2DIOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Base64EncoderStream base64EncoderStream = new Base64EncoderStream(byteArrayOutputStream);
        try {
            this.encodeImage(renderedImage, base64EncoderStream);
            base64EncoderStream.close();
        }
        catch (IOException iOException) {
            throw new SVGGraphics2DIOException("unexpected exception", iOException);
        }
        element.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "data:image/png;base64," + byteArrayOutputStream.toString());
    }

    public void encodeImage(RenderedImage renderedImage, OutputStream outputStream) throws SVGGraphics2DIOException {
        try {
            PNGImageEncoder pNGImageEncoder = new PNGImageEncoder(outputStream, null);
            pNGImageEncoder.encode(renderedImage);
        }
        catch (IOException iOException) {
            throw new SVGGraphics2DIOException("unexpected exception");
        }
    }

    public BufferedImage buildBufferedImage(Dimension dimension) {
        return new BufferedImage(dimension.width, dimension.height, 2);
    }
}

