/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.pagination.LayoutMasterSet;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.fo.pagination.RegionAfter;
import org.apache.fop.fo.pagination.RegionBefore;
import org.apache.fop.fo.pagination.RegionEnd;
import org.apache.fop.fo.pagination.RegionStart;
import org.apache.fop.layout.BodyRegionArea;
import org.apache.fop.layout.MarginProps;
import org.apache.fop.layout.PageMaster;

public class SimplePageMaster
extends FObj {
    private static final int FALLBACK_PAGE_HEIGHT = 792000;
    private static final int FALLBACK_PAGE_WIDTH = 576000;
    private HashMap _regions;
    LayoutMasterSet layoutMasterSet;
    PageMaster pageMaster;
    String masterName;
    boolean beforePrecedence = false;
    int beforeExtent;
    int afterExtent;
    int startExtent;
    int endExtent;
    boolean afterPrecedence = false;

    protected SimplePageMaster(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
        super(parent, propertyList, systemId, line, column);
        if (parent.getName().equals("fo:layout-master-set")) {
            this.layoutMasterSet = (LayoutMasterSet)parent;
            this.masterName = this.properties.get("master-name").getString();
            if (this.masterName == null) {
                this.log.warn("simple-page-master does not have a master-name and so is being ignored");
            } else {
                this.layoutMasterSet.addSimplePageMaster(this);
            }
        } else {
            throw new FOPException("fo:simple-page-master must be child of fo:layout-master-set, not " + parent.getName(), systemId, line, column);
        }
        this._regions = new HashMap();
    }

    protected void addRegion(Region region) throws FOPException {
        if (this._regions.containsKey(region.getRegionClass())) {
            throw new FOPException("Only one region of class " + region.getRegionClass() + " allowed within a simple-page-master.", this.systemId, this.line, this.column);
        }
        this._regions.put(region.getRegionClass(), region);
    }

    protected void end() {
        Length pageWidthLen = this.properties.get("page-width").getLength();
        int pageWidth = pageWidthLen.isAuto() ? 576000 : pageWidthLen.mvalue();
        Length pageHeightLen = this.properties.get("page-height").getLength();
        int pageHeight = pageHeightLen.isAuto() ? 792000 : pageHeightLen.mvalue();
        MarginProps mProps = this.propMgr.getMarginProps();
        int contentRectangleXPosition = mProps.marginLeft;
        int contentRectangleYPosition = pageHeight - mProps.marginTop;
        int contentRectangleWidth = pageWidth - mProps.marginLeft - mProps.marginRight;
        int contentRectangleHeight = pageHeight - mProps.marginTop - mProps.marginBottom;
        this.pageMaster = new PageMaster(pageWidth, pageHeight);
        Region body = this.getRegion("body");
        RegionBefore before = (RegionBefore)this.getRegion("before");
        RegionAfter after = (RegionAfter)this.getRegion("after");
        RegionStart start = (RegionStart)this.getRegion("start");
        RegionEnd end = (RegionEnd)this.getRegion("end");
        if (before != null) {
            this.beforePrecedence = before.getPrecedence();
            this.beforeExtent = before.getExtent();
        }
        if (after != null) {
            this.afterPrecedence = after.getPrecedence();
            this.afterExtent = after.getExtent();
        }
        if (start != null) {
            this.startExtent = start.getExtent();
        }
        if (end != null) {
            this.endExtent = end.getExtent();
        }
        if (body != null) {
            this.pageMaster.addBody((BodyRegionArea)body.makeRegionArea(contentRectangleXPosition, contentRectangleYPosition, contentRectangleWidth, contentRectangleHeight));
        } else {
            this.log.error("simple-page-master must have a region of class body");
        }
        if (before != null) {
            this.pageMaster.addBefore(before.makeRegionArea(contentRectangleXPosition, contentRectangleYPosition, contentRectangleWidth, contentRectangleHeight, this.startExtent, this.endExtent));
        }
        if (after != null) {
            this.pageMaster.addAfter(after.makeRegionArea(contentRectangleXPosition, contentRectangleYPosition, contentRectangleWidth, contentRectangleHeight, this.startExtent, this.endExtent));
        }
        if (start != null) {
            this.pageMaster.addStart(start.makeRegionArea(contentRectangleXPosition, contentRectangleYPosition, contentRectangleWidth, contentRectangleHeight, this.beforePrecedence, this.afterPrecedence, this.beforeExtent, this.afterExtent));
        }
        if (end != null) {
            this.pageMaster.addEnd(end.makeRegionArea(contentRectangleXPosition, contentRectangleYPosition, contentRectangleWidth, contentRectangleHeight, this.beforePrecedence, this.afterPrecedence, this.beforeExtent, this.afterExtent));
        }
    }

    public String getMasterName() {
        return this.masterName;
    }

    public String getName() {
        return "fo:simple-page-master";
    }

    public PageMaster getNextPageMaster() {
        return this.pageMaster;
    }

    public PageMaster getPageMaster() {
        return this.pageMaster;
    }

    protected Region getRegion(String regionClass) {
        return (Region)this._regions.get(regionClass);
    }

    protected HashMap getRegions() {
        return this._regions;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    protected boolean regionNameExists(String regionName) {
        Iterator i = this._regions.values().iterator();
        while (i.hasNext()) {
            Region r = (Region)i.next();
            if (!r.getRegionName().equals(regionName)) continue;
            return true;
        }
        return false;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new SimplePageMaster(parent, propertyList, systemId, line, column);
        }
    }
}

