/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.io.IOException;
import java.sql.SQLException;
import org.h2.command.CommandInterface;
import org.h2.constant.SysProperties;
import org.h2.engine.SessionInterface;
import org.h2.engine.SessionRemote;
import org.h2.expression.ParameterInterface;
import org.h2.expression.ParameterRemote;
import org.h2.message.Trace;
import org.h2.result.ResultInterface;
import org.h2.result.ResultRemote;
import org.h2.util.ObjectArray;
import org.h2.value.Transfer;

public class CommandRemote
implements CommandInterface {
    private final ObjectArray transferList;
    private final ObjectArray parameters;
    private final Trace trace;
    private final String sql;
    private SessionRemote session;
    private int id;
    private boolean isQuery;
    private boolean readonly;
    private int paramCount;

    public CommandRemote(SessionRemote session, ObjectArray transferList, String sql) throws SQLException {
        this.transferList = transferList;
        this.trace = session.getTrace();
        this.sql = sql;
        this.parameters = new ObjectArray();
        this.prepare(session);
        for (int i = 0; i < this.paramCount; ++i) {
            this.parameters.add(new ParameterRemote(i));
        }
        this.session = session;
    }

    private void prepare(SessionRemote session) throws SQLException {
        this.id = session.getNextId();
        this.paramCount = 0;
        for (int i = 0; i < this.transferList.size(); ++i) {
            try {
                Transfer transfer = (Transfer)this.transferList.get(i);
                session.traceOperation("SESSION_PREPARE", this.id);
                transfer.writeInt(0).writeInt(this.id).writeString(this.sql);
                session.done(transfer);
                this.isQuery = transfer.readBoolean();
                this.readonly = transfer.readBoolean();
                this.paramCount = transfer.readInt();
                continue;
            }
            catch (IOException e) {
                session.removeServer(i--);
            }
        }
    }

    public boolean isQuery() {
        return this.isQuery;
    }

    public ObjectArray getParameters() {
        return this.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultInterface getMetaData() throws SQLException {
        SessionRemote sessionRemote = this.session;
        synchronized (sessionRemote) {
            this.session.checkClosed();
            if (!this.isQuery) {
                return null;
            }
            if (this.id <= this.session.getCurrentId() - SysProperties.SERVER_CACHED_OBJECTS) {
                this.prepare(this.session);
            }
            int objectId = this.session.getNextId();
            ResultRemote result = null;
            for (int i = 0; i < this.transferList.size(); ++i) {
                Transfer transfer = (Transfer)this.transferList.get(i);
                try {
                    this.session.traceOperation("COMMAND_GET_META_DATA", this.id);
                    transfer.writeInt(10).writeInt(this.id).writeInt(objectId);
                    this.session.done(transfer);
                    int columnCount = transfer.readInt();
                    result = new ResultRemote(this.session, transfer, objectId, columnCount, -1);
                    break;
                }
                catch (IOException e) {
                    this.session.removeServer(i--);
                    continue;
                }
            }
            this.session.autoCommitIfCluster();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultInterface executeQuery(int maxRows, boolean scrollable) throws SQLException {
        this.checkParameters();
        SessionRemote sessionRemote = this.session;
        synchronized (sessionRemote) {
            this.session.checkClosed();
            if (this.id <= this.session.getCurrentId() - SysProperties.SERVER_CACHED_OBJECTS) {
                this.prepare(this.session);
            }
            int objectId = this.session.getNextId();
            ResultRemote result = null;
            for (int i = 0; i < this.transferList.size(); ++i) {
                Transfer transfer = (Transfer)this.transferList.get(i);
                try {
                    this.session.traceOperation("COMMAND_EXECUTE_QUERY", this.id);
                    transfer.writeInt(2).writeInt(this.id).writeInt(objectId).writeInt(maxRows);
                    int readRows = this.session.isClustered() || scrollable ? Integer.MAX_VALUE : SysProperties.SERVER_SMALL_RESULT_SET_SIZE;
                    transfer.writeInt(readRows);
                    this.sendParameters(transfer);
                    this.session.done(transfer);
                    int columnCount = transfer.readInt();
                    if (result != null) {
                        result.close();
                        result = null;
                    }
                    result = new ResultRemote(this.session, transfer, objectId, columnCount, readRows);
                    if (!this.readonly) continue;
                    break;
                }
                catch (IOException e) {
                    this.session.removeServer(i--);
                }
            }
            this.session.autoCommitIfCluster();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws SQLException {
        this.checkParameters();
        SessionRemote sessionRemote = this.session;
        synchronized (sessionRemote) {
            this.session.checkClosed();
            if (this.id <= this.session.getCurrentId() - SysProperties.SERVER_CACHED_OBJECTS) {
                this.prepare(this.session);
            }
            int updateCount = 0;
            boolean autoCommit = false;
            for (int i = 0; i < this.transferList.size(); ++i) {
                try {
                    Transfer transfer = (Transfer)this.transferList.get(i);
                    this.session.traceOperation("COMMAND_EXECUTE_UPDATE", this.id);
                    transfer.writeInt(3).writeInt(this.id);
                    this.sendParameters(transfer);
                    this.session.done(transfer);
                    updateCount = transfer.readInt();
                    autoCommit = transfer.readBoolean();
                    continue;
                }
                catch (IOException e) {
                    this.session.removeServer(i--);
                }
            }
            this.session.setAutoCommit(autoCommit);
            this.session.autoCommitIfCluster();
            return updateCount;
        }
    }

    private void checkParameters() throws SQLException {
        int len = this.parameters.size();
        for (int i = 0; i < len; ++i) {
            ParameterInterface p = (ParameterInterface)this.parameters.get(i);
            p.checkSet();
        }
    }

    private void sendParameters(Transfer transfer) throws IOException, SQLException {
        int len = this.parameters.size();
        transfer.writeInt(len);
        for (int i = 0; i < len; ++i) {
            ParameterInterface p = (ParameterInterface)this.parameters.get(i);
            transfer.writeValue(p.getParamValue());
        }
    }

    public SessionInterface getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.session == null || this.session.isClosed()) {
            return;
        }
        SessionRemote sessionRemote = this.session;
        synchronized (sessionRemote) {
            for (int i = 0; i < this.transferList.size(); ++i) {
                try {
                    Transfer transfer = (Transfer)this.transferList.get(i);
                    this.session.traceOperation("COMMAND_CLOSE", this.id);
                    transfer.writeInt(4).writeInt(this.id);
                    continue;
                }
                catch (IOException e) {
                    this.trace.error("close", e);
                }
            }
            this.session = null;
        }
    }

    public void cancel() {
    }
}

