/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.Transaction;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.LongKeyIntValueHashMap;

public class TransactionManager {
    LongKeyIntValueHashMap rowSessionMap = new LongKeyIntValueHashMap(true);
    boolean reWriteProtect;

    TransactionManager() {
    }

    public void setReWriteProtection(boolean bl) {
        this.reWriteProtect = bl;
    }

    void checkDelete(Session session, Row row) throws HsqlException {
    }

    void checkDelete(Session session, HashMappedList hashMappedList) throws HsqlException {
        if (!this.reWriteProtect) {
            return;
        }
        int n = session.getId();
        int n2 = hashMappedList.size();
        for (int i = 0; i < n2; ++i) {
            Row row = (Row)hashMappedList.getKey(i);
            long l = row.getId();
            if (this.rowSessionMap.get(l, n) == n) continue;
            throw Trace.error(117, 122);
        }
    }

    void checkDelete(Session session, HsqlArrayList hsqlArrayList) throws HsqlException {
        if (!this.reWriteProtect) {
            return;
        }
        int n = session.getId();
        int n2 = hsqlArrayList.size();
        for (int i = 0; i < n2; ++i) {
            Row row = (Row)hsqlArrayList.get(i);
            long l = row.getId();
            if (this.rowSessionMap.get(l, n) == n) continue;
            throw Trace.error(117, 122);
        }
    }

    void commit(Session session) {
        Object[] objectArray = session.transactionList.getArray();
        int n = session.transactionList.size();
        for (int i = 0; i < n; ++i) {
            Transaction transaction = (Transaction)objectArray[i];
            long l = transaction.row.getId();
            transaction.commit(session);
            this.rowSessionMap.remove(l);
        }
        session.transactionList.clear();
        session.savepoints.clear();
    }

    synchronized void rollback(Session session) {
        this.rollbackTransactions(session, 0, false);
        session.savepoints.clear();
    }

    void rollbackSavepoint(Session session, String string) throws HsqlException {
        int n = session.savepoints.getIndex(string);
        if (n < 1) {
            throw Trace.error(44, string);
        }
        Integer n2 = (Integer)session.savepoints.get(n);
        int n3 = n2;
        this.rollbackTransactions(session, n3, false);
        while (session.savepoints.size() > n) {
            session.savepoints.remove(session.savepoints.size() - 1);
        }
    }

    void rollbackTransactions(Session session, int n, boolean bl) {
        Transaction transaction;
        int n2;
        Object[] objectArray = session.transactionList.getArray();
        int n3 = session.transactionList.size();
        for (n2 = n3 - 1; n2 >= n; --n2) {
            transaction = (Transaction)objectArray[n2];
            transaction.rollback(session, false);
        }
        for (n2 = n; n2 < n3; ++n2) {
            transaction = (Transaction)objectArray[n2];
            long l = transaction.row.getId();
            this.rowSessionMap.remove(l);
        }
        session.transactionList.setSize(n);
    }

    void addTransaction(Session session, Transaction transaction) {
        if (this.reWriteProtect) {
            this.rowSessionMap.put(transaction.row.getId(), session.getId());
        }
    }

    /*
     * Unable to fully structure code
     */
    Transaction[] getTransactionList(Session[] var1_1) {
        var2_2 = new int[var1_1.length];
        var4_3 = 0;
        var5_4 = 0;
        for (var6_5 = 0; var6_5 < var1_1.length; ++var6_5) {
            var5_4 += var1_1[var6_5].getTransactionSize();
        }
        var3_7 = new Transaction[var5_4];
        block1: while (true) {
            var5_4 = 0;
            var6_6 = 0x7FFFFFFFFFFFFFFFL;
            var8_8 = 0;
            for (var9_10 = 0; var9_10 < var1_1.length; ++var9_10) {
                var10_11 = var1_1[var9_10].getTransactionSize();
                if (var2_2[var9_10] >= var10_11) continue;
                var11_13 = (Transaction)var1_1[var9_10].transactionList.get(var2_2[var9_10]);
                if (var11_13.SCN < var6_6) {
                    var6_6 = var11_13.SCN;
                    var8_8 = var9_10;
                }
                var5_4 = 1;
            }
            if (var5_4 == 0) break;
            var9_9 = var1_1[var8_8].transactionList;
            while (true) {
                if (var2_2[var8_8] >= var9_9.size()) continue block1;
                var10_12 = (Transaction)var9_9.get(var2_2[var8_8]);
                if (var10_12.SCN == var6_6 + 1L) {
                    ++var6_6;
                }
                if (var10_12.SCN == var6_6) ** break;
                continue block1;
                var3_7[var4_3++] = var10_12;
                v0 = var8_8;
                var2_2[v0] = var2_2[v0] + 1;
            }
            break;
        }
        return null;
    }
}

