/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.AbstractFlow;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;

public class StaticContent
extends AbstractFlow {
    protected StaticContent(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
        super(parent, propertyList, systemId, line, column);
        this.setFlowName(this.getProperty("flow-name").getString());
        this.pageSequence.addStaticContent(this);
    }

    public String getName() {
        return "fo:static-content";
    }

    public int layout(Area area, Region region) throws FOPException {
        int numChildren = this.children.size();
        String regionClass = "none";
        if (region != null) {
            regionClass = region.getRegionClass();
        } else if (this.getFlowName().equals("xsl-region-before")) {
            regionClass = "before";
        } else if (this.getFlowName().equals("xsl-region-after")) {
            regionClass = "after";
        } else if (this.getFlowName().equals("xsl-region-start")) {
            regionClass = "start";
        } else if (this.getFlowName().equals("xsl-region-end")) {
            regionClass = "end";
        }
        if (area instanceof AreaContainer) {
            ((AreaContainer)area).setAreaName(regionClass);
        }
        area.setAbsoluteHeight(0);
        this.setContentWidth(area.getContentWidth());
        int i = 0;
        while (i < numChildren) {
            FObj fo = (FObj)this.children.get(i);
            int status = fo.layout(area);
            if (Status.isIncomplete(status)) {
                this.log.warn("Some static content could not fit in the area.");
                this.marker = i;
                if (i != 0 && status == 2) {
                    status = 3;
                }
                return status;
            }
            ++i;
        }
        this.resetMarker();
        return 1;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    protected void setFlowName(String name) throws FOPException {
        if (name == null || name.equals("")) {
            throw new FOPException("A 'flow-name' is required for " + this.getName() + ".", this.systemId, this.line, this.column);
        }
        this._flowName = name;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new StaticContent(parent, propertyList, systemId, line, column);
        }
    }
}

