/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ddf;

import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;
import org.apache.poi.ddf.EscherSerializationListener;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class EscherSplitMenuColorsRecord
extends EscherRecord {
    public static final short RECORD_ID = -3810;
    public static final String RECORD_DESCRIPTION = "MsofbtSplitMenuColors";
    private int field_1_color1;
    private int field_2_color2;
    private int field_3_color3;
    private int field_4_color4;

    public int fillFields(byte[] data, int offset, EscherRecordFactory recordFactory) {
        int bytesRemaining = this.readHeader(data, offset);
        int pos = offset + 8;
        int size = 0;
        this.field_1_color1 = LittleEndian.getInt(data, pos + size);
        this.field_2_color2 = LittleEndian.getInt(data, pos + (size += 4));
        this.field_3_color3 = LittleEndian.getInt(data, pos + (size += 4));
        this.field_4_color4 = LittleEndian.getInt(data, pos + (size += 4));
        if ((bytesRemaining -= (size += 4)) != 0) {
            throw new RecordFormatException("Expecting no remaining data but got " + bytesRemaining + " byte(s).");
        }
        return 8 + size + bytesRemaining;
    }

    public int serialize(int offset, byte[] data, EscherSerializationListener listener) {
        listener.beforeRecordSerialize(offset, this.getRecordId(), this);
        int pos = offset;
        LittleEndian.putShort(data, pos, this.getOptions());
        LittleEndian.putShort(data, pos += 2, this.getRecordId());
        int remainingBytes = this.getRecordSize() - 8;
        LittleEndian.putInt(data, pos += 2, remainingBytes);
        LittleEndian.putInt(data, pos += 4, this.field_1_color1);
        LittleEndian.putInt(data, pos += 4, this.field_2_color2);
        LittleEndian.putInt(data, pos += 4, this.field_3_color3);
        LittleEndian.putInt(data, pos += 4, this.field_4_color4);
        listener.afterRecordSerialize(pos += 4, this.getRecordId(), pos - offset, this);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 24;
    }

    public short getRecordId() {
        return -3810;
    }

    public String getRecordName() {
        return "SplitMenuColors";
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        return this.getClass().getName() + ":" + nl + "  RecordId: 0x" + HexDump.toHex((short)-3810) + nl + "  Options: 0x" + HexDump.toHex(this.getOptions()) + nl + "  Color1: 0x" + HexDump.toHex(this.field_1_color1) + nl + "  Color2: 0x" + HexDump.toHex(this.field_2_color2) + nl + "  Color3: 0x" + HexDump.toHex(this.field_3_color3) + nl + "  Color4: 0x" + HexDump.toHex(this.field_4_color4) + nl + "";
    }

    public int getColor1() {
        return this.field_1_color1;
    }

    public void setColor1(int field_1_color1) {
        this.field_1_color1 = field_1_color1;
    }

    public int getColor2() {
        return this.field_2_color2;
    }

    public void setColor2(int field_2_color2) {
        this.field_2_color2 = field_2_color2;
    }

    public int getColor3() {
        return this.field_3_color3;
    }

    public void setColor3(int field_3_color3) {
        this.field_3_color3 = field_3_color3;
    }

    public int getColor4() {
        return this.field_4_color4;
    }

    public void setColor4(int field_4_color4) {
        this.field_4_color4 = field_4_color4;
    }
}

